/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.genemania.dw.tools.IdentifierMapperService;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchEntrezReader {
    protected static final String LOOKUP_NUC = "NUC";
    protected static final String LOOKUP_PRO = "PRO";
    private static final String REPLACE_ANNOT = "The record has been replaced by";
    private static final String RENAME_ANNOT = "Chain renamed from (blank) to A during PDB remediation 2007";
    private static TreeMap<String, String> IDMap = new TreeMap();
    private static TreeMap<String, String> IDMapRev = new TreeMap();
    private static TreeMap<String, String> IDNucMap = new TreeMap();
    private static TreeMap<String, String> IDProMap = new TreeMap();
    private static ArrayList<String> annotList = new ArrayList();
    private static int stCnt;
    private static int replacedCnt;
    private static int renamedCnt;
    private static int removedCnt;

    private BatchEntrezReader() {
    }

    public static TreeMap<String, String> read(String inputFileName, String propFileName, String sourceType, String targetType) throws IOException {
        String line;
        GenUtil.validateString(inputFileName);
        GenUtil.validateString(sourceType);
        BufferedReader br = new BufferedReader(new FileReader(inputFileName));
        String ID1Str = null;
        String ID2Str = null;
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            if (line.indexOf(":") < 0) {
                if ((line = line.trim()).indexOf(" ") != -1) {
                    System.err.println("ERROR 1: Bad format for parsed file: " + line);
                }
                if (ID1Str.equals(line)) {
                    System.err.println("ERROR 2: Bad format for parsed file: " + ID1Str + " " + line.trim());
                }
                BatchEntrezReader.addMappedIDs(ID2Str, line, targetType);
                ID1Str = null;
                ID2Str = null;
                continue;
            }
            String entryNum = line.substring(0, line.indexOf(":"));
            try {
                Integer.parseInt(entryNum);
            }
            catch (NumberFormatException nfo) {
                System.err.println("ERROR 3: Bad format for parsed file.");
                nfo.printStackTrace();
                continue;
            }
            line = line.substring(line.indexOf(":") + 1).trim();
            ID1Str = line.substring(0, line.indexOf(" ")).trim();
            ID2Str = line.substring(line.lastIndexOf("[") + 1, line.lastIndexOf("]"));
            String IDTypeParsed = ID2Str.substring(0, ID2Str.indexOf(":"));
            if (!IDTypeParsed.equals(sourceType)) {
                System.err.println("ERROR 4: ID types not matched: " + IDTypeParsed + " " + sourceType);
            }
            ID2Str = ID2Str.substring(ID2Str.indexOf(":") + 1).trim();
            if ((line = line.substring(line.indexOf("]") + 1).trim()).length() == 0) {
                BatchEntrezReader.addMappedIDs(ID2Str, ID1Str, targetType);
                ++stCnt;
                ID1Str = null;
                ID2Str = null;
            } else {
                if (line.equals(REPLACE_ANNOT)) {
                    ++replacedCnt;
                    continue;
                }
                if (line.equals(RENAME_ANNOT)) {
                    BatchEntrezReader.addMappedIDs(ID2Str, ID1Str, targetType);
                    ++renamedCnt;
                    ID1Str = null;
                    ID2Str = null;
                } else {
                    ++removedCnt;
                    ID1Str = null;
                    ID2Str = null;
                }
            }
            if (line.length() <= 0 || annotList.contains(line)) continue;
            annotList.add(line);
        }
        if (LOOKUP_NUC.equals(targetType)) {
            return IDNucMap;
        }
        if (LOOKUP_PRO.equals(targetType)) {
            return IDProMap;
        }
        System.err.println("Error 6: Unknown target type: " + targetType);
        return IDMap;
    }

    private static void addMappedIDs(String ID1, String ID2, String targetType) {
        if (IDMap.containsKey(ID1)) {
            System.err.println("ERROR 5: ID listed twice: " + ID1);
        }
        IDMap.put(ID1, ID2);
        String existingID1 = IDMapRev.get(ID2);
        if (existingID1 != null) {
            ID1 = existingID1 + ";" + ID1;
        }
        IDMapRev.put(ID2, ID1);
        if (LOOKUP_NUC.equals(targetType)) {
            if (IDNucMap.containsKey(ID1)) {
                System.err.println("ERROR 5: ID listed twice: " + ID1);
            }
            IDNucMap.put(ID1, ID2);
        } else if (LOOKUP_PRO.equals(targetType)) {
            if (IDProMap.containsKey(ID1)) {
                System.err.println("ERROR 5: ID listed twice: " + ID1);
            }
            IDProMap.put(ID1, ID2);
        } else {
            System.err.println("Error 6: Unknown target type: " + targetType);
        }
    }

    public static TreeMap<String, String> getMappedIDs() {
        return IDMap;
    }

    public static TreeMap<String, String> getMappedIDs(String targetType) {
        if (LOOKUP_NUC.equals(targetType)) {
            return IDNucMap;
        }
        if (LOOKUP_PRO.equals(targetType)) {
            return IDProMap;
        }
        System.err.println("Error 6: Unknown target type: " + targetType);
        return IDMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeMap<String, ArrayList<String>> getSupMappedIDs() {
        TreeMap<String, ArrayList<String>> supMap = new TreeMap<String, ArrayList<String>>();
        try {
            String line;
            String supOutputFileName = DefParams.getDefaultProp("SuppFile1");
            BufferedReader br = new BufferedReader(new FileReader(supOutputFileName));
            TreeMap<String, ArrayList> loadedMap = new TreeMap<String, ArrayList>();
            while ((line = br.readLine()) != null) {
                String[] tempArr = line.split("\t");
                ArrayList tempList = !loadedMap.containsKey(tempArr[0]) ? new ArrayList() : (ArrayList)loadedMap.get(tempArr[0]);
                tempList.add(tempArr[1]);
                loadedMap.put(tempArr[0], tempList);
            }
            br.close();
            TreeMap<String, String> IDProRefined = new TreeMap<String, String>();
            for (String key : IDProMap.keySet()) {
                boolean isRefSeqPro = false;
                for (int i = 0; i < IdentifierMapperService.REFSEQ_PRO_PREFIX_ARR.length; ++i) {
                    if (!IDProMap.get(key).startsWith(IdentifierMapperService.REFSEQ_PRO_PREFIX_ARR[i])) continue;
                    isRefSeqPro = true;
                    break;
                }
                if (!isRefSeqPro) continue;
                if (IDProRefined.containsKey(IDProMap.get(key))) {
                    System.err.println("Error 7: Duplicate entries for " + IDProMap.get(key));
                }
                IDProRefined.put(IDProMap.get(key), key);
            }
            for (String key : loadedMap.keySet()) {
                String newKey = (String)IDProRefined.get(key);
                if (newKey == null) {
                    System.err.println("Error 8: Inconsistent results. Missing: " + key + " " + newKey);
                }
                ArrayList<Object> tempList = !supMap.containsKey(newKey) ? new ArrayList() : supMap.get(newKey);
                tempList.addAll((Collection)loadedMap.get(key));
                supMap.put(newKey, tempList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return supMap;
        }
    }

    public static void clear() {
        IDMap.clear();
        IDMapRev.clear();
        IDNucMap.clear();
        IDProMap.clear();
        annotList.clear();
    }

    private static void dumpAllAnnots() {
        System.out.println("CVs for all annot types: " + annotList.size());
        for (int i = 0; i < annotList.size(); ++i) {
            System.out.println(annotList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintWriter log = GenUtil.getDefaultLog();
        String usageMsg = "Usage: BatchEntrezReader IDType inputFileName1  inputFileName2";
        String warnMsg = "WARNING: Missing command line args, using defaults";
        if (args == null || args.length == 0) {
            log.println(warnMsg);
            log.println(usageMsg);
            System.out.println(warnMsg);
            System.out.println(usageMsg);
            args = DefParams.getCommandLineArgs(BatchEntrezReader.class.getName());
        }
        try {
            BatchEntrezReader.read(args[1], null, args[0], LOOKUP_NUC);
            BatchEntrezReader.read(args[2], null, args[0], LOOKUP_PRO);
            System.out.println("Counts: Total: " + IDMap.size());
            System.out.println("Found: " + (stCnt + renamedCnt));
            System.out.println("Replaced: " + replacedCnt);
            System.out.println("Removed: " + removedCnt);
        }
        catch (Throwable e) {
            e.printStackTrace();
            e.printStackTrace(log);
        }
        finally {
            log.flush();
            log.close();
        }
    }
}

