/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.tools;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.genemania.dw.tools.IVReportDetail;
import org.genemania.dw.util.DWUtil;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IVReportSummary {
    private String source;
    private String speciesName;
    private String validationType;
    private String IDType;
    private int numOfOccur;
    private int numTotal;
    private boolean isDisplayable;
    private ArrayList<IVReportDetail> IVDetSharedList = new ArrayList();
    private ArrayList<IVReportDetail> IVDetLOList = new ArrayList();
    private ArrayList<IVReportDetail> IVDetDepList = new ArrayList();

    protected IVReportSummary() {
        this.setIDType("N/A");
        this.setIsDisplayable(true);
    }

    protected void setSource(String source) {
        GenUtil.validateString(source);
        this.source = source;
    }

    protected void setSpeciesName(String speciesName) {
        if (!DWUtil.isSupportedSpecies(speciesName)) {
            throw new IllegalArgumentException("Unsupported species: " + speciesName);
        }
        this.speciesName = speciesName;
    }

    protected void setValidationType(String validationType) {
        if (!("Deprecated Identifier".equals(validationType) || "LeftOver Gene".equals(validationType) || "Shared Identifier".equals(validationType))) {
            throw new IllegalArgumentException("Invalid argument: " + validationType);
        }
        this.validationType = validationType;
    }

    protected void setIDType(String IDType) {
        GenUtil.validateString(IDType);
        this.IDType = IDType;
    }

    protected void incrementOccur() {
        ++this.numOfOccur;
    }

    protected void incrementTotal() {
        ++this.numTotal;
    }

    protected void setNumOfOccur(int numOfOccur) {
        GenUtil.validateNonNegativeInt(numOfOccur);
        this.numOfOccur = numOfOccur;
    }

    protected void setNumTotal(int numTotal) {
        GenUtil.validateNonNegativeInt(numTotal);
        this.numTotal = numTotal;
    }

    protected void setIsDisplayable(boolean isDisplayable) {
        this.isDisplayable = isDisplayable;
    }

    protected void setIVDetList(ArrayList<IVReportDetail> IVDetList, String validationType) {
        if (IVDetList == null) {
            throw new IllegalArgumentException("Invalid argument: " + IVDetList);
        }
        if ("Shared Identifier".equals(validationType)) {
            this.IVDetSharedList = IVDetList;
        } else if ("LeftOver Gene".equals(validationType)) {
            this.IVDetLOList = IVDetList;
        } else if ("Deprecated Identifier".equals(validationType)) {
            this.IVDetDepList = IVDetList;
        } else {
            throw new IllegalArgumentException("Unsupported validation type: " + validationType);
        }
    }

    protected String getSource() {
        return this.source;
    }

    protected String getSpeciesName() {
        return this.speciesName;
    }

    protected String getValidationType() {
        return this.validationType;
    }

    protected String getIDType() {
        return this.IDType;
    }

    protected int getNumOfOccur() {
        return this.numOfOccur;
    }

    protected int getNumTotal() {
        return this.numTotal;
    }

    protected boolean isDisplayable() {
        if (this.getSpeciesName().equals("Ec")) {
            return true;
        }
        return this.isDisplayable;
    }

    protected ArrayList<IVReportDetail> getIVDetList(String validationType) {
        if ("Shared Identifier".equals(validationType)) {
            return this.IVDetSharedList;
        }
        if ("LeftOver Gene".equals(validationType)) {
            return this.IVDetLOList;
        }
        if ("Deprecated Identifier".equals(validationType)) {
            return this.IVDetDepList;
        }
        throw new IllegalArgumentException("Unsupported validation type: " + validationType);
    }

    public String toString() {
        String tempStr = "";
        tempStr = tempStr + this.getSource();
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getSpeciesName() + " (" + DWUtil.getTaxIDByName(this.getSpeciesName()) + ")";
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getValidationType();
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getIDType();
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getNumOfOccur();
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getNumTotal();
        return tempStr;
    }

    protected void toStringDetailShared(BufferedWriter bw) throws IOException {
        this.toStringDetail("Shared Identifier", this.IVDetSharedList, bw);
    }

    protected void toStringDetailLO(BufferedWriter bw) throws IOException {
        this.toStringDetail("LeftOver Gene", this.IVDetLOList, bw);
    }

    protected void toStringDetailDep(BufferedWriter bw) throws IOException {
        this.toStringDetail("Deprecated Identifier", this.IVDetDepList, bw);
    }

    private void toStringDetail(String validationType, ArrayList<IVReportDetail> IVDetList, BufferedWriter bw) throws IOException {
        for (int i = 0; i < IVDetList.size(); ++i) {
            String tempStr = this.getSource();
            tempStr = tempStr + "\t";
            tempStr = tempStr + this.getSpeciesName() + " (" + DWUtil.getTaxIDByName(this.getSpeciesName()) + ")";
            tempStr = tempStr + "\t";
            if ("Shared Identifier".equals(validationType)) {
                tempStr = tempStr + IVDetList.get(i).toStringShared();
            } else if ("LeftOver Gene".equals(validationType)) {
                tempStr = tempStr + IVDetList.get(i).toStringLO();
            } else if ("Deprecated Identifier".equals(validationType)) {
                tempStr = tempStr + IVDetList.get(i).toStringDep();
            }
            bw.write(tempStr);
            bw.newLine();
            bw.flush();
        }
    }
}

