/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.genemania.dw.entity.EnsemblGene;
import org.genemania.dw.entity.EntrezGene;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.entity.TAIRGene;
import org.genemania.dw.tools.IdentifierValidator;
import org.genemania.dw.util.DWUtil;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierMapper {
    public static final String ENS_TO_ENTREZ = "ENSEMBL_ENTREZ";
    public static final String ENTREZ_TO_ENS = "ENTREZ_ENSEMBL";
    public static final String ENTREZ_TO_TAIR = "ENTREZ_TAIR";
    public static final String ENTREZ_ECOLI = "ENTREZ_ECOLI";
    public static final String TAIR_TO_ENTREZ = "TAIR_ENTREZ";
    private static ArrayList<String> mappingTypesList = new ArrayList();
    private static PrintWriter log;
    private String fileName;
    private String mappingType;
    private String speciesName;
    private boolean saveLocal;
    private IdentifierValidator IDValidator;

    public IdentifierMapper() {
        log = GenUtil.getDefaultLog();
        this.IDValidator = new IdentifierValidator();
    }

    private void setMappingType(String mappingType) {
        if (!mappingTypesList.contains(mappingType)) {
            throw new IllegalArgumentException("Unsupported identifier mapping: " + mappingType);
        }
        this.mappingType = mappingType;
    }

    private void setFileName(String fileName) {
        GenUtil.validateString(fileName);
        this.fileName = fileName;
    }

    private void setSpeciesName(String speciesName) {
        if (!DWUtil.isSupportedSpecies(speciesName)) {
            throw new IllegalArgumentException("Unsupported species: " + speciesName);
        }
        this.speciesName = speciesName;
    }

    private void setSaveLocal(boolean saveLocal) {
        this.saveLocal = saveLocal;
    }

    public void map(boolean saveLocal) throws IOException, SQLException {
        for (int i = 0; i < mappingTypesList.size(); ++i) {
            String currentMappingType = mappingTypesList.get(i);
            if (currentMappingType.equals(ENTREZ_TO_ENS) || currentMappingType.equals(TAIR_TO_ENTREZ)) continue;
            ArrayList<String> speciesList = DWUtil.getSpeciesAbbNames();
            for (int j = 0; j < speciesList.size(); ++j) {
                String currentSpeciesName = speciesList.get(j);
                if (currentSpeciesName.equals("At") && !currentMappingType.equals(TAIR_TO_ENTREZ) && !currentMappingType.equals(ENTREZ_TO_TAIR) || (currentMappingType.equals(TAIR_TO_ENTREZ) || currentMappingType.equals(ENTREZ_TO_TAIR)) && !currentSpeciesName.equals("At") || currentSpeciesName.equals("Ec") && !currentMappingType.equals(ENTREZ_ECOLI) || currentMappingType.equals(ENTREZ_ECOLI) && !currentSpeciesName.equals("Ec")) continue;
                System.out.println(currentMappingType + " " + currentSpeciesName);
                try {
                    this.map(currentMappingType, currentSpeciesName, saveLocal);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void map(String mappingType, String speciesName, boolean saveLocal) throws IOException, SQLException {
        String defPathName = DefParams.getDefaultProp("DefToolsPath");
        String defFileName = defPathName + mappingType + "_" + speciesName;
        log.println("Using default output file name:");
        log.println(defFileName);
        this.map(mappingType, speciesName, saveLocal, defFileName);
    }

    public void map(String mappingType, String speciesName, boolean saveLocal, String fileName) throws IOException, SQLException {
        this.setMappingType(mappingType);
        this.setFileName(fileName);
        this.setSpeciesName(speciesName);
        this.setSaveLocal(saveLocal);
        if (speciesName.equals("At") && !mappingType.equals(TAIR_TO_ENTREZ) && !mappingType.equals(ENTREZ_TO_TAIR)) {
            throw new IllegalArgumentException("Can only map between Entrez and TAIR for the 'At' species");
        }
        if ((mappingType.equals(TAIR_TO_ENTREZ) || mappingType.equals(ENTREZ_TO_TAIR)) && !speciesName.equals("At")) {
            throw new IllegalArgumentException("Can only map between Entrez and TAIR for the 'At' species");
        }
        if (speciesName.equals("Ec") && !mappingType.equals(ENTREZ_ECOLI)) {
            throw new IllegalArgumentException("Can only map from Entrez for the 'Ec' species");
        }
        if (mappingType.equals(ENTREZ_ECOLI) && !speciesName.equals("Ec")) {
            throw new IllegalArgumentException("Can only map from Entrez for the 'Ec' species");
        }
        if (ENS_TO_ENTREZ.equals(mappingType) || ENTREZ_TO_ENS.equals(mappingType)) {
            this.mapEnsemblEntrez();
        }
        if (ENTREZ_TO_TAIR.equals(mappingType) || TAIR_TO_ENTREZ.equals(mappingType)) {
            this.mapEntrezTAIR();
        }
        if (ENTREZ_ECOLI.equals(mappingType)) {
            this.mapEntrezEcoli();
        }
    }

    private void mapEnsemblEntrez() throws IOException, SQLException {
        TreeMap<String, ExtResource> leftOversMap;
        TreeMap<String, ExtResource> entMap;
        TreeMap<String, ExtResource> ensMap;
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.fileName));
        if (ENS_TO_ENTREZ.equals(this.mappingType)) {
            ensMap = EnsemblGene.loadAllExt(this.speciesName);
            entMap = EntrezGene.loadAllExt(this.speciesName);
            leftOversMap = this.validateNSave(ensMap, entMap);
            bw.write("GMID\tEnsembl Gene ID\tProtein Coding\tGene Name\tEnsembl Transcript ID\tEnsembl Protein ID\tUniprot ID\t");
            if ("Mm".equals(this.speciesName)) {
                bw.write("MGI ID\t");
            }
            bw.write("Entrez Gene ID\tRefSeq mRNA ID\tRefSeq Protein ID\tSynonyms\tDefinition");
            this.dumpEnsemblEntrez(bw, ensMap, leftOversMap);
        } else if (ENTREZ_TO_ENS.equals(this.mappingType)) {
            this.setSaveLocal(false);
            System.out.println("No persistence for 'bonus' mappings.");
            ensMap = EnsemblGene.loadAllExt(this.speciesName);
            entMap = EntrezGene.loadAllExt(this.speciesName);
            leftOversMap = this.validateNSave(entMap, ensMap);
            bw.write("GMID\tEntrez Gene ID\tProtein Coding\tEntrez Gene Name\tUniprot ID\t");
            if ("Mm".equals(this.speciesName)) {
                bw.write("MGI ID\t");
            }
            bw.write("Ensembl Gene ID\tRefSeq mRNA ID\tRefSeq Protein ID\tSynonyms\tDefinition");
            this.dumpEnsemblEntrez(bw, entMap, leftOversMap);
        }
        ensMap = null;
        entMap = null;
        leftOversMap = null;
        System.gc();
    }

    private void dumpEnsemblEntrez(BufferedWriter bw, TreeMap<String, ExtResource> extResMap, TreeMap<String, ExtResource> leftOversMap) throws IOException {
        ExtResource extResGene;
        bw.newLine();
        for (String extGeneID : extResMap.keySet()) {
            extResGene = extResMap.get(extGeneID);
            if (this.saveLocal && !"C".equals(extResGene.getStatus())) continue;
            bw.write(extResGene.toString());
            bw.newLine();
        }
        bw.flush();
        if (!this.IDValidator.isFixing()) {
            bw.close();
            return;
        }
        this.IDValidator.validate(leftOversMap, null, "Shared Identifier");
        for (String extGeneID : leftOversMap.keySet()) {
            extResGene = (ExtResourceGene)leftOversMap.get(extGeneID);
            if (this.saveLocal && !"C".equals(extResGene.getStatus())) continue;
            if (extResGene instanceof EnsemblGene) {
                bw.write(((ExtResourceGene)extResGene).toStringLeftOver("Entrez"));
            } else {
                bw.write(((ExtResourceGene)extResGene).toStringLeftOver("Ensembl"));
            }
            bw.newLine();
        }
        bw.flush();
        bw.close();
    }

    private void mapEntrezTAIR() throws IOException, SQLException {
        TreeMap<String, ExtResource> leftOversMap;
        TreeMap<String, ExtResource> tairMap;
        TreeMap<String, ExtResource> entMap;
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.fileName));
        if (ENTREZ_TO_TAIR.equals(this.mappingType)) {
            entMap = EntrezGene.loadAllExt(this.speciesName);
            tairMap = TAIRGene.loadAllExt();
            leftOversMap = this.validateNSave(entMap, tairMap);
            bw.write("GMID\tEntrez Gene ID\tProtein Coding\tGene Name\tUniprot ID\tTAIR Locus ID\tRefSeq mRNA ID\tRefSeq Protein ID\tSynonyms\tDefinition");
            bw.newLine();
            for (String entGeneID : entMap.keySet()) {
                ExtResource entGene = entMap.get(entGeneID);
                if (this.saveLocal && !"C".equals(entGene.getStatus())) continue;
                bw.write(((EntrezGene)entGene).toStringTAIR());
                bw.newLine();
            }
            bw.flush();
            this.dumpEntrezTAIRLeftOvers(bw, leftOversMap);
        } else if (TAIR_TO_ENTREZ.equals(this.mappingType)) {
            this.setSaveLocal(false);
            System.out.println("No persistence for 'bonus' mappings.");
            entMap = EntrezGene.loadAllExt(this.speciesName);
            tairMap = TAIRGene.loadAllExt();
            leftOversMap = this.validateNSave(tairMap, entMap);
            bw.write("GMID\tTAIR Locus ID\tProtein Coding\tTAIR Locus Name\tUniprot ID\tEntrez Gene ID\tRefSeq mRNA ID\tRefSeq Protein ID\tSynonyms\tDefinition");
            bw.newLine();
            for (String tairGeneID : tairMap.keySet()) {
                TAIRGene tairGene = (TAIRGene)tairMap.get(tairGeneID);
                if (this.saveLocal && !"C".equals(tairGene.getStatus())) continue;
                bw.write(tairGene.toString());
                bw.newLine();
            }
            bw.flush();
            this.dumpEntrezTAIRLeftOvers(bw, leftOversMap);
        }
        bw.flush();
        bw.close();
        entMap = null;
        tairMap = null;
        leftOversMap = null;
        System.gc();
    }

    private void dumpEntrezTAIRLeftOvers(BufferedWriter bw, TreeMap<String, ExtResource> leftOversMap) throws IOException {
        if (!this.IDValidator.isFixing()) {
            return;
        }
        for (String extResID : leftOversMap.keySet()) {
            ExtResourceGene extResGene = (ExtResourceGene)leftOversMap.get(extResID);
            if (this.saveLocal && !"C".equals(extResGene.getStatus())) continue;
            if (extResGene instanceof EntrezGene) {
                bw.write(extResGene.toStringLeftOver("TAIR"));
            } else {
                bw.write(extResGene.toStringLeftOver("Entrez"));
            }
            bw.newLine();
        }
    }

    private void mapEntrezEcoli() throws IOException, SQLException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.fileName));
        TreeMap<String, ExtResource> entMap = EntrezGene.loadAllExt(this.speciesName);
        this.validateNSave(entMap, null);
        bw.write("GMID\tEntrez Gene ID\tProtein Coding\tEntrez Gene Name\tUniprot ID\tRefSeq mRNA ID\tRefSeq Protein ID\tSynonyms\tDefinition");
        bw.newLine();
        for (String entGeneID : entMap.keySet()) {
            ExtResource entGene = entMap.get(entGeneID);
            if (this.saveLocal && !"C".equals(entGene.getStatus())) continue;
            bw.write(((EntrezGene)entGene).toStringEcoli());
            bw.newLine();
        }
        bw.flush();
        bw.close();
        entMap = null;
        System.gc();
    }

    private TreeMap<String, ExtResource> validateNSave(TreeMap<String, ExtResource> extResMap1, TreeMap<String, ExtResource> extResMap2) throws SQLException {
        if (extResMap2 != null) {
            this.IDValidator.validate(extResMap1, extResMap2);
        } else {
            this.IDValidator.validate(extResMap1, null, "Shared Identifier");
        }
        TreeMap<String, ExtResource> leftOversMap = new TreeMap();
        if (extResMap2 != null) {
            leftOversMap = this.IDValidator.getLeftOvers();
        }
        if (this.saveLocal) {
            System.out.println("Saving Summary - primary resource. ");
            ExtResourceGene.saveAll(extResMap1);
            if (leftOversMap.size() > 0 && this.IDValidator.isFixing()) {
                System.out.println("Saving Summary - leftovers. ");
                ExtResourceGene.saveAll(leftOversMap);
            }
            System.out.println("Saving done. ");
        }
        return leftOversMap;
    }

    public void dumpValidation() throws IOException {
        this.IDValidator.dump(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        log = GenUtil.getDefaultLog();
        log.println(GenUtil.getTimeStamp());
        GenUtil.registerStart();
        String usageMsg = "Usage: IdentifierMapper mappingType [ENSEMBL_ENTREZ|ENTREZ_ENSEMBL|ENTREZ_TAIR|TAIR_ENTREZ|ENTREZ_ECOLI]\n species [Hs|Mm|Rn|Ce|Sc|Dm|Ec|At] saveLocal [true|false] outputFileName OR \nALL saveLocal [true|false]";
        String warnMsg = "WARNING: Missing command line args, using defaults";
        if (args == null || args.length == 0) {
            log.println(warnMsg);
            log.println(usageMsg);
            System.out.println(warnMsg);
            System.out.println(usageMsg);
            args = DefParams.getCommandLineArgs(IdentifierMapper.class.getName());
        }
        try {
            IdentifierMapper mapper = new IdentifierMapper();
            if ("ALL".equals(args[0])) {
                mapper.map(Boolean.parseBoolean(args[1]));
            } else if (args.length == 4) {
                mapper.map(args[0], args[1], Boolean.parseBoolean(args[2]), args[3]);
            } else {
                mapper.map(args[0], args[1], Boolean.parseBoolean(args[2]));
            }
            mapper.dumpValidation();
        }
        catch (Throwable e) {
            e.printStackTrace();
            e.printStackTrace(log);
        }
        finally {
            log.println(GenUtil.getExecTimeStr());
            log.flush();
            log.close();
        }
    }

    static {
        mappingTypesList.add(ENS_TO_ENTREZ);
        mappingTypesList.add(ENTREZ_TO_ENS);
        mappingTypesList.add(ENTREZ_TO_TAIR);
        mappingTypesList.add(ENTREZ_ECOLI);
        mappingTypesList.add(TAIR_TO_ENTREZ);
    }
}

