/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.tools;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.Uniprot;
import org.genemania.dw.tools.BatchEntrezReader;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierMapperService {
    public static final String[] REFSEQ_RNA_PREFIX_ARR = new String[]{"NM", "NR", "XM", "XR"};
    public static final String[] REFSEQ_PRO_PREFIX_ARR = new String[]{"AP", "NP", "XP", "YP", "ZP"};
    public static final String[] REFSEQ_GENO_PREFIX_ARR = new String[]{"AC", "NC", "NG", "NT", "NW", "NZ", "NS"};
    public static final String LO_PROTEIN = "LO_PROTEIN";
    public static final String LO_GI_UNI = "LO_GI_UNI";
    private static PrintWriter log;
    private static boolean needSuppMappings;
    private static TreeMap<String, TreeMap<String, ExtResource>> uniMap;
    private static TreeMap<String, TreeMap<String, String>> GIUniMap;
    private static TreeMap<String, TreeMap<String, String>> entrezUniMap;
    private static TreeMap<String, String> GIRefSeqProMap;
    private static TreeMap<String, String> GIProMap;
    private static TreeMap<String, String> GIRefSeqMrnaMap;
    private static TreeMap<String, ArrayList<String>> GIUniSupMap;
    private static ArrayList<String> unmatchedGIUniList;
    private static ArrayList<String> matchedGIUniList;
    private static ArrayList<String> unmatchedEntrezUniList;
    private static ArrayList<String> matchedEntrezUniList;

    private IdentifierMapperService() {
        log = GenUtil.getDefaultLog();
    }

    public static void init(String[] resArr, int[] speciesIDArr) throws Exception {
        GenUtil.validateNotNull(resArr);
        for (int i = 0; i < resArr.length; ++i) {
            if ("Uniprot".equals(resArr[i])) {
                boolean indexFlag = false;
                if (speciesIDArr != null) {
                    for (int j = 0; j < speciesIDArr.length; ++j) {
                        if (uniMap.get(String.valueOf(speciesIDArr[j])) != null) continue;
                        System.out.println("Processing: " + resArr[i] + " " + speciesIDArr[j]);
                        TreeMap<String, ExtResource> uniSpeciesMap = Uniprot.loadAllExt(speciesIDArr[j]);
                        uniMap.put(String.valueOf(speciesIDArr[j]), uniSpeciesMap);
                        indexFlag = true;
                    }
                } else {
                    System.err.println("Loading for Uniprot is by species only.");
                }
                if (indexFlag) {
                    System.out.println("Indexing Uniprot by GI...");
                    IdentifierMapperService.indexUniprotByXref(speciesIDArr, "GI");
                    System.out.println("Indexing Uniprot by Entrez ID...");
                    IdentifierMapperService.indexUniprotByXref(speciesIDArr, "ExtID");
                }
            } else {
                throw new IllegalArgumentException("Unsupported resource type: " + resArr[i]);
            }
            System.out.println("Done init resource: " + resArr[i]);
        }
        if (needSuppMappings) {
            needSuppMappings = false;
            IdentifierMapperService.loadSupMappings();
        }
    }

    public static void flush(String[] resArr, int[] speciesIDArr) {
        GenUtil.validateNotNull(resArr);
        for (int i = 0; i < resArr.length; ++i) {
            if ("Uniprot".equals(resArr[i])) {
                if (speciesIDArr != null) {
                    for (int j = 0; j < speciesIDArr.length; ++j) {
                        uniMap.remove(String.valueOf(speciesIDArr[j]));
                        GIUniMap.remove(String.valueOf(speciesIDArr[j]));
                        entrezUniMap.remove(String.valueOf(speciesIDArr[j]));
                    }
                    continue;
                }
                uniMap.remove("ALL");
                GIUniMap.remove("ALL");
                entrezUniMap.remove("ALL");
                continue;
            }
            throw new IllegalArgumentException("Unsupported resource type: " + resArr[i]);
        }
    }

    private static void indexUniprotByXref(int[] speciesIDArr, String xrefType) {
        for (int i = 0; i < speciesIDArr.length; ++i) {
            TreeMap<String, String> xrefUniSpeciesMap = new TreeMap<String, String>();
            TreeMap<String, ExtResource> uniSpeciesMap = uniMap.get(String.valueOf(speciesIDArr[i]));
            for (String uniID : uniSpeciesMap.keySet()) {
                TreeMap<String, ExtResource> entrezMap;
                Uniprot uniEntry = (Uniprot)uniSpeciesMap.get(uniID);
                ArrayList<Object> xrefList = new ArrayList();
                if (xrefType.equals("GI")) {
                    xrefList = uniEntry.getGIList();
                } else if ("ExtID".equals(xrefType) && (entrezMap = uniEntry.getXRef("Entrez")) != null) {
                    xrefList.addAll(entrezMap.keySet());
                }
                for (int j = 0; j < xrefList.size(); ++j) {
                    String xrefID = (String)xrefList.get(j);
                    String otherUniID = (String)xrefUniSpeciesMap.get(xrefID);
                    if (otherUniID != null) {
                        xrefUniSpeciesMap.put(xrefID, otherUniID + ";" + uniID);
                        continue;
                    }
                    xrefUniSpeciesMap.put(xrefID, uniID);
                }
            }
            if (xrefType.equals("GI")) {
                GIUniMap.put(String.valueOf(speciesIDArr[i]), xrefUniSpeciesMap);
                continue;
            }
            if (!xrefType.equals("ExtID")) continue;
            entrezUniMap.put(String.valueOf(speciesIDArr[i]), xrefUniSpeciesMap);
        }
    }

    public static ArrayList<String> getUniprotIDByXref(String xrefType, String xrefID) {
        return IdentifierMapperService.getUniprotIDByXref(xrefType, xrefID, -1, false);
    }

    public static ArrayList<String> getUniprotIDByXref(String xrefType, String xrefID, int speciesID) {
        return IdentifierMapperService.getUniprotIDByXref(xrefType, xrefID, speciesID, true);
    }

    private static ArrayList<String> getUniprotIDByXref(String xrefType, String xrefID, int speciesID, boolean validateSpecies) {
        if (!"GI".equals(xrefType) && !"ExtID".equals(xrefType)) {
            throw new IllegalArgumentException("Unsupported x-ref type for Uniprot: " + xrefType);
        }
        GenUtil.validateString(xrefID);
        if (validateSpecies) {
            GenUtil.validatePositiveInt(speciesID);
        }
        ArrayList<String> uniIDList = new ArrayList<String>();
        boolean speciesMismatch = false;
        String uniIDStr = "";
        TreeMap<String, String> xrefUniMap = null;
        if ("GI".equals(xrefType)) {
            xrefUniMap = GIUniMap.get(String.valueOf(speciesID));
        } else if ("ExtID".equals(xrefType)) {
            xrefUniMap = entrezUniMap.get(String.valueOf(speciesID));
        }
        if (xrefUniMap != null) {
            uniIDStr = xrefUniMap.get(xrefID);
            if (uniIDStr != null) {
                String[] uniIDArr = uniIDStr.split(";");
                for (int i = 0; i < uniIDArr.length; ++i) {
                    uniIDList.add(uniIDArr[i]);
                }
            } else {
                speciesMismatch = true;
                uniIDStr = "";
            }
        }
        if (uniIDList.size() == 0) {
            TreeMap<String, ExtResource> uniprotMap = null;
            try {
                uniprotMap = Uniprot.mapToXref(xrefType, xrefID);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Unable to process request for: " + xrefID);
            }
            Iterator<String> iterator = uniprotMap.keySet().iterator();
            while (iterator.hasNext()) {
                Uniprot uniEntry = (Uniprot)uniprotMap.get(iterator.next());
                uniIDList.add(uniEntry.getID());
                uniIDStr = uniIDStr + uniEntry.getID() + ";";
            }
        }
        if ("GI".equals(xrefType)) {
            IdentifierMapperService.lookupSupMappings(xrefType, xrefID);
            if (uniIDList.size() == 0) {
                if (!unmatchedGIUniList.contains(xrefID)) {
                    unmatchedGIUniList.add(xrefID);
                }
            } else {
                if (!matchedGIUniList.contains(xrefID)) {
                    matchedGIUniList.add(xrefID);
                }
                if (speciesMismatch) {
                    // empty if block
                }
            }
        }
        if ("ExtID".equals(xrefType)) {
            if (uniIDList.size() == 0) {
                if (!unmatchedEntrezUniList.contains(xrefID)) {
                    unmatchedEntrezUniList.add(xrefID);
                }
            } else {
                if (!matchedEntrezUniList.contains(xrefID)) {
                    matchedEntrezUniList.add(xrefID);
                }
                if (speciesMismatch) {
                    // empty if block
                }
            }
        }
        return uniIDList;
    }

    public static void dumpUnmatchedUni(String xrefType) {
        block3: {
            block2: {
                if (!"GI".equals(xrefType)) break block2;
                System.out.println("Matched GI in Uniprot: " + matchedGIUniList.size());
                System.out.println("Unmatched GI in Uniprot: " + unmatchedGIUniList.size());
                for (int i = 0; i < unmatchedGIUniList.size(); ++i) {
                    System.out.println("No Uniprot match for GI: " + unmatchedGIUniList.get(i));
                }
                break block3;
            }
            if (!"ExtID".equals(xrefType)) break block3;
            System.out.println("Matched Entrez in Uniprot: " + matchedEntrezUniList.size());
            System.out.println("Unmatched Entrez in Uniprot: " + unmatchedEntrezUniList.size());
            for (int i = 0; i < unmatchedEntrezUniList.size(); ++i) {
                System.out.println("No Uniprot match for Entrez: " + unmatchedEntrezUniList.get(i));
            }
        }
    }

    private static void lookupSupMappings(String xrefType, String xrefID) {
        if (!"GI".equals(xrefType)) {
            return;
        }
        if (needSuppMappings) {
            needSuppMappings = false;
            IdentifierMapperService.loadSupMappings();
        }
    }

    private static void loadSupMappings() {
        BatchEntrezReader.clear();
        BatchEntrezReader.main(null);
        int cntRefSeq = 0;
        int cnt = 0;
        try {
            TreeMap<String, String> IDProMap = BatchEntrezReader.getMappedIDs("PRO");
            for (String key : IDProMap.keySet()) {
                boolean isRefSeqPro = false;
                for (int i = 0; i < REFSEQ_PRO_PREFIX_ARR.length; ++i) {
                    if (!IDProMap.get(key).startsWith(REFSEQ_PRO_PREFIX_ARR[i])) continue;
                    isRefSeqPro = true;
                    break;
                }
                if (isRefSeqPro) {
                    GIRefSeqProMap.put(key, IDProMap.get(key));
                    ++cntRefSeq;
                } else {
                    GIProMap.put(key, IDProMap.get(key));
                }
                ++cnt;
            }
            System.out.println("Count Pro Refseq: " + cntRefSeq + " " + cnt);
            cnt = 0;
            cntRefSeq = 0;
            GIUniSupMap = BatchEntrezReader.getSupMappedIDs();
            TreeMap<String, String> IDNucMap = BatchEntrezReader.getMappedIDs("NUC");
            for (String key : IDNucMap.keySet()) {
                boolean isRefSeqMrna = false;
                for (int i = 0; i < REFSEQ_RNA_PREFIX_ARR.length; ++i) {
                    if (!IDNucMap.get(key).startsWith(REFSEQ_RNA_PREFIX_ARR[i])) continue;
                    isRefSeqMrna = true;
                    break;
                }
                if (isRefSeqMrna) {
                    GIRefSeqMrnaMap.put(key, IDNucMap.get(key));
                    ++cntRefSeq;
                }
                ++cnt;
            }
            System.out.println("Count mRNA Refseq: " + cntRefSeq + " " + cnt);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Unable to process request.");
        }
    }

    public static ArrayList<String> getXrefLO(String sourceType, String sourceID, String targetType) {
        ArrayList<String> loList = new ArrayList<String>();
        if ("GI".equals(sourceType)) {
            if ("RefSeqPro".equals(targetType)) {
                if (GIRefSeqProMap.containsKey(sourceID)) {
                    loList.add(GIRefSeqProMap.get(sourceID));
                }
            } else if ("RefSeqRNA".equals(targetType)) {
                if (GIRefSeqMrnaMap.containsKey(sourceID)) {
                    loList.add(GIRefSeqMrnaMap.get(sourceID));
                }
            } else if (LO_PROTEIN.equals(targetType)) {
                if (GIProMap.containsKey(sourceID)) {
                    loList.add(GIProMap.get(sourceID));
                }
            } else if (LO_GI_UNI.equals(targetType) && GIUniSupMap.containsKey(sourceID)) {
                loList.addAll((Collection<String>)GIUniSupMap.get(sourceID));
            }
        } else {
            throw new IllegalArgumentException("Unsupported Left Over type: " + sourceType);
        }
        return loList;
    }

    static {
        needSuppMappings = true;
        uniMap = new TreeMap();
        GIUniMap = new TreeMap();
        entrezUniMap = new TreeMap();
        GIRefSeqProMap = new TreeMap();
        GIProMap = new TreeMap();
        GIRefSeqMrnaMap = new TreeMap();
        GIUniSupMap = new TreeMap();
        unmatchedGIUniList = new ArrayList();
        matchedGIUniList = new ArrayList();
        unmatchedEntrezUniList = new ArrayList();
        matchedEntrezUniList = new ArrayList();
    }
}

