/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.genemania.dw.entity.EnsemblGene;
import org.genemania.dw.entity.EntrezGene;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.entity.TAIRGene;
import org.genemania.dw.tools.IVReportDetail;
import org.genemania.dw.tools.IVReportSummary;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierValidator {
    public static final String VALID_TYPE_SHARED = "Shared Identifier";
    public static final String VALID_TYPE_LEFTOVER = "LeftOver Gene";
    public static final String VALID_TYPE_DEPRECATED = "Deprecated Identifier";
    private static PrintWriter log;
    private static ArrayList<String> validTypesList;
    private String validationType;
    private boolean fixFlag;
    private String summaryFileName;
    private String detailFileName;
    private TreeMap<String, ExtResource> leftOverMap;
    private BufferedWriter bwSum;
    private BufferedWriter bwDetShared;
    private BufferedWriter bwDetLO;
    private BufferedWriter bwDetDep;
    private ArrayList<IVReportSummary> IVSumList = new ArrayList();

    public IdentifierValidator() {
        log = GenUtil.getDefaultLog();
        this.setFixFlag(Boolean.parseBoolean(DefParams.getDefaultProp("DefIVFix")));
    }

    private void setValidationType(String validationType) {
        if (!validTypesList.contains(validationType)) {
            throw new IllegalArgumentException("Invalid argument: " + validationType);
        }
        this.validationType = validationType;
    }

    public void setFixFlag(boolean fixFlag) {
        this.fixFlag = fixFlag;
    }

    public void setSummaryFileName(String fileName) {
        GenUtil.validateString(fileName);
        this.summaryFileName = fileName;
    }

    public void setDetailFileName(String fileName) {
        GenUtil.validateString(fileName);
        this.detailFileName = fileName;
    }

    public String getSummaryFileName() {
        return this.summaryFileName;
    }

    public String getDetailFileName() {
        return this.detailFileName;
    }

    public boolean isFixing() {
        return this.fixFlag;
    }

    public TreeMap<String, ExtResource> getLeftOvers() {
        if (this.leftOverMap == null) {
            throw new IllegalStateException("Must run validation for leftOvers before retrieving them.");
        }
        return this.leftOverMap;
    }

    private void setOutputFiles() {
        if (this.getSummaryFileName() == null || this.getDetailFileName() == null) {
            String defPathName = DefParams.getDefaultProp("DefToolsPath");
            log.println("Using default output file names: ");
            if (this.getSummaryFileName() == null) {
                log.println("Summary File: " + defPathName + DefParams.getDefaultProp("DefIVReportSummary"));
                this.setSummaryFileName(defPathName + DefParams.getDefaultProp("DefIVReportSummary"));
            }
            if (this.getDetailFileName() == null) {
                log.println("Detailed File: " + defPathName + DefParams.getDefaultProp("DefIVReportDetail"));
                this.setDetailFileName(defPathName + DefParams.getDefaultProp("DefIVReportDetail"));
            }
        }
    }

    public void validate(TreeMap<String, ExtResource> extResMap1, TreeMap<String, ExtResource> extResMap2) {
        this.setOutputFiles();
        for (int i = 0; i < validTypesList.size(); ++i) {
            this.validate(extResMap1, extResMap2, validTypesList.get(i));
        }
    }

    public void validate(TreeMap<String, ExtResource> extResMap1, TreeMap<String, ExtResource> extResMap2, String validationType) {
        this.setValidationType(validationType);
        this.setOutputFiles();
        if (validationType.equals(VALID_TYPE_DEPRECATED)) {
            this.validateDeprecated(extResMap1, extResMap2);
        } else if (validationType.equals(VALID_TYPE_LEFTOVER)) {
            this.validateLeftOver(extResMap1, extResMap2);
        } else if (validationType.equals(VALID_TYPE_SHARED)) {
            this.validateShared(extResMap1, extResMap2);
        }
        this.dump(false);
    }

    private void validateShared(TreeMap<String, ExtResource> extResMap1, TreeMap<String, ExtResource> extResMap2) {
        System.out.println("Validating for: Shared Identifier");
        TreeMap<String, ArrayList<ExtResource>> geneNameMap = new TreeMap<String, ArrayList<ExtResource>>();
        TreeMap<String, ArrayList<ExtResource>> ensTransMap = new TreeMap<String, ArrayList<ExtResource>>();
        TreeMap<String, ArrayList<ExtResource>> ensProteinMap = new TreeMap<String, ArrayList<ExtResource>>();
        TreeMap<String, ArrayList<ExtResource>> refSeqMRNAMap = new TreeMap<String, ArrayList<ExtResource>>();
        TreeMap<String, ArrayList<ExtResource>> refSeqProMap = new TreeMap<String, ArrayList<ExtResource>>();
        TreeMap<String, ArrayList<ExtResource>> uniprotMap = new TreeMap<String, ArrayList<ExtResource>>();
        TreeMap<String, ArrayList<ExtResource>> MGDMap = new TreeMap<String, ArrayList<ExtResource>>();
        TreeMap<String, ArrayList<ExtResource>> xrefIDMap = new TreeMap<String, ArrayList<ExtResource>>();
        boolean trackStats = true;
        if (extResMap2 == null) {
            trackStats = false;
        }
        Iterator<String> iterator = extResMap1.keySet().iterator();
        String geneNameSource = null;
        String xrefSource = null;
        String source = null;
        String speciesName = null;
        boolean firstTime = true;
        while (iterator.hasNext()) {
            String extResID = iterator.next();
            ExtResource gene = extResMap1.get(extResID);
            boolean validateMGD = "Mm".equals(gene.getSpeciesName());
            if (gene instanceof EnsemblGene) {
                EnsemblGene ensGene = (EnsemblGene)gene;
                this.validateAttList(ensGene.getRefinedXrefList("RefSeqRNA"), ensGene, refSeqMRNAMap);
                this.validateAttList(ensGene.getRefinedXrefList("RefSeqPro"), ensGene, refSeqProMap);
                this.validateAttList(ensGene.getUniprotList(), ensGene, uniprotMap);
                if (validateMGD) {
                    this.validateAttList(ensGene.getMGDList(), ensGene, MGDMap);
                }
                this.validateAttList(ensGene.getTranscripts(), ensGene, ensTransMap);
                this.validateAttList(ensGene.getProteins(), ensGene, ensProteinMap);
                if (firstTime) {
                    geneNameSource = "Ensembl Gene Name";
                    source = "Ensembl";
                    speciesName = gene.getSpeciesName();
                    firstTime = false;
                }
            }
            if (gene instanceof EntrezGene) {
                EntrezGene entGene = (EntrezGene)gene;
                this.validateAttList(entGene.getUniprotList(), entGene, uniprotMap);
                if (validateMGD) {
                    this.validateAttList(entGene.getMGDList(), entGene, MGDMap);
                }
                this.validateAttList(entGene.getRefSeqRNAList(), entGene, refSeqMRNAMap);
                this.validateAttList(entGene.getRefSeqProList(), entGene, refSeqProMap);
                if (firstTime) {
                    geneNameSource = "Entrez Gene Name";
                    source = "Entrez";
                    speciesName = gene.getSpeciesName();
                    firstTime = false;
                }
            }
            if (gene instanceof TAIRGene) {
                TAIRGene tairGene = (TAIRGene)gene;
                this.validateAttList(tairGene.getRefinedXrefList("RefSeqRNA"), tairGene, refSeqMRNAMap);
                this.validateAttList(tairGene.getRefinedXrefList("RefSeqPro"), tairGene, refSeqProMap);
                this.validateAttList(tairGene.getRefinedXrefList("Uniprot"), tairGene, uniprotMap);
                if (firstTime) {
                    geneNameSource = "TAIR Locus Name";
                    source = "TAIR";
                    speciesName = tairGene.getSpeciesName();
                    firstTime = false;
                }
            }
            if (gene.getName() != null) {
                this.validateAtt(geneNameMap, gene, gene.getName());
            }
            if (extResMap2 != null) {
                if ("Ensembl".equals(extResMap2.get(extResMap2.firstKey()).getSource())) {
                    xrefSource = "Ensembl Gene ID";
                } else if ("Entrez".equals(extResMap2.get(extResMap2.firstKey()).getSource())) {
                    xrefSource = "Entrez Gene ID";
                } else if ("TAIR".equals(extResMap2.get(extResMap2.firstKey()).getSource())) {
                    xrefSource = "TAIR Locus ID";
                }
            }
            this.validateAttList(((ExtResourceGene)gene).getRefinedXrefList("ExtID"), gene, xrefIDMap);
        }
        this.generateIVReportsShared(source, speciesName, geneNameSource, geneNameMap, trackStats);
        if (source.equals("Ensembl")) {
            this.generateIVReportsShared(source, speciesName, "Ensembl Transcript ID", ensTransMap, trackStats);
            this.generateIVReportsShared(source, speciesName, "Ensembl Protein ID", ensProteinMap, trackStats);
        }
        this.generateIVReportsShared(source, speciesName, "RefSeq mRNA ID", refSeqMRNAMap, trackStats);
        this.generateIVReportsShared(source, speciesName, "RefSeq Protein ID", refSeqProMap, trackStats);
        this.generateIVReportsShared(source, speciesName, "Uniprot ID", uniprotMap, trackStats);
        this.generateIVReportsShared(source, speciesName, "MGI ID", MGDMap, trackStats);
        if (extResMap2 != null) {
            this.generateIVReportsShared(source, speciesName, xrefSource, xrefIDMap, trackStats);
        }
        if (this.isFixing()) {
            this.removeShared("Gene Name", geneNameMap);
            if (source.equals("Ensembl")) {
                this.removeShared("Ensembl Transcript ID", ensTransMap);
                this.removeShared("Ensembl Protein ID", ensProteinMap);
            }
            if (source.equals("Entrez")) {
                this.removeShared("RefSeq mRNA ID", refSeqMRNAMap);
                this.removeShared("RefSeq Protein ID", refSeqProMap);
            }
            this.removeShared("Uniprot ID", uniprotMap);
            this.removeShared("MGI ID", MGDMap);
            if (extResMap2 != null) {
                this.removeShared(xrefSource, xrefIDMap);
            }
        }
    }

    private void generateIVReportsShared(String source, String speciesName, String IDType, TreeMap<String, ArrayList<ExtResource>> attMap, boolean trackStats) {
        if (attMap.size() == 0) {
            return;
        }
        IVReportSummary IVSum = new IVReportSummary();
        IVSum.setSource(source);
        IVSum.setSpeciesName(speciesName);
        IVSum.setValidationType(this.validationType);
        IVSum.setIDType(IDType);
        IVSum.setNumTotal(attMap.size());
        this.trimAttList(attMap);
        IVSum.setNumOfOccur(attMap.size());
        IVSum.setIsDisplayable(trackStats);
        ArrayList<IVReportDetail> IVDetList = new ArrayList<IVReportDetail>();
        for (String attVal : attMap.keySet()) {
            ArrayList<ExtResource> sharedList = attMap.get(attVal);
            IVReportDetail IVDet = new IVReportDetail();
            IVDet.setIDType(IDType);
            IVDet.setSharedDetails(attVal, sharedList);
            IVDetList.add(IVDet);
        }
        IVSum.setIVDetList(IVDetList, VALID_TYPE_SHARED);
        this.IVSumList.add(IVSum);
    }

    private void validateAttList(ArrayList<String> attList, ExtResource gene, TreeMap<String, ArrayList<ExtResource>> attMap) {
        for (int i = 0; i < attList.size(); ++i) {
            this.validateAtt(attMap, gene, attList.get(i));
        }
    }

    private void validateAtt(TreeMap<String, ArrayList<ExtResource>> attMap, ExtResource gene, String attVal) {
        ArrayList<ExtResource> sharedList = attMap.get(attVal);
        if (sharedList == null) {
            sharedList = new ArrayList();
            sharedList.add(gene);
            attMap.put(attVal, sharedList);
        } else {
            for (int i = 0; i < sharedList.size(); ++i) {
                if (!gene.getID().equals(sharedList.get(i).getID())) continue;
                System.err.println("ValidateShared: Duplicates: " + sharedList.get(i).getID());
                return;
            }
            sharedList.add(gene);
            attMap.put(attVal, sharedList);
        }
    }

    private void trimAttList(TreeMap<String, ArrayList<ExtResource>> attMap) {
        Iterator<String> iterator = attMap.keySet().iterator();
        while (iterator.hasNext()) {
            String attName = iterator.next();
            ArrayList<ExtResource> sharedList = attMap.get(attName);
            if (sharedList.size() != 1) continue;
            iterator.remove();
        }
    }

    private void removeShared(String IDType, TreeMap<String, ArrayList<ExtResource>> attMap) {
        for (String attVal : attMap.keySet()) {
            ArrayList<ExtResource> attList = attMap.get(attVal);
            for (int i = 0; i < attList.size(); ++i) {
                ExtResource sharingGene = attList.get(i);
                if (IDType.equals("Gene Name")) {
                    sharingGene.resetName();
                } else if (IDType.equals("Ensembl Transcript ID")) {
                    ((EnsemblGene)sharingGene).removeTranscriptID(attVal);
                } else if (IDType.equals("Ensembl Protein ID")) {
                    ((EnsemblGene)sharingGene).removeProteinID(attVal);
                } else if (IDType.equals("RefSeq mRNA ID")) {
                    ((EntrezGene)sharingGene).removeRefSeqRNAID(attVal);
                } else if (IDType.equals("RefSeq Protein ID")) {
                    ((EntrezGene)sharingGene).removeRefSeqProID(attVal);
                } else if (IDType.equals("Uniprot ID")) {
                    ((ExtResourceGene)sharingGene).removeUniprotID(attVal);
                } else if (IDType.equals("MGI ID")) {
                    ((ExtResourceGene)sharingGene).removeMGDID(attVal);
                } else if (IDType.equals("Entrez Gene ID")) {
                    sharingGene.removeXRef("Entrez", attVal);
                } else if (IDType.equals("TAIR Locus ID")) {
                    sharingGene.removeXRef("TAIR", attVal);
                }
                attList.set(i, sharingGene);
            }
        }
    }

    private TreeMap<String, ExtResource> validateLeftOver(TreeMap<String, ExtResource> extResMap1, TreeMap<String, ExtResource> extResMap2) {
        System.out.println("Validating for: LeftOver Gene");
        TreeMap<String, ExtResource> xRefMap = new TreeMap<String, ExtResource>();
        Iterator<String> iterator = extResMap1.keySet().iterator();
        String currentXRefType = extResMap2.get(extResMap2.firstKey()).getSource();
        while (iterator.hasNext()) {
            ExtResource gene1 = extResMap1.get(iterator.next());
            TreeMap<String, ExtResource> tempMap = gene1.getXRef(currentXRefType);
            if (tempMap == null) continue;
            xRefMap.putAll(tempMap);
        }
        ArrayList<IVReportDetail> IVDetList = new ArrayList<IVReportDetail>();
        this.leftOverMap = new TreeMap();
        for (String geneID2 : extResMap2.keySet()) {
            if (xRefMap.containsKey(geneID2)) continue;
            this.leftOverMap.put(geneID2, extResMap2.get(geneID2));
            IVReportDetail IVDet = new IVReportDetail();
            IVDet.setLeftOverDetails(extResMap2.get(geneID2));
            IVDetList.add(IVDet);
        }
        IVReportSummary IVSum = new IVReportSummary();
        IVSum.setSource(extResMap1.get(extResMap1.firstKey()).getSource());
        IVSum.setSpeciesName(extResMap1.get(extResMap1.firstKey()).getSpeciesName());
        IVSum.setValidationType(this.validationType);
        IVSum.setNumOfOccur(this.leftOverMap.size());
        IVSum.setNumTotal(extResMap1.size());
        IVSum.setIVDetList(IVDetList, VALID_TYPE_LEFTOVER);
        this.IVSumList.add(IVSum);
        return this.leftOverMap;
    }

    private void validateDeprecated(TreeMap<String, ExtResource> extResMap1, TreeMap<String, ExtResource> extResMap2) throws RuntimeException {
        System.out.println("Validating for: Deprecated Identifier");
        TreeMap<String, String> deprecatedMap = new TreeMap<String, String>();
        TreeMap<String, ExtResource> xRefMap = null;
        Iterator<String> iterator1 = extResMap1.keySet().iterator();
        String currentXRefType = null;
        IVReportSummary IVSum = new IVReportSummary();
        IVSum.setSource(extResMap1.get(extResMap1.firstKey()).getSource());
        IVSum.setSpeciesName(extResMap1.get(extResMap1.firstKey()).getSpeciesName());
        IVSum.setValidationType(this.validationType);
        ArrayList<IVReportDetail> IVDetList = new ArrayList<IVReportDetail>();
        while (iterator1.hasNext()) {
            ExtResource gene1 = extResMap1.get(iterator1.next());
            if (gene1 instanceof EnsemblGene) {
                xRefMap = gene1.getXRef("Entrez");
                currentXRefType = "Entrez";
            } else if (gene1 instanceof EntrezGene) {
                xRefMap = gene1.getXRef("TAIR");
                currentXRefType = "TAIR";
            } else if (gene1 instanceof TAIRGene) {
                xRefMap = gene1.getXRef("Entrez");
                currentXRefType = "Entrez";
            }
            if (xRefMap == null) continue;
            TreeMap<String, ExtResource> newXRefMap = new TreeMap<String, ExtResource>();
            Iterator<String> iterator2 = xRefMap.keySet().iterator();
            while (iterator2.hasNext()) {
                IVSum.incrementTotal();
                String geneID2 = iterator2.next();
                ExtResource gene2 = xRefMap.get(geneID2);
                ExtResource xRefGene = extResMap2.get(gene2.getID());
                if (xRefGene == null) {
                    if (!this.isFixing()) {
                        newXRefMap.put(geneID2, gene2);
                    }
                    if (!(gene2 instanceof EntrezGene)) continue;
                    ArrayList<String> geneIDList = EntrezGene.replaceGeneID((ExtResourceGene)gene2);
                    ArrayList<ExtResource> tempList = this.getReplacements(extResMap2, geneIDList);
                    String replaceStr = "";
                    for (int i = 0; i < tempList.size(); ++i) {
                        if (i > 0) {
                            replaceStr = replaceStr + ";";
                        }
                        replaceStr = replaceStr + tempList.get(i).getID();
                        if (!this.isFixing()) continue;
                        newXRefMap.put(tempList.get(i).getID(), tempList.get(i));
                    }
                    if (replaceStr.length() == 0) {
                        replaceStr = replaceStr + "N/A";
                    }
                    if (deprecatedMap.containsKey(gene2.getID())) {
                        System.out.println("Multiple deprecation: " + gene1.getID() + " " + gene2.getID());
                        continue;
                    }
                    IVReportDetail IVDet = new IVReportDetail();
                    IVDet.setDepDetails(gene1, gene2, tempList);
                    deprecatedMap.put(gene2.getID(), replaceStr);
                    IVDetList.add(IVDet);
                    continue;
                }
                newXRefMap.put(xRefGene.getID(), xRefGene);
            }
            if (newXRefMap.size() <= 0) continue;
            gene1.setXRef(currentXRefType, newXRefMap);
        }
        IVSum.setNumOfOccur(IVDetList.size());
        IVSum.setIVDetList(IVDetList, VALID_TYPE_DEPRECATED);
        this.IVSumList.add(IVSum);
    }

    private ArrayList<ExtResource> getReplacements(TreeMap<String, ExtResource> extResMap2, ArrayList<String> geneIDList) {
        ArrayList<ExtResource> tempList = new ArrayList<ExtResource>();
        for (int i = 0; i < geneIDList.size(); ++i) {
            ExtResource extResGene = extResMap2.get(geneIDList.get(i));
            if (extResGene != null) {
                tempList.add(extResGene);
                continue;
            }
            System.err.println("Deprecated Replacement: " + geneIDList.get(i));
        }
        return tempList;
    }

    public void dump(boolean closeStreams) {
        try {
            if (this.bwSum == null) {
                this.bwSum = new BufferedWriter(new FileWriter(this.summaryFileName));
                this.bwSum.write("Source\tSpecies\tValidation Type\tIdentifier Type\tNumber of Occurences\tTotal Number");
                this.bwSum.newLine();
            }
            if (this.bwDetShared == null) {
                this.bwDetShared = new BufferedWriter(new FileWriter(this.detailFileName + "_" + VALID_TYPE_SHARED));
                this.bwDetShared.write("Source\tSpecies\tIdentifier Type\tIdenfitier\tGene ID");
                this.bwDetShared.newLine();
            }
            if (this.bwDetLO == null) {
                this.bwDetLO = new BufferedWriter(new FileWriter(this.detailFileName + "_" + VALID_TYPE_LEFTOVER));
                this.bwDetLO.write("Source\tSpecies\tGene ID");
                this.bwDetLO.newLine();
            }
            if (this.bwDetDep == null) {
                this.bwDetDep = new BufferedWriter(new FileWriter(this.detailFileName + "_" + VALID_TYPE_DEPRECATED));
                this.bwDetDep.write("Source\tSpecies\tGene ID\tOld Gene ID\tNew Gene ID");
                this.bwDetDep.newLine();
            }
            System.out.println("Dumping: Summary: " + this.IVSumList.size());
            for (int i = 0; i < this.IVSumList.size(); ++i) {
                System.out.println(this.IVSumList.get(i).toString());
                if (this.IVSumList.get(i).isDisplayable()) {
                    this.bwSum.write(this.IVSumList.get(i).toString());
                    this.bwSum.newLine();
                    this.bwSum.flush();
                }
                this.IVSumList.get(i).toStringDetailShared(this.bwDetShared);
                this.IVSumList.get(i).toStringDetailLO(this.bwDetLO);
                this.IVSumList.get(i).toStringDetailDep(this.bwDetDep);
            }
            this.bwSum.flush();
            this.bwDetShared.flush();
            this.bwDetLO.flush();
            this.bwDetDep.flush();
            this.IVSumList.clear();
            if (closeStreams) {
                this.bwSum.close();
                this.bwDetShared.close();
                this.bwDetLO.close();
                this.bwDetDep.close();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    static {
        validTypesList = new ArrayList();
        validTypesList.add(VALID_TYPE_LEFTOVER);
        validTypesList.add(VALID_TYPE_DEPRECATED);
        validTypesList.add(VALID_TYPE_SHARED);
    }
}

