/*
 * Decompiled with CFR 0.152.
 */
package org.pathwaycommons.trans.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.pathwaycommons.trans.util.PSIMIMiner;
import org.pathwaycommons.trans.util.XMLUtil;

public class PSIMIMinerXML
extends PSIMIMiner {
    private Element interactionE;
    private Namespace psins = Namespace.getNamespace((String)"net:sf:psidev:mi");

    protected PSIMIMinerXML(String inputFileName, String reportFileName, String miningType) throws Exception {
        super(inputFileName, reportFileName, miningType);
    }

    protected void minePSIMI(String inputFileName) throws IOException, JDOMException {
        this.termMap = new TreeMap();
        this.interactionCnt = 0;
        Element entrySetE = XMLUtil.readSchemaBasedXML(inputFileName);
        Element entryE = entrySetE.getChild("entry", this.psins);
        ArrayList interactionsList = new ArrayList();
        interactionsList.addAll(entryE.getChild("interactionList", this.psins).getChildren("interaction", this.psins));
        for (int i = 0; i < interactionsList.size(); ++i) {
            this.interactionE = (Element)interactionsList.get(i);
            if (this.getAtt("Complex Number of Subunits") != null) {
                if (!"Complex Number of Subunits".equals(this.miningType)) {
                    ++this.skipCnt;
                    continue;
                }
                ++this.interactionCnt;
            }
            if (!"Complex Number of Subunits".equals(this.miningType)) {
                ++this.interactionCnt;
            }
            if ("interactionDetectionMethod".equals(this.miningType)) {
                this.mineDetMethod();
                continue;
            }
            if ("interactorType".equals(this.miningType)) {
                this.mineInteractorType();
                continue;
            }
            if ("Complex Number of Subunits".equals(this.miningType)) {
                this.mineComplexSubunits();
                continue;
            }
            if ("BIND Interaction Division".equals(this.miningType)) {
                this.mineBINDDivCategory();
                continue;
            }
            if ("xref".equals(this.miningType)) {
                this.mineInteractorXRef();
                continue;
            }
            throw new IllegalArgumentException("Unsupported mining request: " + this.miningType);
        }
        super.incrementCounts(inputFileName);
    }

    protected void mineDetMethod() {
        ArrayList expDescList = new ArrayList();
        expDescList.addAll(this.interactionE.getChild("experimentList", this.psins).getChildren("experimentDescription", this.psins));
        for (int i = 0; i < expDescList.size(); ++i) {
            Element intDetMetE = ((Element)expDescList.get(i)).getChild("interactionDetectionMethod", this.psins);
            String detMethod = intDetMetE.getChild("names", this.psins).getChild("shortLabel", this.psins).getTextTrim();
            this.trackTermCnt(detMethod);
        }
    }

    protected void mineInteractorType() {
        ArrayList partList = new ArrayList();
        partList.addAll(this.interactionE.getChild("participantList", this.psins).getChildren("participant", this.psins));
        for (int i = 0; i < partList.size(); ++i) {
            Element interactorE = ((Element)partList.get(i)).getChild("interactor", this.psins);
            Element interTypeE = interactorE.getChild("interactorType", this.psins);
            this.trackTermCnt(interTypeE.getChild("names", this.psins).getChild("shortLabel", this.psins).getTextTrim());
        }
    }

    protected void mineInteractorXRef() {
        ArrayList partList = new ArrayList();
        partList.addAll(this.interactionE.getChild("participantList", this.psins).getChildren("participant", this.psins));
        for (int i = 0; i < partList.size(); ++i) {
            Element interactorE = ((Element)partList.get(i)).getChild("interactor", this.psins);
            if (interactorE == null) {
                System.err.println("No interactor. InteractorRef not supported: " + partList.get(i));
                return;
            }
            ArrayList<Element> xrefList = new ArrayList<Element>();
            Element xrefE = interactorE.getChild("xref", this.psins);
            if (xrefE != null) {
                xrefList.add(xrefE.getChild("primaryRef", this.psins));
                xrefList.addAll(xrefE.getChildren("secondaryRef", this.psins));
            }
            for (int j = 0; j < xrefList.size(); ++j) {
                this.trackTermCnt(((Element)xrefList.get(j)).getAttributeValue("db"));
            }
        }
    }

    protected void trackAtt(String attName) {
        String attVal = this.getAtt(attName);
        if (attVal != null) {
            this.trackTermCnt(attVal);
        }
    }

    protected String getAtt(String attName) {
        Element attListE = this.interactionE.getChild("attributeList", this.psins);
        ArrayList attList = new ArrayList();
        attList.addAll(attListE.getChildren("attribute", this.psins));
        String attVal = null;
        for (int i = 0; i < attList.size(); ++i) {
            Element attE = (Element)attList.get(i);
            if (!attE.getAttributeValue("name").trim().equals(attName)) continue;
            attVal = attE.getValue();
            break;
        }
        return attVal;
    }
}

