/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.cvrReader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.cvrReader.CvRuleReaderException;
import psidev.psi.tools.cvrReader.mapping.jaxb.CvMapping;

public class CvRuleReader {
    public static final Log log = LogFactory.getLog(CvRuleReader.class);

    private Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((String)"psidev.psi.tools.cvrReader.mapping.jaxb");
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            URL url = CvRuleReader.class.getResource("/CvMapping.xsd");
            if (url == null) {
                throw new IllegalArgumentException("null schema ");
            }
            schema = sf.newSchema(url);
        }
        catch (Exception e) {
            throw new JAXBException((Throwable)e);
        }
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }

    private CvMapping unmarshall(URL url) throws JAXBException, FileNotFoundException {
        if (url == null) {
            throw new IllegalArgumentException("You must give a non null URL.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (CvMapping)u.unmarshal(url);
    }

    private CvMapping unmarshall(File file) throws JAXBException, FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("You must give a non null file.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("You must give an existing file.");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("You must give a readable file.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (CvMapping)u.unmarshal((InputStream)new FileInputStream(file));
    }

    private CvMapping unmarshall(InputStream is) throws JAXBException {
        if (is == null) {
            throw new IllegalArgumentException("You must give a non null input stream.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (CvMapping)u.unmarshal(is);
    }

    private CvMapping unmarshall(String s) throws JAXBException {
        if (s == null) {
            throw new IllegalArgumentException("You must give a non null String.");
        }
        Unmarshaller u = this.getUnmarshaller();
        return (CvMapping)u.unmarshal((Reader)new StringReader(s));
    }

    public CvMapping read(String s) throws CvRuleReaderException {
        try {
            return this.unmarshall(s);
        }
        catch (JAXBException e) {
            throw new CvRuleReaderException(e);
        }
    }

    public CvMapping read(File file) throws CvRuleReaderException {
        try {
            return this.unmarshall(file);
        }
        catch (JAXBException e) {
            throw new CvRuleReaderException(e);
        }
        catch (FileNotFoundException e) {
            throw new CvRuleReaderException(e);
        }
    }

    public CvMapping read(InputStream is) throws CvRuleReaderException {
        try {
            return this.unmarshall(is);
        }
        catch (JAXBException e) {
            throw new CvRuleReaderException(e);
        }
    }

    public CvMapping read(URL url) throws CvRuleReaderException {
        try {
            return this.unmarshall(url);
        }
        catch (JAXBException e) {
            throw new CvRuleReaderException(e);
        }
        catch (FileNotFoundException e) {
            throw new CvRuleReaderException(e);
        }
    }
}

