/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter;

import psidev.psi.mi.xml.converter.AttributeConverter;
import psidev.psi.mi.xml.converter.AvailabilityConverter;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.ExperimentDescriptionConverter;
import psidev.psi.mi.xml.converter.InteractionConverter;
import psidev.psi.mi.xml.converter.InteractorConverter;
import psidev.psi.mi.xml.converter.SourceConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.jaxb.AttributeListType;
import psidev.psi.mi.xml.jaxb.AvailabilityType;
import psidev.psi.mi.xml.jaxb.EntryType;
import psidev.psi.mi.xml.jaxb.ExperimentType;
import psidev.psi.mi.xml.jaxb.InteractorElementType;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Availability;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Interactor;

public class EntryConverter {
    private SourceConverter sourceConverter = new SourceConverter();
    private ExperimentDescriptionConverter experimentDescriptionConverter = new ExperimentDescriptionConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private AvailabilityConverter availabilityConverter = new AvailabilityConverter();
    private InteractionConverter interactionConverter = new InteractionConverter();
    private InteractorConverter interactorConverter = new InteractorConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.experimentDescriptionConverter.setDAOFactory(factory);
        this.interactionConverter.setDAOFactory(factory);
        this.interactorConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Entry fromJaxb(EntryType jEntry) throws ConverterException {
        if (jEntry == null) {
            throw new IllegalArgumentException("You must give a non null JAXB entry.");
        }
        this.checkDependencies();
        Entry mEntry = new Entry();
        mEntry.setSource(this.sourceConverter.fromJaxb(jEntry.getSource()));
        if (jEntry.getAvailabilityList() != null) {
            for (AvailabilityType jAvailability : jEntry.getAvailabilityList().getAvailability()) {
                mEntry.getAvailabilities().add(this.availabilityConverter.fromJaxb(jAvailability));
            }
        }
        if (jEntry.getExperimentList() != null) {
            for (ExperimentType jExperiment : jEntry.getExperimentList().getExperimentDescription()) {
                mEntry.getExperiments().add(this.experimentDescriptionConverter.fromJaxb(jExperiment));
            }
        }
        if (jEntry.getInteractorList() != null) {
            for (InteractorElementType jInteractor : jEntry.getInteractorList().getInteractor()) {
                mEntry.getInteractors().add(this.interactorConverter.fromJaxb(jInteractor));
            }
        }
        if (jEntry.getInteractionList() != null) {
            for (EntryType.InteractionList.Interaction jInteraction : jEntry.getInteractionList().getInteraction()) {
                mEntry.getInteractions().add(this.interactionConverter.fromJaxb(jInteraction));
            }
        }
        if (jEntry.getAttributeList() != null) {
            for (AttributeListType.Attribute jAttribute : jEntry.getAttributeList().getAttribute()) {
                mEntry.getAttributes().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        this.factory.reset();
        return mEntry;
    }

    public EntryType toJaxb(Entry mEntry) throws ConverterException {
        if (mEntry == null) {
            throw new IllegalArgumentException("You must give a non null model entry.");
        }
        this.checkDependencies();
        EntryType jEntry = new EntryType();
        if (mEntry.hasSource()) {
            jEntry.setSource(this.sourceConverter.toJaxb(mEntry.getSource()));
        }
        if (mEntry.hasAvailabilities()) {
            if (jEntry.getAvailabilityList() == null) {
                jEntry.setAvailabilityList(new EntryType.AvailabilityList());
            }
            for (Availability mAvailability : mEntry.getAvailabilities()) {
                jEntry.getAvailabilityList().getAvailability().add(this.availabilityConverter.toJaxb(mAvailability));
            }
        }
        if (mEntry.hasExperiments()) {
            if (jEntry.getExperimentList() == null) {
                jEntry.setExperimentList(new EntryType.ExperimentList());
            }
            for (ExperimentDescription mExperiment : mEntry.getExperiments()) {
                jEntry.getExperimentList().getExperimentDescription().add(this.experimentDescriptionConverter.toJaxb(mExperiment));
            }
        }
        if (mEntry.hasInteractors()) {
            if (jEntry.getInteractorList() == null) {
                jEntry.setInteractorList(new EntryType.InteractorList());
            }
            for (Interactor mInteractor : mEntry.getInteractors()) {
                jEntry.getInteractorList().getInteractor().add(this.interactorConverter.toJaxb(mInteractor));
            }
        }
        for (Interaction mInteraction : mEntry.getInteractions()) {
            if (jEntry.getInteractionList() == null) {
                jEntry.setInteractionList(new EntryType.InteractionList());
            }
            jEntry.getInteractionList().getInteraction().add(this.interactionConverter.toJaxb(mInteraction));
        }
        if (mEntry.hasAttributes()) {
            if (jEntry.getAttributeList() == null) {
                jEntry.setAttributeList(new AttributeListType());
            }
            for (Attribute mAttribute : mEntry.getAttributes()) {
                jEntry.getAttributeList().getAttribute().add(this.attributeConverter.toJaxb(mAttribute));
            }
        }
        return jEntry;
    }
}

