/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.mi.xml.converter.AttributeConverter;
import psidev.psi.mi.xml.converter.AvailabilityConverter;
import psidev.psi.mi.xml.converter.ConfidenceConverter;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.CvTypeConverter;
import psidev.psi.mi.xml.converter.ExperimentDescriptionConverter;
import psidev.psi.mi.xml.converter.InferredInteractionConverter;
import psidev.psi.mi.xml.converter.InteractionParameterConverter;
import psidev.psi.mi.xml.converter.NamesConverter;
import psidev.psi.mi.xml.converter.ParticipantConverter;
import psidev.psi.mi.xml.converter.XrefConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.dao.PsiDAO;
import psidev.psi.mi.xml.jaxb.AttributeListType;
import psidev.psi.mi.xml.jaxb.ConfidenceListType;
import psidev.psi.mi.xml.jaxb.CvType;
import psidev.psi.mi.xml.jaxb.EntryType;
import psidev.psi.mi.xml.jaxb.ExperimentType;
import psidev.psi.mi.xml.jaxb.InteractionElementType;
import psidev.psi.mi.xml.jaxb.ParticipantType;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.InferredInteraction;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionType;
import psidev.psi.mi.xml.model.Parameter;
import psidev.psi.mi.xml.model.Participant;

public class InteractionConverter {
    public static final Log log = LogFactory.getLog(InteractionConverter.class);
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private NamesConverter namesConverter = new NamesConverter();
    private XrefConverter xrefConverter = new XrefConverter();
    private ConfidenceConverter confidenceConverter = new ConfidenceConverter();
    private ParticipantConverter participantConverter = new ParticipantConverter();
    private AvailabilityConverter availabilityConverter = new AvailabilityConverter();
    private ExperimentDescriptionConverter experimentDescriptionConverter = new ExperimentDescriptionConverter();
    private AttributeConverter attributeConverter = new AttributeConverter();
    private InteractionParameterConverter parameterConverter = new InteractionParameterConverter();
    private InferredInteractionConverter inferredInteractionConverter = new InferredInteractionConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
        this.inferredInteractionConverter.setDAOFactory(factory);
        this.parameterConverter.setDAOFactory(factory);
        this.confidenceConverter.setDAOFactory(factory);
        this.inferredInteractionConverter.setDAOFactory(factory);
        this.participantConverter.setDAOFactory(factory);
        this.experimentDescriptionConverter.setDAOFactory(factory);
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public Interaction fromJaxb(EntryType.InteractionList.Interaction jInteraction) throws ConverterException {
        if (jInteraction == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Interaction.");
        }
        this.checkDependencies();
        Interaction mInteraction = new Interaction();
        mInteraction.setId(jInteraction.getId());
        mInteraction.setImexId(jInteraction.getImexId());
        if (jInteraction.getNames() != null) {
            mInteraction.setNames(this.namesConverter.fromJaxb(jInteraction.getNames()));
        }
        if (jInteraction.getXref() != null) {
            mInteraction.setXref(this.xrefConverter.fromJaxb(jInteraction.getXref()));
        }
        if (jInteraction.getAvailability() != null) {
            mInteraction.setAvailability(this.availabilityConverter.fromJaxb(jInteraction.getAvailability()));
        }
        if (jInteraction.getExperimentList() != null) {
            for (Object o : jInteraction.getExperimentList().getExperimentRefOrExperimentDescription()) {
                log.info((Object)("Reading object of type: " + o.getClass()));
                ExperimentDescription mExperiment = null;
                ExperimentRef experimentRef = null;
                if (o instanceof ExperimentType) {
                    log.info((Object)"Found an experiment");
                    mExperiment = this.experimentDescriptionConverter.fromJaxb((ExperimentType)o);
                    PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
                    experimentDAO.store(mExperiment);
                } else if (o instanceof Integer) {
                    Integer ref = (Integer)o;
                    experimentRef = new ExperimentRef(ref);
                    PsiDAO<ExperimentDescription> experimentDAO = this.factory.getExperimentDAO();
                    mExperiment = experimentDAO.retreive((Integer)o);
                } else {
                    throw new IllegalStateException("Expected object type: {ExperimentType, Integer}, found: " + o.getClass().getName());
                }
                if (mExperiment == null) {
                    mInteraction.getExperimentRefs().add(experimentRef);
                    continue;
                }
                mInteraction.getExperiments().add(mExperiment);
            }
        }
        if (jInteraction.getParticipantList() != null) {
            for (ParticipantType jParticipant : jInteraction.getParticipantList().getParticipant()) {
                mInteraction.getParticipants().add(this.participantConverter.fromJaxb(jParticipant));
            }
        }
        if (jInteraction.getInferredInteractionList() != null) {
            for (InteractionElementType.InferredInteractionList.InferredInteraction jInferredInteraction : jInteraction.getInferredInteractionList().getInferredInteraction()) {
                mInteraction.getInferredInteractions().add(this.inferredInteractionConverter.fromJaxb(jInferredInteraction));
            }
        }
        for (CvType jIntereractionType : jInteraction.getInteractionType()) {
            mInteraction.getInteractionTypes().add(this.cvTypeConverter.fromJaxb(jIntereractionType, InteractionType.class));
        }
        if (jInteraction.isModelled() != null) {
            mInteraction.setModelled(jInteraction.isModelled());
        } else {
            mInteraction.setModelled(false);
        }
        if (jInteraction.isIntraMolecular() != null) {
            mInteraction.setIntraMolecular(jInteraction.isIntraMolecular());
        } else {
            mInteraction.setIntraMolecular(false);
        }
        if (jInteraction.isNegative() != null) {
            mInteraction.setNegative(jInteraction.isNegative());
        } else {
            mInteraction.setNegative(false);
        }
        if (jInteraction.getConfidenceList() != null) {
            for (ConfidenceListType.Confidence jConfidence : jInteraction.getConfidenceList().getConfidence()) {
                mInteraction.getConfidences().add(this.confidenceConverter.fromJaxb(jConfidence));
            }
        }
        if (jInteraction.getParameterList() != null) {
            for (InteractionElementType.ParameterList.Parameter jParameter : jInteraction.getParameterList().getParameter()) {
                mInteraction.getParameters().add(this.parameterConverter.fromJaxb(jParameter));
            }
        }
        if (jInteraction.getAttributeList() != null) {
            for (AttributeListType.Attribute jAttribute : jInteraction.getAttributeList().getAttribute()) {
                mInteraction.getAttributeList().add(this.attributeConverter.fromJaxb(jAttribute));
            }
        }
        PsiDAO<Interaction> interactionDAO = this.factory.getInteractionDAO();
        interactionDAO.store(mInteraction);
        return mInteraction;
    }

    public EntryType.InteractionList.Interaction toJaxb(Interaction mInteraction) throws ConverterException {
        if (mInteraction == null) {
            throw new IllegalArgumentException("You must give a non null model Interaction.");
        }
        this.checkDependencies();
        EntryType.InteractionList.Interaction jInteraction = new EntryType.InteractionList.Interaction();
        jInteraction.setId(mInteraction.getId());
        jInteraction.setImexId(mInteraction.getImexId());
        if (mInteraction.hasNames()) {
            jInteraction.setNames(this.namesConverter.toJaxb(mInteraction.getNames()));
        }
        if (mInteraction.hasXref()) {
            jInteraction.setXref(this.xrefConverter.toJaxb(mInteraction.getXref()));
        }
        if (mInteraction.hasAvailability()) {
            jInteraction.setAvailability(this.availabilityConverter.toJaxb(mInteraction.getAvailability()));
        }
        if (mInteraction.hasExperiments()) {
            if (jInteraction.getExperimentList() == null) {
                jInteraction.setExperimentList(new InteractionElementType.ExperimentList());
            }
            for (ExperimentDescription experimentDescription : mInteraction.getExperiments()) {
                jInteraction.getExperimentList().getExperimentRefOrExperimentDescription().add(experimentDescription.getId());
            }
        } else if (mInteraction.hasExperimentRefs()) {
            if (jInteraction.getExperimentList() == null) {
                jInteraction.setExperimentList(new InteractionElementType.ExperimentList());
            }
            for (ExperimentRef experimentRef : mInteraction.getExperimentRefs()) {
                jInteraction.getExperimentList().getExperimentRefOrExperimentDescription().add(experimentRef.getRef());
            }
        }
        if (mInteraction.getParticipants() != null) {
            if (jInteraction.getParticipantList() == null) {
                jInteraction.setParticipantList(new InteractionElementType.ParticipantList());
            }
            for (Participant participant : mInteraction.getParticipants()) {
                jInteraction.getParticipantList().getParticipant().add(this.participantConverter.toJaxb(participant));
            }
        }
        if (mInteraction.hasInferredInteractions()) {
            if (jInteraction.getInferredInteractionList() == null) {
                jInteraction.setInferredInteractionList(new InteractionElementType.InferredInteractionList());
            }
            for (InferredInteraction inferredInteraction : mInteraction.getInferredInteractions()) {
                jInteraction.getInferredInteractionList().getInferredInteraction().add(this.inferredInteractionConverter.toJaxb(inferredInteraction));
            }
        }
        if (mInteraction.hasInteractionTypes()) {
            for (InteractionType interactionType : mInteraction.getInteractionTypes()) {
                jInteraction.getInteractionType().add(this.cvTypeConverter.toJaxb(interactionType));
            }
        }
        if (mInteraction.hasParameters()) {
            if (jInteraction.getParameterList() == null) {
                jInteraction.setParameterList(new InteractionElementType.ParameterList());
            }
            for (Parameter parameter : mInteraction.getParameters()) {
                jInteraction.getParameterList().getParameter().add(this.parameterConverter.toJaxb(parameter));
            }
        }
        jInteraction.setIntraMolecular(mInteraction.isIntraMolecular());
        jInteraction.setModelled(mInteraction.isModelled());
        jInteraction.setNegative(mInteraction.isNegative());
        if (mInteraction.hasConfidences()) {
            if (jInteraction.getConfidenceList() == null) {
                jInteraction.setConfidenceList(new ConfidenceListType());
            }
            for (Confidence confidence : mInteraction.getConfidences()) {
                jInteraction.getConfidenceList().getConfidence().add(this.confidenceConverter.toJaxb(confidence));
            }
        }
        if (mInteraction.hasAttributes()) {
            if (jInteraction.getAttributeList() == null) {
                jInteraction.setAttributeList(new AttributeListType());
            }
            for (Attribute attribute : mInteraction.getAttributeList()) {
                jInteraction.getAttributeList().getAttribute().add(this.attributeConverter.toJaxb(attribute));
            }
        }
        return jInteraction;
    }
}

