/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.model;

import java.util.ArrayList;
import java.util.Collection;
import psidev.psi.mi.annotations.PsiCollectionField;
import psidev.psi.mi.annotations.PsiXmlElement;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Bibref;
import psidev.psi.mi.xml.model.Confidence;
import psidev.psi.mi.xml.model.FeatureDetectionMethod;
import psidev.psi.mi.xml.model.HasId;
import psidev.psi.mi.xml.model.InteractionDetectionMethod;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.NamesContainer;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.ParticipantIdentificationMethod;
import psidev.psi.mi.xml.model.Xref;
import psidev.psi.mi.xml.model.XrefContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PsiXmlElement
public class ExperimentDescription
implements HasId,
NamesContainer,
XrefContainer {
    private int id;
    private Names names;
    private Bibref bibref;
    private Xref xref;
    @PsiCollectionField(max=1)
    private Collection<Organism> hostOrganisms;
    private InteractionDetectionMethod interactionDetectionMethod;
    private ParticipantIdentificationMethod participantIdentificationMethod;
    private FeatureDetectionMethod featureDetectionMethod;
    @PsiCollectionField(disabled=true)
    private Collection<Confidence> confidences;
    private Collection<Attribute> attributes;

    public ExperimentDescription() {
    }

    public ExperimentDescription(Bibref bibref, InteractionDetectionMethod interactionDetectionMethod) {
        this.setBibref(bibref);
        this.setInteractionDetectionMethod(interactionDetectionMethod);
    }

    public boolean hasNames() {
        return this.names != null;
    }

    @Override
    public Names getNames() {
        return this.names;
    }

    @Override
    public void setNames(Names value) {
        this.names = value;
    }

    public Bibref getBibref() {
        return this.bibref;
    }

    public void setBibref(Bibref value) {
        this.bibref = value;
    }

    public boolean hasXref() {
        return this.xref != null;
    }

    @Override
    public Xref getXref() {
        return this.xref;
    }

    @Override
    public void setXref(Xref value) {
        this.xref = value;
    }

    public boolean hasHostOrganisms() {
        return this.hostOrganisms != null && !this.hostOrganisms.isEmpty();
    }

    public Collection<Organism> getHostOrganisms() {
        if (this.hostOrganisms == null) {
            this.hostOrganisms = new ArrayList<Organism>();
        }
        return this.hostOrganisms;
    }

    public InteractionDetectionMethod getInteractionDetectionMethod() {
        return this.interactionDetectionMethod;
    }

    public void setInteractionDetectionMethod(InteractionDetectionMethod value) {
        this.interactionDetectionMethod = value;
    }

    public boolean hasParticipantIdentificationMethod() {
        return this.participantIdentificationMethod != null;
    }

    public ParticipantIdentificationMethod getParticipantIdentificationMethod() {
        return this.participantIdentificationMethod;
    }

    public void setParticipantIdentificationMethod(ParticipantIdentificationMethod value) {
        this.participantIdentificationMethod = value;
    }

    public boolean hasFeatureDetectionMethod() {
        return this.featureDetectionMethod != null;
    }

    public FeatureDetectionMethod getFeatureDetectionMethod() {
        return this.featureDetectionMethod;
    }

    public void setFeatureDetectionMethod(FeatureDetectionMethod value) {
        this.featureDetectionMethod = value;
    }

    public boolean hasConfidences() {
        return this.confidences != null && !this.confidences.isEmpty();
    }

    public Collection<Confidence> getConfidences() {
        if (this.confidences == null) {
            this.confidences = new ArrayList<Confidence>();
        }
        return this.confidences;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public Collection<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
        }
        return this.attributes;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int value) {
        this.id = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExperimentDescription");
        sb.append("{id=").append(this.id);
        sb.append(", names=").append(this.names);
        sb.append(", bibref=").append(this.bibref);
        sb.append(", xref=").append(this.xref);
        sb.append(", hostOrganisms=").append(this.hostOrganisms);
        sb.append(", interactionDetectionMethod=").append(this.interactionDetectionMethod);
        sb.append(", participantIdentificationMethod=").append(this.participantIdentificationMethod);
        sb.append(", featureDetectionMethod=").append(this.featureDetectionMethod);
        sb.append(", confidences=").append(this.confidences);
        sb.append(", attributes=").append(this.attributes);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExperimentDescription that = (ExperimentDescription)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.bibref != null ? !this.bibref.equals(that.bibref) : that.bibref != null) {
            return false;
        }
        return !(this.interactionDetectionMethod != null ? !this.interactionDetectionMethod.equals(that.interactionDetectionMethod) : that.interactionDetectionMethod != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 29 * result + (this.bibref != null ? this.bibref.hashCode() : 0);
        result = 29 * result + (this.interactionDetectionMethod != null ? this.interactionDetectionMethod.hashCode() : 0);
        return result;
    }
}

