/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.cvrReader.CvRuleReader;
import psidev.psi.tools.cvrReader.CvRuleReaderException;
import psidev.psi.tools.objectRuleReader.ObjectRuleReader;
import psidev.psi.tools.objectRuleReader.mapping.jaxb.ObjectRuleList;
import psidev.psi.tools.objectRuleReader.mapping.jaxb.Rule;
import psidev.psi.tools.ontology_manager.OntologyManager;
import psidev.psi.tools.ontology_manager.impl.local.OntologyLoaderException;
import psidev.psi.tools.validator.ValidatorException;
import psidev.psi.tools.validator.ValidatorMessage;
import psidev.psi.tools.validator.preferences.UserPreferences;
import psidev.psi.tools.validator.rules.codedrule.ObjectRule;
import psidev.psi.tools.validator.rules.cvmapping.CvRule;
import psidev.psi.tools.validator.rules.cvmapping.CvRuleManager;
import psidev.psi.tools.validator.util.ValidatorReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Validator {
    public static final Log log = LogFactory.getLog(Validator.class);
    protected UserPreferences userPreferences = new UserPreferences();
    protected OntologyManager ontologyMngr;
    private List<ObjectRule> rules;
    private CvRuleManager cvRuleManager;

    public Validator(InputStream ontoConfig, InputStream cvRuleConfig, InputStream objectRuleConfig) throws ValidatorException, OntologyLoaderException {
        this(ontoConfig, cvRuleConfig);
        this.setObjectRules(objectRuleConfig);
    }

    public Validator(InputStream ontoConfig, InputStream cvRuleConfig) throws ValidatorException, OntologyLoaderException {
        this(ontoConfig);
        if (cvRuleConfig != null) {
            try {
                this.setCvMappingRules(cvRuleConfig);
            }
            catch (CvRuleReaderException e) {
                throw new ValidatorException("CvMappingException while trying to load the CvRules.", e);
            }
        }
    }

    public Validator(InputStream ontoConfig) throws OntologyLoaderException {
        this.ontologyMngr = new OntologyManager(ontoConfig);
    }

    public OntologyManager getOntologyMngr() {
        return this.ontologyMngr;
    }

    public void setOntologyManager(InputStream ontoConfig) throws ValidatorException, OntologyLoaderException {
        this.ontologyMngr = new OntologyManager(ontoConfig);
    }

    public CvRuleManager getCvRuleManager() {
        return this.cvRuleManager;
    }

    public void setCvMappingRules(InputStream cvIs) throws CvRuleReaderException {
        CvRuleReader reader = new CvRuleReader();
        this.cvRuleManager = new CvRuleManager(this.ontologyMngr, reader.read(cvIs));
    }

    public List<ObjectRule> getObjectRules() {
        return this.rules;
    }

    public void setObjectRules(InputStream configFile) throws ValidatorException {
        this.rules = new ArrayList<ObjectRule>();
        if (configFile != null) {
            ObjectRuleReader reader = new ObjectRuleReader();
            String className = null;
            try {
                ObjectRuleList rules = reader.read(configFile);
                for (Rule rule : rules.getRule()) {
                    className = rule.getClazz();
                    Class<?> ruleClass = Class.forName(className);
                    Constructor<?> c = ruleClass.getConstructor(OntologyManager.class);
                    ObjectRule r = (ObjectRule)c.newInstance(this.ontologyMngr);
                    this.rules.add(r);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("Added rule: " + r.getClass()));
                }
            }
            catch (Exception e) {
                throw new ValidatorException("Error instantiating rule (" + className + ")", e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No Object rules were configured in this validator.");
        }
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public void setUserPreferences(UserPreferences userPreferences) {
        this.userPreferences = userPreferences;
    }

    public Collection<ValidatorMessage> validate(Collection<?> col) throws ValidatorException {
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        for (ObjectRule rule : this.rules) {
            messages.addAll(this.validate(col, rule));
        }
        return messages;
    }

    public Collection<ValidatorMessage> validate(Object objectToCheck) throws ValidatorException {
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        for (ObjectRule rule : this.rules) {
            if (!rule.canCheck(objectToCheck)) continue;
            messages.addAll(rule.check(objectToCheck));
        }
        return messages;
    }

    public Collection<ValidatorMessage> validate(Object objectToCheck, ObjectRule rule) throws ValidatorException {
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        if (rule.canCheck(objectToCheck)) {
            messages.addAll(rule.check(objectToCheck));
        }
        return messages;
    }

    private Collection<ValidatorMessage> validate(Collection<?> col, ObjectRule rule) throws ValidatorException {
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        for (Object aCol : col) {
            if (!rule.canCheck(aCol)) continue;
            messages.addAll(rule.check(aCol));
        }
        return messages;
    }

    public Collection<ValidatorMessage> checkCvMappingRules() throws ValidatorException {
        if (this.cvRuleManager != null) {
            return this.cvRuleManager.checkCvMapping();
        }
        log.warn((Object)"The CvRuleManager has not been set up yet.");
        return new ArrayList<ValidatorMessage>();
    }

    public Collection<ValidatorMessage> checkCvMapping(Collection<?> col, String xPath) throws ValidatorException {
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        if (this.cvRuleManager != null) {
            for (CvRule rule : this.cvRuleManager.getCvRules()) {
                for (Object o : col) {
                    if (!rule.canCheck(xPath)) continue;
                    messages.addAll(rule.check(o, xPath));
                }
            }
        } else {
            log.error((Object)"The CvRuleManager has not been set up yet.");
        }
        return messages;
    }

    public Collection<ValidatorMessage> checkCvMapping(Object o, String xPath) throws ValidatorException {
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        if (this.cvRuleManager != null) {
            for (CvRule rule : this.cvRuleManager.getCvRules()) {
                if (!rule.canCheck(xPath)) continue;
                messages.addAll(rule.check(o, xPath));
            }
        } else {
            log.error((Object)"The CvRuleManager has not been set up yet.");
        }
        return messages;
    }

    public ValidatorReport getReport() {
        return new ValidatorReport(this.cvRuleManager.getCvRules());
    }

    public void resetCvRuleStatus() {
        Collection<CvRule> cvRules = this.cvRuleManager.getCvRules();
        for (CvRule cvRule : cvRules) {
            cvRule.resetStatus();
        }
    }
}

