/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.preferences;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.validator.ValidatorException;

public class UserPreferences {
    public static final Log log = LogFactory.getLog(UserPreferences.class);
    public static final String USER_HOME = System.getProperty("user.home");
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir", "tmp");
    public static final String VALIDATOR_DIRECTORY = ".validator";
    public static final String PROPERTIES_FILENAME = "validator.properties";
    private boolean saxValidationEnabled = false;
    private boolean keepDownloadedOntologiesOnDisk = true;
    private File workDirectory;

    public void setSaxValidationEnabled(boolean saxValidationEnabled) {
        this.saxValidationEnabled = saxValidationEnabled;
    }

    public boolean isSaxValidationEnabled() {
        return this.saxValidationEnabled;
    }

    public File getWorkDirectory() {
        if (this.workDirectory == null) {
            return this.getUserHomeDirectory();
        }
        return this.workDirectory;
    }

    public boolean isKeepDownloadedOntologiesOnDisk() {
        return this.keepDownloadedOntologiesOnDisk;
    }

    public void setKeepDownloadedOntologiesOnDisk(boolean keepDownloadedOntologiesOnDisk) {
        this.keepDownloadedOntologiesOnDisk = keepDownloadedOntologiesOnDisk;
    }

    public void setWorkDirectory(File workDirectory) {
        if (workDirectory != null) {
            if (!workDirectory.exists()) {
                log.warn((Object)(workDirectory.getAbsolutePath() + " doesn't exist, trying now to create it."));
                boolean success = workDirectory.mkdirs();
                if (success) {
                    log.info((Object)"Directory created successfully.");
                    this.workDirectory = workDirectory;
                } else {
                    log.error((Object)("Could not create " + workDirectory.getAbsolutePath()));
                    log.error((Object)"The default user directory will be used.");
                }
            } else if (workDirectory.canRead() && workDirectory.canWrite()) {
                this.workDirectory = workDirectory;
            } else {
                log.error((Object)("The specified work directory (" + workDirectory.getAbsolutePath() + ") is not read/write. We will use the user home directory instead."));
            }
        } else {
            log.warn((Object)"The given file was null, user's home directory will be used.");
        }
    }

    private File getUserHomeDirectory() {
        String path = USER_HOME;
        File home = new File(path);
        return home;
    }

    public File getValidatorDirectory() throws ValidatorException {
        String path = this.getWorkDirectory().getAbsolutePath() + File.separator + VALIDATOR_DIRECTORY;
        File dir = new File(path);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new ValidatorException("Cannot create Validator's home directory: " + dir.getAbsolutePath());
            }
            return dir;
        }
        if (dir.canWrite()) {
            return dir;
        }
        dir = null;
        path = TEMP_DIR + File.separator + VALIDATOR_DIRECTORY;
        dir = new File(path);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new ValidatorException("Cannot create Validator's home directory: " + dir.getAbsolutePath());
            }
            return dir;
        }
        if (dir.canWrite()) {
            return dir;
        }
        throw new ValidatorException("Cannot create Validator's home directory, pleast check your config.");
    }

    public File getPropertiesFile() throws ValidatorException {
        File configDir = this.getValidatorDirectory();
        if (configDir == null) {
            return this.getUserHomeDirectory();
        }
        File props = new File(configDir.getAbsolutePath() + File.separator + PROPERTIES_FILENAME);
        if (!props.exists()) {
            try {
                if (!props.createNewFile()) {
                    log.warn((Object)("Error - Could not create file " + props.getAbsolutePath()));
                    return this.getUserHomeDirectory();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Error - Could not create file " + props.getAbsolutePath()), (Throwable)e);
            }
        } else {
            log.info((Object)("Found " + props.getAbsolutePath()));
        }
        return props;
    }
}

