/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.rules.cvmapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.cvrReader.mapping.jaxb.CvMapping;
import psidev.psi.tools.cvrReader.mapping.jaxb.CvMappingRule;
import psidev.psi.tools.cvrReader.mapping.jaxb.CvReference;
import psidev.psi.tools.cvrReader.mapping.jaxb.CvTerm;
import psidev.psi.tools.ontology_manager.OntologyManager;
import psidev.psi.tools.ontology_manager.OntologyUtils;
import psidev.psi.tools.ontology_manager.interfaces.OntologyAccess;
import psidev.psi.tools.validator.MessageLevel;
import psidev.psi.tools.validator.ValidatorException;
import psidev.psi.tools.validator.ValidatorMessage;
import psidev.psi.tools.validator.rules.cvmapping.CvRule;
import psidev.psi.tools.validator.rules.cvmapping.CvRuleImpl;
import psidev.psi.tools.validator.rules.cvmapping.Recommendation;
import psidev.psi.tools.validator.xpath.XPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvRuleManager {
    public static final Log log = LogFactory.getLog(CvRuleManager.class);
    private OntologyManager ontologyMngr;
    private Collection<CvRule> rules;
    private List<CvReference> cvReferences;

    public CvRuleManager(OntologyManager ontoMngr, CvMapping cvMappingRules) {
        if (ontoMngr == null) {
            throw new IllegalArgumentException("The given OntologyManager was null, cannot instanciate a CvRuleManager");
        }
        this.ontologyMngr = ontoMngr;
        this.addRules(cvMappingRules.getCvMappingRuleList().getCvMappingRule());
        this.cvReferences = cvMappingRules.getCvReferenceList().getCvReference();
    }

    public void setCvMappingRules(CvMapping cvMappingRules) {
        this.addRules(cvMappingRules.getCvMappingRuleList().getCvMappingRule());
    }

    public Collection<CvRule> getCvRules() {
        return this.rules;
    }

    public Collection<ValidatorMessage> check(Object o) throws ValidatorException {
        if (o == null) {
            throw new ValidatorException("Cannot validate a null object.");
        }
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        for (CvRule rule : this.rules) {
            messages.addAll(rule.check(o, null));
        }
        return messages;
    }

    public Collection<ValidatorMessage> check(Object o, String contextXpath) throws ValidatorException {
        if (o == null) {
            throw new ValidatorException("Cannot validate a null object.");
        }
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        for (CvRule rule : this.rules) {
            messages.addAll(rule.check(o, contextXpath));
        }
        return messages;
    }

    public Collection<ValidatorMessage> checkCvMapping() throws ValidatorException {
        ArrayList<ValidatorMessage> messages = new ArrayList<ValidatorMessage>();
        if (this.cvReferences != null) {
            for (CvReference cvReference : this.cvReferences) {
                if (this.ontologyMngr.containsOntology(cvReference.getCvIdentifier())) continue;
                String msg = "The requested ontology wasn't defined: " + cvReference.getCvIdentifier() + " (" + cvReference.getCvName() + "). The CvTerm will be removed.";
                messages.add(new ValidatorMessage(msg, MessageLevel.WARN));
            }
        }
        if (this.rules.size() < 1) {
            throw new ValidatorException("checkCvMapping: There are no rules to check! Make sure valid rules have been loaded.");
        }
        Iterator<CvRule> it_rule = this.rules.iterator();
        while (it_rule.hasNext()) {
            CvRule rule = it_rule.next();
            String elementPath = rule.getElementPath();
            String scopePath = rule.getScopePath();
            try {
                if (!elementPath.startsWith(scopePath)) {
                    it_rule.remove();
                    String msg = "The scope ('" + scopePath + "') of this rule did not match the element ('" + elementPath + "') defined. This rule will be removed.";
                    messages.add(rule.buildMessage(elementPath, Recommendation.forName(rule.getRequirementLevel()), msg, rule));
                    continue;
                }
                XPathHelper.evaluateXPath(scopePath, "");
                XPathHelper.evaluateXPath(elementPath, "");
                int cvTermCount = rule.getCVTerms().size();
                Iterator<CvTerm> it_cv = rule.getCVTerms().iterator();
                while (it_cv.hasNext()) {
                    CvTerm cvTerm = it_cv.next();
                    if (this.isValidCvTerm(cvTerm, rule, messages)) continue;
                    it_cv.remove();
                }
                if (!rule.getCVTerms().isEmpty()) continue;
                it_rule.remove();
                String msg = "All CvTerm" + (cvTermCount > 1 ? "s" : "") + " (" + cvTermCount + ") of this rule " + (cvTermCount > 1 ? "were" : "was") + " removed due " + "to inconsistencies (cf. previous messages). This rule will be removed.";
                messages.add(rule.buildMessage(elementPath, Recommendation.forName(rule.getRequirementLevel()), msg, rule));
            }
            catch (JXPathException e) {
                it_rule.remove();
                String msg = "The XPath expression could not be compiled: " + elementPath + " . This rule will be removed.";
                messages.add(rule.buildMessage(elementPath, Recommendation.forName(rule.getRequirementLevel()), msg, rule));
            }
        }
        return messages;
    }

    private boolean isValidCvTerm(CvTerm cvTerm, CvRule rule, Collection<ValidatorMessage> messages) throws ValidatorException {
        String ontologyID = ((CvReference)cvTerm.getCvIdentifierRef()).getCvIdentifier();
        log.debug((Object)("Checking cvTerm " + cvTerm.getTermName() + " for ontology: " + ontologyID));
        if (!this.ontologyMngr.containsOntology(ontologyID)) {
            String msg = "The requested ontology wasn't defined: " + ontologyID + ". The CvTerm will be removed.";
            messages.add(rule.buildMessage(rule.getElementPath(), Recommendation.forName(rule.getRequirementLevel()), msg, rule));
            return false;
        }
        String ruleTermAcc = cvTerm.getTermAccession();
        OntologyAccess ontoAccess = this.ontologyMngr.getOntologyAccess(ontologyID);
        Set validTerms = ontoAccess.getValidTerms(ruleTermAcc, false, true);
        Collection validAccs = OntologyUtils.getAccessions((Collection)validTerms);
        if (validAccs.size() != 1 || !validAccs.contains(ruleTermAcc)) {
            String msg = "The rule defines a term " + this.printSimpleCvTerm(cvTerm) + " that doesn't " + "exist in that ontology: " + ontologyID + ". The CvTerm will be removed.";
            messages.add(rule.buildMessage(rule.getElementPath(), Recommendation.forName(rule.getRequirementLevel()), msg, rule));
            return false;
        }
        if (ontoAccess.isObsolete(ontoAccess.getTermForAccession(ruleTermAcc))) {
            String msg = "The term " + this.printSimpleCvTerm(cvTerm) + " is obsolote in the ontology " + ontologyID + ". The CvTerm will be removed.";
            messages.add(rule.buildMessage(rule.getElementPath(), Recommendation.forName(rule.getRequirementLevel()), msg, rule));
            return false;
        }
        validTerms = ontoAccess.getValidTerms(ruleTermAcc, true, false);
        validAccs = OntologyUtils.getAccessions((Collection)validTerms);
        if (validAccs.size() == 0 && !cvTerm.isUseTerm() && cvTerm.isAllowChildren()) {
            String msg = "The term " + this.printSimpleCvTerm(cvTerm) + " doesn't have children in the ontology '" + ontologyID + "', yet the CvMapping recommends to use them. " + "The CvTerm will be removed.";
            messages.add(rule.buildMessage(rule.getElementPath(), Recommendation.forName(rule.getRequirementLevel()), msg, rule));
            return false;
        }
        if (!cvTerm.isUseTerm() && !cvTerm.isAllowChildren()) {
            String msg = "The term " + this.printSimpleCvTerm(cvTerm) + " defines that neither the term nor any of " + "its children can be used. The CvTerm will be removed.";
            messages.add(rule.buildMessage(rule.getElementPath(), Recommendation.forName(rule.getRequirementLevel()), msg, rule));
            return false;
        }
        if (!cvTerm.isIsRepeatable()) {
            String scope = rule.getScopePath();
            if (scope == null) {
                String msg = "The CvTerm " + this.printSimpleCvTerm(cvTerm) + " defines that the term is NOT repeatable, " + "but there was no scope defined. The CvTerm will be removed.";
                messages.add(rule.buildMessage(rule.getElementPath(), Recommendation.forName(rule.getRequirementLevel()), msg, rule));
                return false;
            }
            String xpath = rule.getElementPath();
            if (xpath.indexOf(scope) != 0) {
                String msg = "The CvTerm " + this.printSimpleCvTerm(cvTerm) + " defines that the term is NOT repeatable, " + "but the specified scope is not valid. The CvTerm will be removed.";
                messages.add(rule.buildMessage(rule.getElementPath(), Recommendation.forName(rule.getRequirementLevel()), msg, rule));
                return false;
            }
        }
        return true;
    }

    private void addRules(List<CvMappingRule> cvMappingRules) {
        if (this.rules == null) {
            this.rules = new ArrayList<CvRule>();
        }
        for (CvMappingRule cvMappingRule : cvMappingRules) {
            CvRuleImpl rule = new CvRuleImpl(this.ontologyMngr);
            rule.setCvMappingRule(cvMappingRule);
            this.rules.add(rule);
        }
    }

    protected String printSimpleCvTerm(CvTerm cv) {
        StringBuilder sb = new StringBuilder(64);
        sb.append('\'').append(cv.getTermName()).append('\'').append(' ');
        sb.append('(').append(cv.getTermAccession()).append(')');
        return sb.toString();
    }
}

