/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public class HttpProxyManager {
    public static final String PROXY_PROPERTIES_FILE = "/config/proxy.properties";
    private static Properties proxyProperties;

    private static Properties loadProperties() throws IOException {
        Properties properties = null;
        InputStream is = HttpProxyManager.class.getResourceAsStream(PROXY_PROPERTIES_FILE);
        if (is != null) {
            properties = new Properties();
            properties.load(is);
            return properties;
        }
        return properties;
    }

    private static void loadProxyProperties() throws ProxyConfigurationNotFound, IOException {
        if (proxyProperties == null) {
            proxyProperties = HttpProxyManager.loadProperties();
        }
        if (proxyProperties == null) {
            throw new ProxyConfigurationNotFound("Unable to load the file: /config/proxy.properties");
        }
    }

    public static void setup(PrintStream out) throws ProxyConfigurationNotFound, IOException {
        HttpProxyManager.loadProxyProperties();
        String proxyEnable = proxyProperties.getProperty("proxy.enable", "false");
        if (proxyEnable.equalsIgnoreCase("true")) {
            String hostname = proxyProperties.getProperty("proxy.host");
            String port = proxyProperties.getProperty("proxy.port");
            System.setProperty("http.proxySet", "true");
            System.setProperty("http.proxyHost", hostname);
            System.setProperty("http.proxyPort", port);
            if (out != null) {
                out.println("Using HTTP proxy setting: ");
            }
            if (out != null) {
                out.println("hostname: " + hostname);
            }
            if (out != null) {
                out.println("port: " + port);
            }
        } else {
            System.setProperty("http.proxySet", "false");
            if (out != null) {
                out.println("No proxy setting requested.");
            }
        }
    }

    public static void setup() throws ProxyConfigurationNotFound, IOException {
        HttpProxyManager.setup(System.out);
    }

    public static class ProxyConfigurationNotFound
    extends Exception {
        public ProxyConfigurationNotFound(String message) {
            super(message);
        }
    }
}

