/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.validator.util;

import java.util.ArrayList;
import java.util.Collection;
import psidev.psi.tools.validator.rules.cvmapping.CvRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorReport {
    private static final String NEW_LINE = System.getProperty("line.separator");
    Collection<CvRule> cvRulesNotChecked = new ArrayList<CvRule>();
    Collection<CvRule> cvRulesInvalidXpath = new ArrayList<CvRule>();
    Collection<CvRule> cvRulesValidXpath = new ArrayList<CvRule>();
    Collection<CvRule> cvRulesValid = new ArrayList<CvRule>();

    public ValidatorReport(Collection<CvRule> allCvRules) {
        this.splitCvRulesByStatus(allCvRules);
    }

    private void splitCvRulesByStatus(Collection<CvRule> allCvRules) {
        for (CvRule rule : allCvRules) {
            switch (rule.getStatus()) {
                case INVALID_XPATH: {
                    this.cvRulesInvalidXpath.add(rule);
                    break;
                }
                case NOT_CHECKED: {
                    this.cvRulesNotChecked.add(rule);
                    break;
                }
                case VALID_RULE: {
                    this.cvRulesValid.add(rule);
                    break;
                }
                case VALID_XPATH: {
                    this.cvRulesValidXpath.add(rule);
                }
            }
        }
    }

    public Collection<CvRule> getCvRulesNotChecked() {
        return this.cvRulesNotChecked;
    }

    public Collection<CvRule> getCvRulesInvalidXpath() {
        return this.cvRulesInvalidXpath;
    }

    public Collection<CvRule> getCvRulesValidXpath() {
        return this.cvRulesValidXpath;
    }

    public Collection<CvRule> getCvRulesValid() {
        return this.cvRulesValid;
    }

    private void printRules(StringBuilder sb, String header, Collection<CvRule> rules) {
        sb.append(header).append(" (").append(rules.size()).append(")").append(NEW_LINE);
        sb.append("-----------------------------------------------------").append(NEW_LINE);
        for (CvRule rule : rules) {
            sb.append(rule.getId()).append(" - ").append(rule.getName()).append(NEW_LINE);
        }
        sb.append(NEW_LINE);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        this.printRules(sb, "Valid rules", this.cvRulesValid);
        this.printRules(sb, "Rules with valid Xpath that have not collected data", this.cvRulesValidXpath);
        this.printRules(sb, "Rules with invalid Xpath", this.cvRulesInvalidXpath);
        this.printRules(sb, "Rules that haven't been run", this.cvRulesNotChecked);
        return sb.toString();
    }
}

