/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.config;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import uk.ac.ebi.ook.config.RepositoryConfigEntry;
import uk.ac.ebi.ook.config.RepositoryConfigurationException;
import uk.ac.ebi.proteomics.common.CommonUtilities;

public class ConfigurationManager {
    private static Properties props = null;
    private static final String CONFIG_FILE = "ols-config.properties";
    public static final String OLS_VERSION = "ols.version.number";
    public static final String OLS_VERSION_DATE = "ols.version.date";
    public static final String OLS_DBALIAS = "ols.dbalias";
    public static final String OLS_DBALIAS_IS_ORACLE = "ols.dbalias.is_oracle";
    public static final String INDEX_PATH = "lucene.index.path";
    public static final String REFRESH_URL = "loader.cacherefresh.url";
    public static final String DOT_EXECUTABLE = "dot.executable";
    public static final String LOADER_USERNAME = "loader.web.username";
    public static final String LOADER_PASSWORD = "loader.web.password";
    public static final String FAILOVER_USE = "failover.use";
    public static final String FAILOVER_DBALIAS = "failover.dbalias";
    public static final String FAILOVER_DBALIAS_IS_ORACLE = "failover.dbalias.is_oracle";
    private static HashSet cvsConfig = new HashSet();
    private static HashSet svnConfig = new HashSet();

    public static Properties getProperties() {
        if (props == null) {
            ConfigurationManager.loadProperties();
        }
        return props;
    }

    private static void loadProperties() {
        System.out.println("Loading configuration file from: ");
        try {
            URL file = CommonUtilities.getResource((String)CONFIG_FILE);
            if (file != null) {
                System.out.println(file.toString());
                props = new Properties();
                props.load(file.openStream());
                ConfigurationManager.loadCVSProperties();
                ConfigurationManager.loadSVNProperties();
            } else {
                System.err.println("Could not find configuration file!");
            }
        }
        catch (Exception ioe) {
            System.err.println("Error during property load: " + ioe.getMessage());
            ioe.printStackTrace();
            props = null;
        }
    }

    private static void loadSVNProperties() {
        ConfigurationManager.loadRepositoryProperties("svn", svnConfig);
    }

    private static void loadCVSProperties() {
        ConfigurationManager.loadRepositoryProperties("cvs", cvsConfig);
    }

    private static void loadRepositoryProperties(String repositoryPrefix, HashSet configSet) {
        int count = 0;
        Enumeration<Object> enm = props.keys();
        while (enm.hasMoreElements()) {
            String st = (String)enm.nextElement();
            if (!st.startsWith("loader." + repositoryPrefix)) continue;
            ++count;
        }
        if (count % 5 == 0) {
            int serverCount = count / 5;
            for (int i = 1; i <= serverCount; ++i) {
                RepositoryConfigEntry entry = new RepositoryConfigEntry();
                entry.setUserName(props.getProperty("loader." + repositoryPrefix + i + ".username"));
                entry.setPassword(props.getProperty("loader." + repositoryPrefix + i + ".password"));
                entry.setRepository(props.getProperty("loader." + repositoryPrefix + i + ".local.repository"));
                entry.setUseSSH(props.getProperty("loader." + repositoryPrefix + i + ".ssh"));
                entry.setUseAnonymous(props.getProperty("loader." + repositoryPrefix + i + ".anonymous"));
                if (!(entry.useAnonymous() || entry.getPassword() != null && entry.getUserName() != null)) {
                    throw new RepositoryConfigurationException(repositoryPrefix + " server configuration " + i + " is invalid because it is set to use non-anonymous access" + " but the username and password are not set correctly in " + CONFIG_FILE);
                }
                configSet.add(entry);
            }
        } else {
            throw new RepositoryConfigurationException("Not all the required " + repositoryPrefix + "configuration keys are properly configured in " + CONFIG_FILE);
        }
    }

    public static String getProperty(String propKey) {
        Properties localProps = ConfigurationManager.getProperties();
        if (localProps != null) {
            if (propKey != null) {
                return localProps.getProperty(propKey);
            }
            System.err.println("Null key passed to configurator, ignored.");
            return null;
        }
        System.err.println("Properties are null, not configured. Cannot return value for: " + propKey);
        return null;
    }

    public static HashSet getCvsConfig() {
        return cvsConfig;
    }

    public static HashSet getSvnConfig() {
        return svnConfig;
    }
}

