/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.impl;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import uk.ac.ebi.ook.config.ConfigurationManager;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;
import uk.ac.ebi.proteomics.common.CommonUtilities;
import uk.ac.ebi.proteomics.common.log.LoggerFactory;

public class OntologyUnloader {
    static Logger logger = LoggerFactory.getLogger((Class)(class$uk$ac$ebi$ook$loader$impl$OntologyUnloader == null ? (class$uk$ac$ebi$ook$loader$impl$OntologyUnloader = OntologyUnloader.class$("uk.ac.ebi.ook.loader.impl.OntologyUnloader")) : class$uk$ac$ebi$ook$loader$impl$OntologyUnloader), (URL)CommonUtilities.getResource((String)"ols-config.properties"));
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$impl$OntologyUnloader;

    public static void main(String[] args) {
        if (args.length > 1) {
            OntologyUnloader.unloadOntology(args);
        } else {
            logger.warn((Object)"You must specify at least one ontology to unload and the method to unload (-byname or -byid)");
        }
    }

    private static void unloadOntology(String[] ontologies) {
        block7: {
            String unloadType;
            block6: {
                unloadType = ontologies[0];
                if (!unloadType.equalsIgnoreCase("-byname")) break block6;
                for (int i = 1; i < ontologies.length; ++i) {
                    String ontology = ontologies[i];
                    try {
                        OntologyUnloader.unloadOntology(ontology);
                        continue;
                    }
                    catch (PersistenceException pe) {
                        logger.error((Object)pe.getMessage(), (Throwable)pe);
                    }
                }
                break block7;
            }
            if (!unloadType.equalsIgnoreCase("-byid")) break block7;
            for (int i = 1; i < ontologies.length; ++i) {
                long ontologyId = Long.parseLong(ontologies[i]);
                try {
                    OntologyUnloader.unloadOntology(ontologyId);
                    continue;
                }
                catch (PersistenceException pe) {
                    logger.error((Object)pe.getMessage(), (Throwable)pe);
                }
            }
        }
    }

    private static void unloadOntology(String ontology) throws PersistenceException {
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        Collection loaded = oqh.getOntologyReport(ontology, false);
        if (loaded != null && loaded.size() > 0) {
            logger.warn((Object)("Unloading " + loaded.size() + " old ontology(ies), this may take some time."));
            Iterator i = loaded.iterator();
            while (i.hasNext()) {
                boolean useFailover;
                Object[] objects = (Object[])i.next();
                boolean isOracle = new Boolean(ConfigurationManager.getProperty("ols.dbalias.is_oracle"));
                if (!oqh.rawSQLDeleteOntology(((Number)objects[0]).longValue(), isOracle)) {
                    logger.warn((Object)("Untology not unloaded!" + ontology));
                } else {
                    logger.warn((Object)("Untology unloaded: " + ontology));
                }
                if (!(useFailover = new Boolean(ConfigurationManager.getProperty("failover.use")).booleanValue())) continue;
                String dbAlias = ConfigurationManager.getProperty("failover.dbalias");
                if (dbAlias == null) {
                    throw new PersistenceException("Failover dbalias not properly configured");
                }
                oqh = new OntologyQueryHandler(dbAlias);
                isOracle = new Boolean(ConfigurationManager.getProperty("failover.dbalias.is_oracle"));
                if (!oqh.rawSQLDeleteOntology(((Number)objects[0]).longValue(), isOracle)) {
                    logger.warn((Object)("Untology not unloaded from failover db:" + ontology));
                    continue;
                }
                logger.warn((Object)("Untology unloaded from failover db: " + ontology));
            }
        }
    }

    private static void unloadOntology(long ontology) throws PersistenceException {
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        boolean isOracle = new Boolean(ConfigurationManager.getProperty("ols.dbalias.is_oracle"));
        if (!oqh.rawSQLDeleteOntology(ontology, isOracle)) {
            logger.warn((Object)("Untology not unloaded!" + ontology));
        } else {
            logger.warn((Object)("Untology unloaded: " + ontology));
        }
        boolean useFailover = new Boolean(ConfigurationManager.getProperty("failover.use"));
        if (useFailover) {
            String dbAlias = ConfigurationManager.getProperty("failover.dbalias");
            if (dbAlias == null) {
                throw new PersistenceException("Failover dbalias not properly configured");
            }
            oqh = new OntologyQueryHandler(dbAlias);
            isOracle = new Boolean(ConfigurationManager.getProperty("failover.dbalias.is_oracle"));
            if (!oqh.rawSQLDeleteOntology(ontology, isOracle)) {
                logger.warn((Object)("Untology not unloaded from failover db:" + ontology));
            } else {
                logger.warn((Object)("Untology unloaded from failover db: " + ontology));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

