/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.loader.psiutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import uk.ac.ebi.ook.loader.psiutils.Element;

public class ElementParser {
    private ArrayList loadOrder = new ArrayList();
    private HashMap elements = new HashMap();
    private Element currentElement = null;
    private static ElementParser instance = null;
    private Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$loader$psiutils$ElementParser == null ? (class$uk$ac$ebi$ook$loader$psiutils$ElementParser = ElementParser.class$("uk.ac.ebi.ook.loader.psiutils.ElementParser")) : class$uk$ac$ebi$ook$loader$psiutils$ElementParser));
    RE elementRegex = new RE("^([:alpha:]+)[:space:]*([:digit:]*\\.[:digit:]*)[:space:]*([0-9]+)[:space:]*!.*");
    RE isotopeRegex = new RE("^([:digit:]+)[:space:]*([:digit:]*\\.[:digit:]*).*");
    static /* synthetic */ Class class$uk$ac$ebi$ook$loader$psiutils$ElementParser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ElementParser(String loadPath) {
        if (loadPath == null) throw new RuntimeException("Can't file element file: " + loadPath);
        this.logger.warn((Object)("Loading element file: " + loadPath));
        BufferedReader in = null;
        File elementFile = new File(loadPath);
        in = new BufferedReader(new FileReader(elementFile));
        String elLine = in.readLine();
        while (elLine != null) {
            if (elLine.startsWith("#") || elLine.trim().length() == 0) continue;
            int nbIsotope = this.parseElementLine(elLine);
            for (int i = 0; i < nbIsotope; ++i) {
                elLine = in.readLine();
                if (elLine == null) throw new RuntimeException("Premature end of file!");
                if (this.isotopeRegex.match(elLine.trim())) {
                    String isotopeLabel = this.isotopeRegex.getParen(1);
                    String isotopeMass = this.isotopeRegex.getParen(2);
                    if (this.currentElement == null) continue;
                    this.currentElement.addIsotope(isotopeLabel, isotopeMass);
                    this.logger.debug((Object)("Added isotope: " + isotopeLabel + " mass: " + isotopeMass));
                    if (i != 0) continue;
                    this.currentElement.setMonoMass(isotopeMass);
                    continue;
                }
                this.logger.error((Object)("Invalid format for isotope: " + elLine.trim()));
            }
            if (this.currentElement != null) {
                this.elements.put(this.currentElement.getSymbol(), this.currentElement);
                this.loadOrder.add(this.currentElement.getSymbol());
            }
            elLine = in.readLine();
        }
        Object var10_10 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (Exception ignored) {}
        return;
        {
            catch (IOException ioe) {
                this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                Object var10_11 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (Exception ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private int parseElementLine(String oneLine) {
        if (this.elementRegex.match(oneLine.trim())) {
            String symbol = this.elementRegex.getParen(1);
            String avgMass = this.elementRegex.getParen(2);
            String nbIsotope = this.elementRegex.getParen(3);
            this.logger.debug((Object)("Element: " + symbol + " has avgMass: " + avgMass + " and " + nbIsotope + " isotopes."));
            Element element = new Element();
            element.setSymbol(symbol);
            element.setAvgMass(avgMass);
            this.currentElement = element;
            this.logger.debug((Object)("Current element is: " + symbol));
            return Integer.parseInt(nbIsotope);
        }
        throw new RuntimeException("Invalid line format: " + oneLine);
    }

    public static ElementParser getInstance(String loadPath) {
        if (instance == null) {
            instance = new ElementParser(loadPath);
        }
        return instance;
    }

    public HashMap getElements() {
        return this.elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void toFile(String savePath) {
        PrintWriter out = null;
        out = new PrintWriter(new FileWriter(new File(savePath)));
        Iterator i = this.loadOrder.iterator();
        while (i.hasNext()) {
            String symbol = (String)i.next();
            Element element = (Element)this.elements.get(symbol);
            out.println(symbol + " " + element.getAvgMass() + " " + element.getIsotopes().size());
            Iterator j = element.getIsotopes().keySet().iterator();
            while (j.hasNext()) {
                String isotope = (String)j.next();
                out.println("  " + isotope + " " + element.getIsotopeMass(isotope));
            }
        }
        Object var9_9 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception e) {}
        return;
        {
            catch (IOException ioe) {
                this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                Object var9_10 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception e) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static void main(String[] args) {
        ElementParser in = ElementParser.getInstance("d:/dev/ook/data/AtomTabl.dat");
        in.toFile("d:/dev/ook/data/AtomTabl-out.dat");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

