/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.model.ojb;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Date;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Level;
import uk.ac.ebi.ook.loader.impl.AbstractLoader;
import uk.ac.ebi.ook.loader.parser.OBOFormatParser;
import uk.ac.ebi.ook.model.interfaces.Ontology;
import uk.ac.ebi.ook.persistence.interfaces.Persistable;

public class OntologyBean
implements Ontology,
Persistable {
    private long ontologyId;
    private String shortOntologyName = null;
    private String fullOntologyName = null;
    private String definition = null;
    private String queryURL = null;
    private String sourceURL = null;
    private Collection terms = null;
    private Collection termRelationships = null;
    private Collection termPaths = null;
    private Date loadDate = null;
    private String version = null;
    private boolean fullyLoaded = false;

    public long getOntologyId() {
        return this.ontologyId;
    }

    public void setOntologyId(long _ontologyId) {
        this.ontologyId = _ontologyId;
    }

    public String getShortOntologyName() {
        return this.shortOntologyName;
    }

    public void setShortOntologyName(String _ontologyName) {
        this.shortOntologyName = _ontologyName;
    }

    public String getFullOntologyName() {
        return this.fullOntologyName;
    }

    public void setFullOntologyName(String _ontologyName) {
        this.fullOntologyName = _ontologyName;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String _definition) {
        this.definition = _definition;
    }

    public Collection getTerms() {
        return this.terms;
    }

    public void setTerms(Collection _terms) {
        this.terms = _terms;
    }

    public Collection getTermRelationships() {
        return this.termRelationships;
    }

    public void setTermRelationships(Collection _termRelationships) {
        this.termRelationships = _termRelationships;
    }

    public Collection getTermPaths() {
        return this.termPaths;
    }

    public void setTermPaths(Collection _termPaths) {
        this.termPaths = _termPaths;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String _version) {
        this.version = _version;
    }

    public java.util.Date getLoadDate() {
        return this.loadDate;
    }

    public void setLoadDate(Date _loadDate) {
        this.loadDate = _loadDate;
    }

    public void setLoadData(java.util.Date _loadDate) {
        this.loadDate = new Date(_loadDate.getTime());
    }

    public boolean getFullyLoaded() {
        return this.fullyLoaded;
    }

    public void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public String getQueryURL() {
        return this.queryURL;
    }

    public void setQueryURL(String queryURL) {
        this.queryURL = queryURL;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    public String toString() {
        return "OntologyBean{" + "ontologyId=" + this.ontologyId + ", shortOntologyName='" + this.shortOntologyName + '\'' + ", fullOntologyName='" + this.fullOntologyName + '\'' + ", definition='" + this.definition + '\'' + ", queryURL='" + this.queryURL + '\'' + ", sourceURL='" + this.sourceURL + '\'' + ", loadDate=" + this.loadDate + ", version='" + this.version + '\'' + ", fullyLoaded=" + this.fullyLoaded + ", nb terms=" + (this.terms != null ? this.terms.size() : 0) + ", nb rels=" + (this.termRelationships != null ? this.termRelationships.size() : 0) + ", nb paths=" + (this.termPaths != null ? this.termPaths.size() : 0) + '}';
    }

    public static Ontology loadFromOBOFile(String oboFilePath, String shortName, String fullName, String definition) throws IOException {
        File oboFile = new File(oboFilePath);
        if (!oboFile.exists()) {
            throw new IOException("The file path to be parsed does not exist");
        }
        return OntologyBean.loadFromOBOFile(oboFile, shortName, fullName, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ontology loadFromOBOFile(URL oboFileURL, String shortName, String fullName, String definition) throws IOException {
        File tempFile;
        BufferedWriter out;
        block10: {
            if (oboFileURL == null) {
                throw new IOException("The URL to be parsed must not be null.");
            }
            System.out.println("OntologyBean.loadFromOBOFile will read from: " + oboFileURL.toString());
            String NEW_LINE = System.getProperty("line.separator", "\n");
            StringBuffer buffer = new StringBuffer(8192);
            URLConnection conn = null;
            BufferedReader in = null;
            out = null;
            tempFile = null;
            try {
                String line;
                boolean useNumericalProgressDisplay = false;
                conn = oboFileURL.openConnection();
                int contentLength = conn.getContentLength();
                if (contentLength > 0) {
                    useNumericalProgressDisplay = true;
                }
                in = new BufferedReader(new InputStreamReader(conn.getInputStream()), 4096);
                int currentSize = 0;
                int currentPct = 0;
                int lineCount = 0;
                int reportInc = 10;
                int lastPct = -1;
                while ((line = in.readLine()) != null) {
                    buffer.append(line).append(NEW_LINE);
                    if (useNumericalProgressDisplay) {
                        currentSize = buffer.length();
                        currentPct = currentSize * 100 / contentLength;
                        if (currentPct % reportInc != 0 || currentPct == lastPct) continue;
                        System.out.print(currentPct + "% ");
                        System.out.flush();
                        lastPct = currentPct;
                        continue;
                    }
                    if (++lineCount % 20 != 0) continue;
                    System.out.print(".");
                    System.out.flush();
                    if (lineCount % 500 != 0) continue;
                    System.out.println("   " + lineCount);
                }
                System.out.println();
                System.out.println("OntologyBean.loadFromOBOFile is processing file.");
                File tempDirectory = new File(System.getProperty("java.io.tmpdir", "tmp"));
                if (!tempDirectory.exists() && !tempDirectory.mkdirs()) {
                    throw new IOException("Cannot create temp directory: " + tempDirectory.getAbsolutePath());
                }
                tempFile = File.createTempFile("ontologyBean.", ".obo", tempDirectory);
                tempFile.deleteOnExit();
                out = new BufferedWriter(new FileWriter(tempFile), 1024);
                out.write(buffer.toString());
                out.flush();
                Object var20_19 = null;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            in.close();
        }
        if (out != null) {
            out.close();
        }
        return OntologyBean.loadFromOBOFile(tempFile, shortName, fullName, definition);
    }

    public static Ontology loadFromOBOFile(final File oboFile, final String shortName, final String fullName, final String definition) throws IOException {
        if (shortName == null || shortName != null && "".equals(shortName.trim())) {
            throw new IllegalArgumentException("The ShortName of an ontology cannot be null");
        }
        if (!oboFile.exists()) {
            throw new IOException("The file path to be parsed does not exist");
        }
        AbstractLoader loader = new AbstractLoader(){

            protected void parse(Object params) throws IOException {
                Vector<String> v = new Vector<String>();
                v.add((String)params);
                ((OBOFormatParser)this.parser).configure(v);
                this.parser.parseFile();
            }

            protected void printUsage() {
            }

            protected void configure() {
                logger.setLevel(Level.OFF);
                this.parser = new OBOFormatParser();
                this.parser.setLoggerLevel(Level.OFF);
                this.ONTOLOGY_DEFINITION = definition;
                this.FULL_NAME = fullName;
                this.SHORT_NAME = shortName;
            }

            public Ontology getOntology() throws IOException {
                try {
                    this.configure();
                    this.parse(oboFile.getAbsolutePath());
                    this.process();
                    return super.getOntology();
                }
                catch (IllegalStateException ise) {
                    throw new IOException("There were errors while loading the ontology: " + ise.getMessage());
                }
            }
        };
        return loader.getOntology();
    }
}

