/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.struts.business;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public abstract class Emailer {
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$struts$business$Emailer == null ? (class$uk$ac$ebi$ook$web$struts$business$Emailer = Emailer.class$("uk.ac.ebi.ook.web.struts.business.Emailer")) : class$uk$ac$ebi$ook$web$struts$business$Emailer));
    public static final String SERVER_PROTOCOL = "email_protocol";
    public static final String SERVER_NAME_PROPERTY = "mail_server";
    public static final String USER_NAME_PROPERTY = "email_account_name";
    public static final String USER_PASSWORD_PROPERTY = "email_password";
    public static final String SENT_FROM_ADDRESS = "from_address";
    public static final String SEND_AUTOMATIC_EMAIL = "send_automatic_email";
    private static Properties emailProperties = null;
    private static final String ERROR_EMAIL_SUBJECT = "Unhandled exception in PRIDE web";
    private static final String SUPPORT_EMAIL_ADDRESS = "support_email";
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$struts$business$Emailer;

    public static String sendPlainTextMessage(ServletContext svCon, String subject, String message, Collection recipientAddresses, Collection ccAddresses, Collection bccAddresses, boolean copyInPrideSupport) {
        String retval = null;
        try {
            InternetAddress[] addressesBcc;
            InternetAddress[] addressesCc;
            StringBuffer messages = new StringBuffer();
            Properties props = Emailer.getEmailProperties(svCon);
            if (!"true".equals(props.getProperty(SEND_AUTOMATIC_EMAIL))) {
                return "Email functionality is turned off so no emails will be sent.";
            }
            if (!Emailer.isEmailSettingsComplete(props)) {
                return "The email settings are not complete and so no emails can be sent.";
            }
            Properties emailprops = new Properties();
            emailprops.put("mail.smtp.host", props.getProperty(SERVER_NAME_PROPERTY));
            emailprops.put("mail.smtp.user", props.getProperty(USER_NAME_PROPERTY));
            Session session = Session.getInstance((Properties)emailprops, null);
            MimeMessage msg = new MimeMessage(session);
            boolean noRecipients = true;
            if (copyInPrideSupport || recipientAddresses != null && recipientAddresses.size() > 0) {
                InternetAddress[] addressesTo;
                if (copyInPrideSupport) {
                    recipientAddresses = recipientAddresses == null ? new ArrayList<String>() : new ArrayList(recipientAddresses);
                    recipientAddresses.add(props.getProperty(SUPPORT_EMAIL_ADDRESS));
                }
                if ((addressesTo = Emailer.buildAddressArray(recipientAddresses, messages)) != null && addressesTo.length > 0) {
                    msg.setRecipients(Message.RecipientType.TO, (Address[])addressesTo);
                    noRecipients = false;
                }
            }
            if (ccAddresses != null && ccAddresses.size() > 0 && (addressesCc = Emailer.buildAddressArray(ccAddresses, messages)) != null && addressesCc.length > 0) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])addressesCc);
                noRecipients = false;
            }
            if (bccAddresses != null && bccAddresses.size() > 0 && (addressesBcc = Emailer.buildAddressArray(bccAddresses, messages)) != null && addressesBcc.length > 0) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])addressesBcc);
                noRecipients = false;
            }
            if (noRecipients) {
                messages.append("There are no valid recipients for this email.");
                return messages.toString();
            }
            Transport tr = session.getTransport(props.getProperty(SERVER_PROTOCOL));
            tr.connect(props.getProperty(SERVER_NAME_PROPERTY), props.getProperty(USER_NAME_PROPERTY), "".equals(props.getProperty(USER_PASSWORD_PROPERTY)) ? null : props.getProperty(USER_PASSWORD_PROPERTY));
            msg.setSubject(subject);
            msg.setContent((Object)message.toString(), "text/plain");
            msg.saveChanges();
            Transport.send((Message)msg);
            tr.close();
            retval = messages.toString();
        }
        catch (MessagingException me) {
            logger.error((Object)me.getMessage(), (Throwable)me);
            retval = me.getMessage();
        }
        return retval;
    }

    private static InternetAddress[] buildAddressArray(Collection emailAddressStrings, StringBuffer errorStringBuffer) {
        ArrayList<InternetAddress> addressArrayList = new ArrayList<InternetAddress>();
        Iterator emailAddressIterator = emailAddressStrings.iterator();
        while (emailAddressIterator.hasNext()) {
            String address = (String)emailAddressIterator.next();
            try {
                if (!address.matches("^(([A-Za-z0-9]+_+)|([A-Za-z0-9]+\\-+)|([A-Za-z0-9]+\\.+)|([A-Za-z0-9]+\\++))*[A-Za-z0-9]+@((\\w+\\-+)|(\\w+\\.))*\\w{1,63}\\.[a-zA-Z]{2,6}$")) {
                    throw new AddressException("This does not look like a valid email address", address);
                }
                InternetAddress addressTo = new InternetAddress(address);
                addressArrayList.add(addressTo);
            }
            catch (AddressException ae) {
                if (errorStringBuffer.length() == 0) {
                    errorStringBuffer.append("The following email addresses are poorly formed and have not been contacted: ");
                }
                errorStringBuffer.append(address).append(" (").append(ae.getMessage()).append("), ");
            }
        }
        InternetAddress[] returnArray = new InternetAddress[addressArrayList.size()];
        for (int i = 0; i < addressArrayList.size(); ++i) {
            InternetAddress internetAddress;
            returnArray[i] = internetAddress = (InternetAddress)addressArrayList.get(i);
        }
        return returnArray;
    }

    private static synchronized Properties getEmailProperties(ServletContext svCon) {
        if (emailProperties == null) {
            emailProperties = new Properties();
            Enumeration enumeration = svCon.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (key == null || svCon.getInitParameter(key) == null) continue;
                emailProperties.setProperty(key, svCon.getInitParameter(key));
            }
        }
        logger.debug((Object)("Loaded Properties: " + emailProperties.toString()));
        return emailProperties;
    }

    public static boolean isEmailSettingsComplete(ServletContext svCon) {
        Properties props = Emailer.getEmailProperties(svCon);
        return Emailer.isEmailSettingsComplete(props);
    }

    private static boolean isEmailSettingsComplete(Properties props) {
        return props.getProperty(SERVER_PROTOCOL) != null && !"".equals(props.getProperty(SERVER_PROTOCOL)) && props.getProperty(SERVER_NAME_PROPERTY) != null && !"".equals(props.getProperty(SERVER_NAME_PROPERTY)) && props.getProperty(USER_NAME_PROPERTY) != null && !"".equals(props.getProperty(USER_NAME_PROPERTY)) && props.getProperty(SENT_FROM_ADDRESS) != null && !"".equals(props.getProperty(SENT_FROM_ADDRESS)) && props.getProperty(SUPPORT_EMAIL_ADDRESS) != null && !"".equals(props.getProperty(SUPPORT_EMAIL_ADDRESS));
    }

    public static void sendSupportEmail(Throwable e, ServletContext svCon) {
        if (e != null) {
            svCon.log("Uncaught exception trapped: " + e.getMessage(), e);
        }
        if (e != null) {
            logger.error((Object)("Uncaught exception trapped: " + e.getMessage()), e);
        }
        StringBuffer message = new StringBuffer();
        message.append("An uncaught exception happened in OLS. The full error message is below:\n\n");
        if (e != null) {
            message.append(e.getMessage() + "\n");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            sw.flush();
            message.append(sw.toString());
            pw.close();
        }
        message.append("\n\nDumping servlet context:\n");
        Enumeration names = svCon.getAttributeNames();
        while (names.hasMoreElements()) {
            String attrName = (String)names.nextElement();
            Object attr = svCon.getAttribute(attrName);
            if (attr == null) continue;
            message.append("\n" + attrName + " : " + attr.toString());
        }
        Emailer.sendPlainTextMessage(svCon, ERROR_EMAIL_SUBJECT, message.toString(), null, null, null, true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

