/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.struts.business;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;
import uk.ac.ebi.ook.web.struts.view.SimpleOntologyHolder;

public class OntologyReportSingleton {
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$struts$business$OntologyReportSingleton == null ? (class$uk$ac$ebi$ook$web$struts$business$OntologyReportSingleton = OntologyReportSingleton.class$("uk.ac.ebi.ook.web.struts.business.OntologyReportSingleton")) : class$uk$ac$ebi$ook$web$struts$business$OntologyReportSingleton));
    private static OntologyReportSingleton instance = null;
    private static TreeSet ontologiesByShortName = null;
    private static TreeSet ontologiesByFullName = null;
    private static final String TERM_SEPARATOR = ":";
    private static int totalCount = -1;
    private static Date updateDate = null;
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$struts$business$OntologyReportSingleton;

    public static synchronized OntologyReportSingleton getInstance() {
        if (instance == null) {
            instance = new OntologyReportSingleton();
        }
        return instance;
    }

    public static synchronized void clearCache() {
        if (instance != null) {
            instance = new OntologyReportSingleton();
        }
    }

    private OntologyReportSingleton() {
        updateDate = new Date();
        ontologiesByShortName = new TreeSet();
        OntologyQueryHandler oqh = new OntologyQueryHandler();
        Collection report = oqh.getOntologyReport();
        totalCount = oqh.getOntologyTermCount(null);
        Iterator i = report.iterator();
        while (i.hasNext()) {
            Object[] objects = (Object[])i.next();
            SimpleOntologyHolder soh = new SimpleOntologyHolder();
            soh.setShortName((String)objects[1]);
            soh.setFullName((String)objects[2]);
            soh.setLoadDate(objects[3].toString());
            soh.setQueryURL((String)objects[4]);
            soh.setSourceURL((String)objects[5]);
            soh.setVersion((String)objects[6]);
            soh.setSize(oqh.getOntologyTermCount(soh.getShortName()));
            ontologiesByShortName.add(soh);
        }
    }

    public TreeSet getOntologies() {
        return ontologiesByShortName;
    }

    public int getOntologyCount() {
        return ontologiesByShortName.size();
    }

    public int getTotalTermCount() {
        return totalCount;
    }

    public String buildURL(String termAccession) {
        if (termAccession != null) {
            int ndx = termAccession.indexOf(TERM_SEPARATOR);
            if (ndx > 0) {
                String ontName = termAccession.substring(0, ndx);
                String url = this.getOntologyQueryURL(ontName);
                if (url != null) {
                    try {
                        return MessageFormat.format(url, termAccession);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public String buildURL(String termAccession, String url) {
        if (termAccession != null) {
            try {
                return MessageFormat.format(url, termAccession);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public String getOntologyQueryURL(String shortOntologyName) {
        if (ontologiesByShortName != null) {
            Iterator i = ontologiesByShortName.iterator();
            while (i.hasNext()) {
                SimpleOntologyHolder soh = (SimpleOntologyHolder)i.next();
                if (soh.getShortName() == null || !soh.getShortName().equals(shortOntologyName)) continue;
                return soh.getQueryURL();
            }
        }
        return null;
    }

    public TreeSet getOntologiesByFullName() {
        if (ontologiesByFullName == null) {
            ontologiesByFullName = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    try {
                        SimpleOntologyHolder soh1 = (SimpleOntologyHolder)o1;
                        SimpleOntologyHolder soh2 = (SimpleOntologyHolder)o2;
                        return soh1.getFullName().compareTo(soh2.getFullName());
                    }
                    catch (Exception e) {
                        return -1;
                    }
                }
            });
            ontologiesByFullName.addAll(ontologiesByShortName);
        }
        return ontologiesByFullName;
    }

    public String getUpdateDate() {
        return updateDate.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

