/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.ook.web.struts.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import uk.ac.ebi.ook.config.ConfigurationManager;
import uk.ac.ebi.ook.loader.lucene.OntologyIndexer;
import uk.ac.ebi.ook.model.interfaces.Ontology;
import uk.ac.ebi.ook.model.ojb.OntologyBean;
import uk.ac.ebi.ook.persistence.exceptions.PersistenceException;
import uk.ac.ebi.ook.persistence.query.OntologyQueryHandler;
import uk.ac.ebi.ook.web.struts.view.FileSubmissionForm;
import uk.ac.ebi.proteomics.common.security.PasswordUtilities;

public class OntologyLoadAction
extends Action {
    private Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$ook$web$struts$controller$OntologyLoadAction == null ? (class$uk$ac$ebi$ook$web$struts$controller$OntologyLoadAction = OntologyLoadAction.class$("uk.ac.ebi.ook.web.struts.controller.OntologyLoadAction")) : class$uk$ac$ebi$ook$web$struts$controller$OntologyLoadAction));
    private static final int CUTOFF_LIMIT = 1500;
    static /* synthetic */ Class class$uk$ac$ebi$ook$web$struts$controller$OntologyLoadAction;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionMessages messages;
        boolean allOk;
        block8: {
            allOk = false;
            messages = new ActionMessages();
            FileSubmissionForm submissionForm = (FileSubmissionForm)form;
            if (this.checkCredentials(submissionForm.getUsername(), submissionForm.getPassword(), submissionForm.getChallenge())) {
                try {
                    FormFile file = submissionForm.getFile();
                    File toLoad = this.createTempOBOFile(file);
                    Ontology ont = OntologyBean.loadFromOBOFile(toLoad, submissionForm.getShortLabel(), submissionForm.getFullName(), submissionForm.getDefinition());
                    if (ont.getTerms().size() < 1500) {
                        OntologyQueryHandler oqh = new OntologyQueryHandler();
                        oqh.storeOntology(ont, true);
                        oqh.updateLoadedFlag((OntologyBean)ont, true);
                        OntologyIndexer.indexOntology(ont, new File(ConfigurationManager.getProperty("lucene.index.path")));
                        OntologyIndexer.mergeAllIndexes(new File(ConfigurationManager.getProperty("lucene.index.path")));
                        request.setAttribute("loaded_ontology", (Object)ont.getShortOntologyName());
                        allOk = true;
                        break block8;
                    }
                    messages.add("size", new ActionMessage("submission.ontology.too.large"));
                }
                catch (PersistenceException pe) {
                    this.logger.error((Object)pe.getMessage(), (Throwable)pe);
                    messages.add("persistence", new ActionMessage("submission.persistence.error"));
                    allOk = false;
                }
                catch (IOException ioe) {
                    this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                    messages.add("IO", new ActionMessage("submission.io.error"));
                    allOk = false;
                }
                catch (IllegalStateException ise) {
                    this.logger.error((Object)ise.getMessage(), (Throwable)ise);
                    messages.add("IO", new ActionMessage("submission.io.error"));
                    allOk = false;
                }
            } else {
                messages.add("login", new ActionMessage("submission.invalid.credentials"));
            }
        }
        this.saveMessages(request, messages);
        if (allOk) {
            return mapping.findForward("ontologyLoadSuccess");
        }
        return mapping.findForward("ontologyLoadError");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File createTempOBOFile(FormFile file) {
        File obo = null;
        BufferedWriter out = null;
        File tempDirectory = new File(System.getProperty("java.io.tmpdir", "tmp"));
        if (!tempDirectory.exists() && !tempDirectory.mkdirs()) {
            throw new IOException("Cannot create temp directory: " + tempDirectory.getAbsolutePath());
        }
        obo = File.createTempFile(file.getFileName() + ".", "tmp", tempDirectory);
        obo.deleteOnExit();
        out = new BufferedWriter(new FileWriter(obo));
        out.write(new String(file.getFileData()));
        out.flush();
        Object var7_6 = null;
        if (out == null) return obo;
        try {
            out.close();
            return obo;
        }
        catch (IOException e) {}
        return obo;
        {
            catch (IOException ioe) {
                this.logger.error((Object)ioe.getMessage(), (Throwable)ioe);
                File file2 = null;
                Object var7_7 = null;
                if (out == null) return file2;
                try {
                    out.close();
                    return file2;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return file2;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean checkCredentials(String username, String password, String challenge) {
        boolean isAllowed = false;
        if (username != null && ConfigurationManager.getProperty("loader.web.username").equals(username) && password != null) {
            String allowedPassword = ConfigurationManager.getProperty("loader.web.password");
            if (PasswordUtilities.MD5Hash((String)(challenge + PasswordUtilities.MD5Hash((String)allowedPassword))).equals(password)) {
                isAllowed = true;
            }
        }
        return isAllowed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

