/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.proteomics.common.cache;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.log4j.Logger;
import uk.ac.ebi.proteomics.common.CommonUtilities;

public abstract class AbstractTimedLRUCache {
    public static final String CACHE_OVERRIDE = "cache.file";
    public static final String CACHE_FILE = "cache.properties";
    public static final String CACHE_PACKAGE = "cache.package";
    public static final String PROT_COMM_PACKAGE = "proteomics";
    public static final String PROP_CACHE_SIZE = "cache.size";
    public static final String PROP_CACHE_TTL = "cache.ttl";
    private static Logger logger = Logger.getLogger((Class)(class$uk$ac$ebi$proteomics$common$cache$AbstractTimedLRUCache == null ? (class$uk$ac$ebi$proteomics$common$cache$AbstractTimedLRUCache = AbstractTimedLRUCache.class$("uk.ac.ebi.proteomics.common.cache.AbstractTimedLRUCache")) : class$uk$ac$ebi$proteomics$common$cache$AbstractTimedLRUCache));
    protected LRUMap cacheMap;
    protected long ttl;
    private long DEFAULT_TTL = 86400000L;
    private int DEFAULT_CAPACITY = 100;
    static /* synthetic */ Class class$uk$ac$ebi$proteomics$common$cache$AbstractTimedLRUCache;

    protected AbstractTimedLRUCache() {
        String string = System.getProperty(CACHE_OVERRIDE, CACHE_FILE);
        String string2 = System.getProperty(CACHE_PACKAGE, PROT_COMM_PACKAGE);
        URL uRL = CommonUtilities.getResource(string, string2);
        if (uRL != null) {
            logger.debug((Object)("Configuring cache with " + uRL.toString()));
        }
        Properties properties = new Properties();
        try {
            properties.load(uRL.openStream());
            this.initCache(properties);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            logger.warn((Object)"Configuring cache with default properties!");
            this.initCache(null);
        }
    }

    protected void initCache(Properties properties) {
        int n = this.DEFAULT_CAPACITY;
        this.ttl = this.DEFAULT_TTL;
        if (properties != null) {
            String string = properties.getProperty(PROP_CACHE_SIZE);
            n = CommonUtilities.safeParseInt(string, this.DEFAULT_CAPACITY);
            String string2 = properties.getProperty(PROP_CACHE_TTL);
            this.ttl = CommonUtilities.safeParseLong(string2, this.DEFAULT_TTL);
        }
        this.cacheMap = new LRUMap(n);
    }

    protected boolean validateTimestamp(long l) {
        long l2 = System.currentTimeMillis();
        return l2 - l < this.ttl;
    }

    public synchronized void clearCache() {
        this.cacheMap.clear();
        logger.debug((Object)"Cache cleared!");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

