/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;

public class OptionBuilderTest
extends TestCase {
    public OptionBuilderTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(OptionBuilderTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)OptionBuilderTest.suite());
    }

    public void testCompleteOption() {
        OptionBuilder.withLongOpt("simple option");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withType(new Float(10.0f));
        OptionBuilder.withDescription("this is a simple option");
        Option simple = OptionBuilder.create('s');
        OptionBuilderTest.assertEquals((String)"s", (String)simple.getOpt());
        OptionBuilderTest.assertEquals((String)"simple option", (String)simple.getLongOpt());
        OptionBuilderTest.assertEquals((String)"this is a simple option", (String)simple.getDescription());
        OptionBuilderTest.assertEquals(simple.getType().getClass(), Float.class);
        OptionBuilderTest.assertTrue((boolean)simple.hasArg());
        OptionBuilderTest.assertTrue((boolean)simple.isRequired());
        OptionBuilderTest.assertTrue((boolean)simple.hasArgs());
    }

    public void testTwoCompleteOptions() {
        OptionBuilder.withLongOpt("simple option");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.hasArgs();
        OptionBuilder.withType(new Float(10.0f));
        OptionBuilder.withDescription("this is a simple option");
        Option simple = OptionBuilder.create('s');
        OptionBuilderTest.assertEquals((String)"s", (String)simple.getOpt());
        OptionBuilderTest.assertEquals((String)"simple option", (String)simple.getLongOpt());
        OptionBuilderTest.assertEquals((String)"this is a simple option", (String)simple.getDescription());
        OptionBuilderTest.assertEquals(simple.getType().getClass(), Float.class);
        OptionBuilderTest.assertTrue((boolean)simple.hasArg());
        OptionBuilderTest.assertTrue((boolean)simple.isRequired());
        OptionBuilderTest.assertTrue((boolean)simple.hasArgs());
        OptionBuilder.withLongOpt("dimple option");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("this is a dimple option");
        simple = OptionBuilder.create('d');
        OptionBuilderTest.assertEquals((String)"d", (String)simple.getOpt());
        OptionBuilderTest.assertEquals((String)"dimple option", (String)simple.getLongOpt());
        OptionBuilderTest.assertEquals((String)"this is a dimple option", (String)simple.getDescription());
        OptionBuilderTest.assertNull((Object)simple.getType());
        OptionBuilderTest.assertTrue((boolean)simple.hasArg());
        OptionBuilderTest.assertTrue((!simple.isRequired() ? 1 : 0) != 0);
        OptionBuilderTest.assertTrue((!simple.hasArgs() ? 1 : 0) != 0);
    }

    public void testBaseOptionCharOpt() {
        OptionBuilder.withDescription("option description");
        Option base = OptionBuilder.create('o');
        OptionBuilderTest.assertEquals((String)"o", (String)base.getOpt());
        OptionBuilderTest.assertEquals((String)"option description", (String)base.getDescription());
        OptionBuilderTest.assertTrue((!base.hasArg() ? 1 : 0) != 0);
    }

    public void testBaseOptionStringOpt() {
        OptionBuilder.withDescription("option description");
        Option base = OptionBuilder.create("o");
        OptionBuilderTest.assertEquals((String)"o", (String)base.getOpt());
        OptionBuilderTest.assertEquals((String)"option description", (String)base.getDescription());
        OptionBuilderTest.assertTrue((!base.hasArg() ? 1 : 0) != 0);
    }

    public void testSpecialOptChars() {
        Option opt;
        try {
            OptionBuilder.withDescription("help options");
            opt = OptionBuilder.create('?');
            OptionBuilderTest.assertEquals((String)"?", (String)opt.getOpt());
        }
        catch (IllegalArgumentException arg) {
            OptionBuilderTest.fail((String)"IllegalArgumentException caught");
        }
        try {
            OptionBuilder.withDescription("read from stdin");
            opt = OptionBuilder.create('@');
            OptionBuilderTest.assertEquals((String)"@", (String)opt.getOpt());
        }
        catch (IllegalArgumentException arg) {
            OptionBuilderTest.fail((String)"IllegalArgumentException caught");
        }
    }

    public void testOptionArgNumbers() {
        OptionBuilder.withDescription("option description");
        OptionBuilder.hasArgs(2);
        Option opt = OptionBuilder.create('o');
        OptionBuilderTest.assertEquals((int)2, (int)opt.getArgs());
    }

    public void testIllegalOptions() {
        Option opt;
        try {
            OptionBuilder.withDescription("option description");
            opt = OptionBuilder.create('\"');
            OptionBuilderTest.fail((String)"IllegalArgumentException not caught");
        }
        catch (IllegalArgumentException exp) {
            // empty catch block
        }
        try {
            opt = OptionBuilder.create("opt`");
            OptionBuilderTest.fail((String)"IllegalArgumentException not caught");
        }
        catch (IllegalArgumentException exp) {
            // empty catch block
        }
        try {
            opt = OptionBuilder.create("opt");
        }
        catch (IllegalArgumentException exp) {
            OptionBuilderTest.fail((String)"IllegalArgumentException caught");
        }
    }
}

