/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Vector;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.cli.PosixParser;

public class PatternOptionBuilderTest
extends TestCase {
    public static void main(String[] args) {
        String[] testName = new String[]{PatternOptionBuilderTest.class.getName()};
        TestRunner.main((String[])testName);
    }

    public static TestSuite suite() {
        return new TestSuite(PatternOptionBuilderTest.class);
    }

    public PatternOptionBuilderTest(String s) {
        super(s);
    }

    public void testSimplePattern() {
        try {
            Options options = PatternOptionBuilder.parsePattern("a:b@cde>f+n%t/");
            String[] args = new String[]{"-c", "-a", "foo", "-b", "java.util.Vector", "-e", "build.xml", "-f", "java.util.Calendar", "-n", "4.5", "-t", "http://jakarta.apache.org/"};
            PosixParser parser = new PosixParser();
            CommandLine line = parser.parse(options, args);
            PatternOptionBuilderTest.assertEquals((String)"flag a", (String)"foo", (String)line.getOptionValue("a"));
            PatternOptionBuilderTest.assertEquals((String)"flag a", (String)"foo", (String)line.getOptionValue('a'));
            PatternOptionBuilderTest.assertEquals((String)"string flag a", (Object)"foo", (Object)line.getOptionObject("a"));
            PatternOptionBuilderTest.assertEquals((String)"string flag a", (Object)"foo", (Object)line.getOptionObject('a'));
            PatternOptionBuilderTest.assertEquals((String)"object flag b", new Vector(), (Object)line.getOptionObject("b"));
            PatternOptionBuilderTest.assertEquals((String)"object flag b", new Vector(), (Object)line.getOptionObject('b'));
            PatternOptionBuilderTest.assertEquals((String)"boolean true flag c", (boolean)true, (boolean)line.hasOption("c"));
            PatternOptionBuilderTest.assertEquals((String)"boolean true flag c", (boolean)true, (boolean)line.hasOption('c'));
            PatternOptionBuilderTest.assertEquals((String)"boolean false flag d", (boolean)false, (boolean)line.hasOption("d"));
            PatternOptionBuilderTest.assertEquals((String)"boolean false flag d", (boolean)false, (boolean)line.hasOption('d'));
            PatternOptionBuilderTest.assertEquals((String)"file flag e", (Object)new File("build.xml"), (Object)line.getOptionObject("e"));
            PatternOptionBuilderTest.assertEquals((String)"file flag e", (Object)new File("build.xml"), (Object)line.getOptionObject('e'));
            PatternOptionBuilderTest.assertEquals((String)"class flag f", Calendar.class, (Object)line.getOptionObject("f"));
            PatternOptionBuilderTest.assertEquals((String)"class flag f", Calendar.class, (Object)line.getOptionObject('f'));
            PatternOptionBuilderTest.assertEquals((String)"number flag n", (Object)new Float(4.5), (Object)line.getOptionObject("n"));
            PatternOptionBuilderTest.assertEquals((String)"number flag n", (Object)new Float(4.5), (Object)line.getOptionObject('n'));
            PatternOptionBuilderTest.assertEquals((String)"url flag t", (Object)new URL("http://jakarta.apache.org/"), (Object)line.getOptionObject("t"));
            PatternOptionBuilderTest.assertEquals((String)"url flag t", (Object)new URL("http://jakarta.apache.org/"), (Object)line.getOptionObject('t'));
        }
        catch (ParseException exp) {
            PatternOptionBuilderTest.fail((String)exp.getMessage());
        }
        catch (MalformedURLException exp) {
            PatternOptionBuilderTest.fail((String)exp.getMessage());
        }
    }
}

