/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public class TestHelpFormatter
extends TestCase {
    public static void main(String[] args) {
        String[] testName = new String[]{TestHelpFormatter.class.getName()};
        TestRunner.main((String[])testName);
    }

    public static TestSuite suite() {
        return new TestSuite(TestHelpFormatter.class);
    }

    public TestHelpFormatter(String s) {
        super(s);
    }

    public void testFindWrapPos() throws Exception {
        HelpFormatter hf = new HelpFormatter();
        String text = "This is a test.";
        TestHelpFormatter.assertEquals((String)"wrap position", (int)7, (int)hf.findWrapPos(text, 8, 0));
        TestHelpFormatter.assertEquals((String)"wrap position 2", (int)-1, (int)hf.findWrapPos(text, 8, 8));
        text = "aaaa aa";
        TestHelpFormatter.assertEquals((String)"wrap position 3", (int)4, (int)hf.findWrapPos(text, 3, 0));
    }

    public void testPrintWrapped() throws Exception {
        StringBuffer sb = new StringBuffer();
        HelpFormatter hf = new HelpFormatter();
        String text = "This is a test.";
        String expected = "This is a" + hf.getNewLine() + "test.";
        hf.renderWrappedText(sb, 12, 0, text);
        TestHelpFormatter.assertEquals((String)"single line text", (String)expected, (String)sb.toString());
        sb.setLength(0);
        expected = "This is a" + hf.getNewLine() + "    test.";
        hf.renderWrappedText(sb, 12, 4, text);
        TestHelpFormatter.assertEquals((String)"single line padded text", (String)expected, (String)sb.toString());
        expected = text = "aaaa aaaa aaaa" + hf.getNewLine() + "aaaaaa" + hf.getNewLine() + "aaaaa";
        sb.setLength(0);
        hf.renderWrappedText(sb, 16, 0, text);
        TestHelpFormatter.assertEquals((String)"multi line text", (String)expected, (String)sb.toString());
        expected = "aaaa aaaa aaaa" + hf.getNewLine() + "    aaaaaa" + hf.getNewLine() + "    aaaaa";
        sb.setLength(0);
        hf.renderWrappedText(sb, 16, 4, text);
        TestHelpFormatter.assertEquals((String)"multi-line padded text", (String)expected, (String)sb.toString());
    }

    public void testPrintOptions() throws Exception {
        StringBuffer sb = new StringBuffer();
        HelpFormatter hf = new HelpFormatter();
        boolean leftPad = true;
        int descPad = 3;
        String lpad = hf.createPadding(1);
        String dpad = hf.createPadding(3);
        Options options = null;
        String expected = null;
        options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa");
        expected = lpad + "-a" + dpad + "aaaa aaaa aaaa aaaa aaaa";
        hf.renderOptions(sb, 60, options, 1, 3);
        TestHelpFormatter.assertEquals((String)"simple non-wrapped option", (String)expected, (String)sb.toString());
        int nextLineTabStop = 4 + "-a".length();
        expected = lpad + "-a" + dpad + "aaaa aaaa aaaa" + hf.getNewLine() + hf.createPadding(nextLineTabStop) + "aaaa aaaa";
        sb.setLength(0);
        hf.renderOptions(sb, nextLineTabStop + 17, options, 1, 3);
        TestHelpFormatter.assertEquals((String)"simple wrapped option", (String)expected, (String)sb.toString());
        options = new Options().addOption("a", "aaa", false, "dddd dddd dddd dddd");
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd dddd dddd";
        sb.setLength(0);
        hf.renderOptions(sb, 60, options, 1, 3);
        TestHelpFormatter.assertEquals((String)"long non-wrapped option", (String)expected, (String)sb.toString());
        nextLineTabStop = 4 + "-a,--aaa".length();
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd" + hf.getNewLine() + hf.createPadding(nextLineTabStop) + "dddd dddd";
        sb.setLength(0);
        hf.renderOptions(sb, 25, options, 1, 3);
        TestHelpFormatter.assertEquals((String)"long wrapped option", (String)expected, (String)sb.toString());
        options = new Options().addOption("a", "aaa", false, "dddd dddd dddd dddd").addOption("b", false, "feeee eeee eeee eeee");
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd" + hf.getNewLine() + hf.createPadding(nextLineTabStop) + "dddd dddd" + hf.getNewLine() + lpad + "-b      " + dpad + "feeee eeee" + hf.getNewLine() + hf.createPadding(nextLineTabStop) + "eeee eeee";
        sb.setLength(0);
        hf.renderOptions(sb, 25, options, 1, 3);
        TestHelpFormatter.assertEquals((String)"multiple wrapped options", (String)expected, (String)sb.toString());
    }

    public void testAutomaticUsage() throws Exception {
        HelpFormatter hf = new HelpFormatter();
        Options options = null;
        String expected = "usage: app [-a]";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa");
        hf.printUsage(pw, 60, "app", options);
        pw.flush();
        TestHelpFormatter.assertEquals((String)"simple auto usage", (String)expected, (String)out.toString().trim());
        out.reset();
        expected = "usage: app [-a] [-b]";
        options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa").addOption("b", false, "bbb");
        hf.printUsage(pw, 60, "app", options);
        pw.flush();
        TestHelpFormatter.assertEquals((String)"simple auto usage", (String)expected, (String)out.toString().trim());
        out.reset();
    }
}

