/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.view.gui;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyNetworkUtilities;
import cytoscape.ding.DingNetworkView;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import giny.view.NodeView;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.view.gui.misc.JCollapsablePanel;

public class SelectedGOTermsPanel
extends JCollapsablePanel
implements MouseListener {
    private String[] selectedTerms = new String[0];
    private GOSlimmerController controller;
    private static final String lsep = System.getProperty("line.separator");
    JScrollPane selectedGOTermsScrollPane;
    private static final String selectedGOTermsToolTip = "List of selected GO nodes.";

    public SelectedGOTermsPanel(GOSlimmerController controller) {
        super("Selected GO Terms");
        this.controller = controller;
        this.initComponents();
    }

    private JScrollPane getSelectedGOTermsScrollPane() {
        if (this.selectedGOTermsScrollPane == null) {
            this.selectedGOTermsScrollPane = new JScrollPane();
            this.selectedGOTermsScrollPane.setToolTipText(selectedGOTermsToolTip);
            this.selectedGOTermsScrollPane.setHorizontalScrollBarPolicy(30);
            Dimension dim = new Dimension();
            dim.setSize(325.0, 94.0);
            this.selectedGOTermsScrollPane.setPreferredSize(dim);
            JList<String> selectedTermsList = new JList<String>(this.selectedTerms);
            selectedTermsList.setVisibleRowCount(4);
            selectedTermsList.setSelectionMode(0);
            selectedTermsList.addMouseListener(this);
            this.selectedGOTermsScrollPane.getViewport().setView(selectedTermsList);
        }
        return this.selectedGOTermsScrollPane;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        this.add(this.getSelectedGOTermsScrollPane());
    }

    public void mouseClicked(MouseEvent event) {
        JList list;
        int index;
        Object src = event.getSource();
        if (src instanceof JList && (index = (list = (JList)src).getSelectedIndex()) != -1) {
            String name = (String)list.getSelectedValue();
            int pIndex = name.lastIndexOf("(");
            String goId = name.substring(pIndex + 1, name.length() - 1);
            CyNetwork network = this.controller.getNetwork();
            CyNetworkView view = this.controller.getNetworkView();
            network.unselectAllNodes();
            boolean found = CyNetworkUtilities.selectNodesStartingWith((CyNetwork)network, (String)goId, (CyNetworkView)view);
            if (found) {
                ((DingNetworkView)view).fitSelected();
                Set nodeSet = network.getSelectedNodes();
                if (nodeSet.size() == 1) {
                    CyNode node = (CyNode)nodeSet.toArray()[0];
                    NodeView nodeView = view.getNodeView((Node)node);
                    double nWidth = nodeView.getWidth();
                    FontMetrics metrics = this.getFontMetrics(nodeView.getLabel().getFont());
                    int lWidth = metrics.stringWidth(nodeView.getLabel().getText());
                    view.setZoom(view.getZoom() * (nWidth / (double)lWidth));
                }
                view.updateView();
                if (!view.equals(Cytoscape.getCurrentNetworkView())) {
                    Cytoscape.firePropertyChange((String)"NETWORK_VIEW_FOCUS", null, (Object)network.getIdentifier());
                }
            }
        }
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setList(String[] listOfTerms) {
        JList tempList = (JList)this.selectedGOTermsScrollPane.getViewport().getView();
        tempList.setListData(listOfTerms);
    }
}

