/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.view.gui;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.util.TaskManager;
import giny.model.Node;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableModel;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.GOSlimmerUtil;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.view.gui.misc.JButtonMod;
import org.ccbr.bader.yeast.view.gui.misc.JLabelMod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGeneSetImportPanel
extends JPanel
implements ActionListener {
    private static final String lsep = System.getProperty("line.separator");
    private GOSlimmerSession session;
    private GridBagConstraints c;
    private JButton importGeneSetButton;
    private static final String importGeneSetButtonText = "Import Gene Set";
    private static final String importGeneSetButtonToolTip = "Import a text file of gene IDs and you'll be able to examine " + lsep + "the degree to which selected GO terms cover your gene set.   " + lsep + "Gene IDs are mapped to GO terms by way of the Gene Annotation" + lsep + "file which you've applied, so the Gene IDs need to match the " + lsep + "gene names used in the annotation file.  Gene IDs must be on " + lsep + "separate lines of the file";
    private File lastImportDir;
    JLabel totalIdsLabel;
    JLabel matchedIdsLabel;
    private Collection<String> unmatchedIds;
    private JLabel unmatchedIdsLabel;
    private static final CyAttributes nodeAtt = Cytoscape.getNodeAttributes();

    public UserGeneSetImportPanel(GOSlimmerSession session) {
        this.initComponents();
        this.session = session;
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("Import User Gene Set"));
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.anchor = 10;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.add((Component)this.getImportGeneSetButton(), this.c);
        this.getUnmatchedIdsLabel();
        this.getMatchedIdsLabel();
    }

    private JButton getImportGeneSetButton() {
        if (this.importGeneSetButton == null) {
            this.importGeneSetButton = new JButtonMod(importGeneSetButtonText);
            this.importGeneSetButton.addActionListener(this);
            this.importGeneSetButton.setToolTipText(importGeneSetButtonToolTip);
        }
        return this.importGeneSetButton;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton bsrc;
        Object src = event.getSource();
        if (src instanceof JButton && (bsrc = (JButton)src).getText().equals(importGeneSetButtonText)) {
            if (this.session.isUserGeneSetImported()) {
                this.removePreviousGeneSet();
                this.session.setUserGeneSetImported(false);
            }
            this.importGeneSet();
            return;
        }
    }

    private void removePreviousGeneSet() {
        for (GOSlimmerController controller : this.session.getNamespaceToController().values()) {
            Iterator nodesI = controller.getNetwork().nodesIterator();
            while (nodesI.hasNext()) {
                Node node = (Node)nodesI.next();
                if (nodeAtt.getMultiHashMapDefinition().getAttributeValueType("GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES") != -1) {
                    nodeAtt.deleteAttribute(node.getIdentifier(), "GOSlimmer.DIRECTLY_ANNOTATED_USER_GENES");
                }
                if (nodeAtt.getMultiHashMapDefinition().getAttributeValueType("GOSlimmer.INFERRED_ANNOTATED_USER_GENES") == -1) continue;
                nodeAtt.deleteAttribute(node.getIdentifier(), "GOSlimmer.INFERRED_ANNOTATED_USER_GENES");
            }
        }
    }

    private void importGeneSet() {
        JFileChooser chooser = this.lastImportDir == null ? new JFileChooser() : new JFileChooser(this.lastImportDir);
        chooser.setFileSelectionMode(0);
        if (this.session.getGaru() == null) {
            JOptionPane.showMessageDialog(this, "No Gene Annotation file has been applied; A gene annotation must first be imported in order to map Gene IDs to GO Terms.", "Error", 0);
            return;
        }
        int retval = chooser.showOpenDialog(this);
        if (retval == 0) {
            final File geneFile = chooser.getSelectedFile();
            this.lastImportDir = geneFile.getParentFile();
            TaskManager.executeTask((Task)new Task(){
                private TaskMonitor taskMonitor = null;

                public String getTitle() {
                    return "Importing Gene ID File and attaching matching Genes to GO Terms";
                }

                public void halt() {
                }

                public void run() {
                    try {
                        Collection geneIds = UserGeneSetImportPanel.this.parseGeneIdFile(geneFile);
                        UserGeneSetImportPanel.this.annotateDAGWithUserGeneSet(geneIds);
                        UserGeneSetImportPanel.this.session.setUserGeneSetImported(true);
                        UserGeneSetImportPanel.this.session.setUserGeneSet(geneIds);
                        UserGeneSetImportPanel.this.session.getGOSlimPanel().setAdvancedUserGeneOptions(true);
                    }
                    catch (FileNotFoundException e) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to import Gene Set;  Could not find specified file", "Error", 0);
                        return;
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to import Gene Set;  Error while reading file", "Error", 0);
                        e.printStackTrace();
                        return;
                    }
                    catch (RuntimeException e) {
                        this.taskMonitor.setException((Throwable)e, e.getMessage());
                        return;
                    }
                }

                public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
                    this.taskMonitor = taskMonitor;
                }
            }, null);
        }
    }

    private Collection<String> parseGeneIdFile(File geneFile) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(geneFile));
        HashSet<String> geneIds = new HashSet<String>();
        String line = null;
        while ((line = in.readLine()) != null) {
            String geneId = this.parseGeneIdLine(line);
            if (geneId == null) continue;
            geneIds.add(geneId);
        }
        return geneIds;
    }

    private String parseGeneIdLine(String line) {
        if (line == null || line.matches("\\s*")) {
            return null;
        }
        if ((line = line.trim()).matches(".*\\s.*")) {
            String errorMessage = "Parse error while processing gene ID file:  cannot have whitespaces within a Gene ID.  Invalid line was: " + line;
            throw new RuntimeException(errorMessage);
        }
        return line;
    }

    private void annotateDAGWithUserGeneSet(Collection<String> geneIds) {
        HashSet<String> matchedIds = new HashSet<String>();
        for (GOSlimmerController controller : this.session.getNamespaceToController().values()) {
            matchedIds.addAll(controller.applyUserGeneSet(geneIds));
        }
        this.unmatchedIds = GOSlimmerUtil.difference(geneIds, matchedIds);
        this.updateTotalUserIdsLabel(geneIds);
        this.updateUnmatchedIdsLabel(this.unmatchedIds);
        this.updateMatchedIdsLabel(matchedIds);
        this.c.anchor = 21;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.add((Component)this.getTotalIdsLabel(), this.c);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.add((Component)this.getMatchedIdsLabel(), this.c);
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.add((Component)this.getUnmatchedIdsLabel(), this.c);
        for (GOSlimmerController controller : this.session.getNamespaceToController().values()) {
            controller.setupUserGeneStatistics(matchedIds.size());
        }
    }

    MouseListener getIdListPopupMouseListener(final String idType, final String popupTitle, final Collection<String> ids) {
        return new MouseListener(){

            public void mouseClicked(MouseEvent arg0) {
                if (ids == null || ids.size() == 0) {
                    return;
                }
                JFrame frame = new JFrame(popupTitle);
                JTable table = new JTable();
                DefaultTableModel model = new DefaultTableModel(ids.size(), 1){

                    public boolean isCellEditable(int arg0, int arg1) {
                        return false;
                    }
                };
                Iterator unmatchedIdI = ids.iterator();
                int i = 0;
                while (unmatchedIdI.hasNext()) {
                    model.setValueAt(unmatchedIdI.next(), i, 0);
                    ++i;
                }
                table.setShowGrid(true);
                table.setModel(model);
                table.getColumnModel().getColumn(0).setHeaderValue(idType);
                JScrollPane spane = new JScrollPane(table);
                JViewport port = new JViewport();
                port.setName(idType);
                spane.setColumnHeader(port);
                frame.getContentPane().add(spane);
                frame.pack();
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }

            public void mouseEntered(MouseEvent arg0) {
            }

            public void mouseExited(MouseEvent arg0) {
            }

            public void mousePressed(MouseEvent arg0) {
            }

            public void mouseReleased(MouseEvent arg0) {
            }
        };
    }

    private JLabel getTotalIdsLabel() {
        if (this.totalIdsLabel == null) {
            this.totalIdsLabel = new JLabel();
        }
        return this.totalIdsLabel;
    }

    public void updateTotalUserIdsLabel(Collection<String> totalIds) {
        for (MouseListener ml : this.getTotalIdsLabel().getMouseListeners()) {
            this.getTotalIdsLabel().removeMouseListener(ml);
        }
        if (totalIds == null || totalIds.size() == 0) {
            this.getTotalIdsLabel().setText("0 User genes;");
        } else {
            this.getTotalIdsLabel().setText(totalIds.size() + " User Genes");
            this.getTotalIdsLabel().setToolTipText("Click for more info");
            this.getTotalIdsLabel().addMouseListener(this.getIdListPopupMouseListener("User Gene IDs", "These are the User Specified Gene IDs which the user attempted to import", totalIds));
        }
    }

    public void updateMatchedIdsLabel(Collection<String> matchedIds) {
        for (MouseListener ml : this.getMatchedIdsLabel().getMouseListeners()) {
            this.getMatchedIdsLabel().removeMouseListener(ml);
        }
        if (matchedIds == null || matchedIds.size() == 0) {
            this.getMatchedIdsLabel().setText("No User Gene IDs could be mapped to GO Terms.");
            this.matchedIdsLabel.setToolTipText("");
        } else {
            this.getMatchedIdsLabel().setText(matchedIds.size() + " Gene IDs were mapped to GO Terms");
            this.matchedIdsLabel.setToolTipText("Click for more info");
            this.matchedIdsLabel.addMouseListener(this.getIdListPopupMouseListener("Matched Gene IDs", "These User Specified Gene IDs were matched to Gene IDs in the Gene Annnotation File", matchedIds));
        }
    }

    public void updateUnmatchedIdsLabel(Collection<String> unmatchedIds) {
        for (MouseListener ml : this.getUnmatchedIdsLabel().getMouseListeners()) {
            this.getUnmatchedIdsLabel().removeMouseListener(ml);
        }
        if (unmatchedIds == null || unmatchedIds.size() == 0) {
            this.getUnmatchedIdsLabel().setText("All User Gene IDs successfully mapped to GO Terms.");
            this.unmatchedIdsLabel.setToolTipText("");
        } else {
            this.getUnmatchedIdsLabel().setText(unmatchedIds.size() + " Gene IDs could not be mapped to GO Terms");
            this.unmatchedIdsLabel.setToolTipText("Click for more info");
            this.unmatchedIdsLabel.addMouseListener(this.getIdListPopupMouseListener("Unmatched Gene IDs", "These User Specified Gene IDs could not be matched to Gene IDs in the Gene Annnotation File", unmatchedIds));
        }
    }

    private JLabel getUnmatchedIdsLabel() {
        if (this.unmatchedIdsLabel == null) {
            this.unmatchedIdsLabel = new JLabelMod("");
        }
        return this.unmatchedIdsLabel;
    }

    private JLabel getMatchedIdsLabel() {
        if (this.matchedIdsLabel == null) {
            this.matchedIdsLabel = new JLabelMod("");
        }
        return this.matchedIdsLabel;
    }
}

