/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class LongOptionWithShort
extends TestCase {
    public LongOptionWithShort(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LongOptionWithShort.class);
    }

    public void testLongOptionWithShort() {
        Option help = new Option("h", "help", false, "print this message");
        Option version = new Option("v", "version", false, "print version information");
        Option newRun = new Option("n", "new", false, "Create NLT cache entries only for new items");
        Option trackerRun = new Option("t", "tracker", false, "Create NLT cache entries only for tracker items");
        OptionBuilder.withLongOpt("limit");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("Set time limit for execution, in mintues");
        Option timeLimit = OptionBuilder.create("l");
        OptionBuilder.withLongOpt("age");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("Age (in days) of cache item before being recomputed");
        Option age = OptionBuilder.create("a");
        OptionBuilder.withLongOpt("server");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("The NLT server address");
        Option server = OptionBuilder.create("s");
        OptionBuilder.withLongOpt("results");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("Number of results per item");
        Option numResults = OptionBuilder.create("r");
        OptionBuilder.withLongOpt("file");
        OptionBuilder.hasArg();
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("Use the specified configuration file");
        Option configFile = OptionBuilder.create();
        Options options = new Options();
        options.addOption(help);
        options.addOption(version);
        options.addOption(newRun);
        options.addOption(trackerRun);
        options.addOption(timeLimit);
        options.addOption(age);
        options.addOption(server);
        options.addOption(numResults);
        options.addOption(configFile);
        PosixParser parser = new PosixParser();
        String[] args = new String[]{"-v", "-l", "10", "-age", "5", "-file", "filename"};
        try {
            CommandLine line = parser.parse(options, args);
            LongOptionWithShort.assertTrue((boolean)line.hasOption("v"));
            LongOptionWithShort.assertEquals((String)line.getOptionValue("l"), (String)"10");
            LongOptionWithShort.assertEquals((String)line.getOptionValue("limit"), (String)"10");
            LongOptionWithShort.assertEquals((String)line.getOptionValue("a"), (String)"5");
            LongOptionWithShort.assertEquals((String)line.getOptionValue("age"), (String)"5");
            LongOptionWithShort.assertEquals((String)line.getOptionValue("file"), (String)"filename");
        }
        catch (ParseException exp) {
            LongOptionWithShort.fail((String)("Unexpected exception:" + exp.getMessage()));
        }
    }
}

