/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.avalon;

import java.util.Vector;
import junit.framework.TestCase;
import org.apache.commons.cli.avalon.AbstractParserControl;
import org.apache.commons.cli.avalon.CLArgsParser;
import org.apache.commons.cli.avalon.CLOption;
import org.apache.commons.cli.avalon.CLOptionDescriptor;
import org.apache.commons.cli.avalon.CLUtil;

public final class ClutilTestCase
extends TestCase {
    private static final String[] ARGLIST1 = new String[]{"--you", "are", "--all", "-cler", "kid"};
    private static final String[] ARGLIST2 = new String[]{"-Dstupid=idiot", "are", "--all", "here", "-d"};
    private static final String[] ARGLIST3 = new String[]{"-Dstupid=idiot", "are", "--all", "--all", "here"};
    private static final String[] ARGLIST4 = new String[]{"-Dstupid", "idiot", "are", "--all", "--blee", "here"};
    private static final String[] ARGLIST5 = new String[]{"-f", "myfile.txt"};
    private static final int DEFINE_OPT = 68;
    private static final int CASE_CHECK_OPT = 100;
    private static final int YOU_OPT = 121;
    private static final int ALL_OPT = 97;
    private static final int CLEAR1_OPT = 99;
    private static final int CLEAR2_OPT = 108;
    private static final int CLEAR3_OPT = 101;
    private static final int CLEAR5_OPT = 114;
    private static final int BLEE_OPT = 98;
    private static final int FILE_OPT = 102;
    private static final int TAINT_OPT = 84;
    private static final CLOptionDescriptor DEFINE = new CLOptionDescriptor("define", 16, 68, "define");
    private static final CLOptionDescriptor DEFINE_MANY = new CLOptionDescriptor("define", 48, 68, "define");
    private static final CLOptionDescriptor CASE_CHECK = new CLOptionDescriptor("charCheck", 8, 100, "check character case sensitivity");
    private static final CLOptionDescriptor YOU = new CLOptionDescriptor("you", 8, 121, "you");
    private static final CLOptionDescriptor CLEAR1 = new CLOptionDescriptor("c", 8, 99, "c");
    private static final CLOptionDescriptor CLEAR2 = new CLOptionDescriptor("l", 8, 108, "l");
    private static final CLOptionDescriptor CLEAR3 = new CLOptionDescriptor("e", 8, 101, "e");
    private static final CLOptionDescriptor CLEAR5 = new CLOptionDescriptor("r", 8, 114, "r");
    private static final CLOptionDescriptor BLEE = new CLOptionDescriptor("blee", 8, 98, "blee");
    private static final CLOptionDescriptor ALL = new CLOptionDescriptor("all", 8, 97, "all", new CLOptionDescriptor[]{BLEE});
    private static final CLOptionDescriptor FILE = new CLOptionDescriptor("file", 2, 102, "the build file.");
    private static final CLOptionDescriptor TAINT = new CLOptionDescriptor("taint", 4, 84, "turn on tainting checks (optional level).");

    public ClutilTestCase() {
        this("Command Line Interpreter Test Case");
    }

    public ClutilTestCase(String name) {
        super(name);
    }

    public void testOptionalArgWithSpace() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{ALL, TAINT};
        String[] args = new String[]{"-T", "param", "-a"};
        CLArgsParser parser = new CLArgsParser(args, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((String)"Option count", (int)3, (int)size);
        CLOption option0 = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((String)("Option Code: " + option0.getDescriptor().getId()), (int)84, (int)option0.getDescriptor().getId());
        ClutilTestCase.assertEquals((String)("Option Arg: " + option0.getArgument(0)), null, (String)option0.getArgument(0));
        CLOption option1 = (CLOption)clOptions.get(1);
        ClutilTestCase.assertEquals((int)option1.getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((String)option1.getArgument(0), (String)"param");
        CLOption option2 = (CLOption)clOptions.get(2);
        ClutilTestCase.assertEquals((int)option2.getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((String)option2.getArgument(0), null);
    }

    public void testOptionalArgLong() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{ALL, TAINT};
        String[] args = new String[]{"--taint", "param", "-a"};
        CLArgsParser parser = new CLArgsParser(args, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((String)"Option count", (int)3, (int)size);
        CLOption option0 = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((String)("Option Code: " + option0.getDescriptor().getId()), (int)84, (int)option0.getDescriptor().getId());
        ClutilTestCase.assertEquals((String)("Option Arg: " + option0.getArgument(0)), null, (String)option0.getArgument(0));
        CLOption option1 = (CLOption)clOptions.get(1);
        ClutilTestCase.assertEquals((int)0, (int)option1.getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"param", (String)option1.getArgument(0));
        CLOption option2 = (CLOption)clOptions.get(2);
        ClutilTestCase.assertEquals((int)option2.getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((String)option2.getArgument(0), null);
    }

    public void testShortOptArgUnenteredBeforeOtherOpt() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{ALL, TAINT};
        String[] args = new String[]{"-T", "-a"};
        CLArgsParser parser = new CLArgsParser(args, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((String)"Option count", (int)2, (int)size);
        CLOption option0 = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((String)("Option Code: " + option0.getDescriptor().getId()), (int)84, (int)option0.getDescriptor().getId());
        ClutilTestCase.assertEquals((String)("Option Arg: " + option0.getArgument(0)), null, (String)option0.getArgument(0));
        CLOption option1 = (CLOption)clOptions.get(1);
        ClutilTestCase.assertEquals((int)option1.getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((String)option1.getArgument(0), null);
    }

    public void testOptionalArgsWithArgShortBeforeOtherOpt() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{ALL, TAINT};
        String[] args = new String[]{"-T3", "-a"};
        CLArgsParser parser = new CLArgsParser(args, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)2);
        CLOption option0 = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((int)option0.getDescriptor().getId(), (int)84);
        ClutilTestCase.assertEquals((String)option0.getArgument(0), (String)"3");
        CLOption option1 = (CLOption)clOptions.get(1);
        ClutilTestCase.assertEquals((int)97, (int)option1.getDescriptor().getId());
        ClutilTestCase.assertEquals(null, (String)option1.getArgument(0));
    }

    public void testOptionalArgsNoArgShortBeforeOtherOpt() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{ALL, TAINT};
        String[] args = new String[]{"-T", "-a"};
        CLArgsParser parser = new CLArgsParser(args, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)2);
        CLOption option0 = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((int)84, (int)option0.getDescriptor().getId());
        ClutilTestCase.assertEquals(null, (String)option0.getArgument(0));
        CLOption option1 = (CLOption)clOptions.get(1);
        ClutilTestCase.assertEquals((int)97, (int)option1.getDescriptor().getId());
        ClutilTestCase.assertEquals(null, (String)option1.getArgument(0));
    }

    public void testFullParse() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{YOU, ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        CLArgsParser parser = new CLArgsParser(ARGLIST1, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)8);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(0)).getDescriptor().getId(), (int)121);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(1)).getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(2)).getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(3)).getDescriptor().getId(), (int)99);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(4)).getDescriptor().getId(), (int)108);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(5)).getDescriptor().getId(), (int)101);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(6)).getDescriptor().getId(), (int)114);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(7)).getDescriptor().getId(), (int)0);
    }

    public void testDuplicateOptions() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1};
        CLArgsParser parser = new CLArgsParser(ARGLIST3, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)5);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(0)).getDescriptor().getId(), (int)68);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(1)).getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(2)).getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(3)).getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(4)).getDescriptor().getId(), (int)0);
    }

    public void testIncompatableOptions() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1, BLEE};
        CLArgsParser parser = new CLArgsParser(ARGLIST4, options);
        ClutilTestCase.assertNotNull((Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)5);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(0)).getDescriptor().getId(), (int)68);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(1)).getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(2)).getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(3)).getDescriptor().getId(), (int)98);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(4)).getDescriptor().getId(), (int)0);
    }

    public void testSingleArg() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(ARGLIST5, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)1);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(0)).getDescriptor().getId(), (int)102);
        ClutilTestCase.assertEquals((String)((CLOption)clOptions.get(0)).getArgument(), (String)"myfile.txt");
    }

    public void testSingleArg2() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-f-=,=-"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"-=,=-", (String)((CLOption)clOptions.get(0)).getArgument());
    }

    public void testSingleArg3() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"--file=-=,-"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"-=,-", (String)((CLOption)clOptions.get(0)).getArgument());
    }

    public void testSingleArg4() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"--file", "myfile.txt"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"myfile.txt", (String)((CLOption)clOptions.get(0)).getArgument());
    }

    public void testSingleArg5() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-f", "myfile.txt"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"myfile.txt", (String)((CLOption)clOptions.get(0)).getArgument());
    }

    public void testSingleArg6() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-f", "-=-"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"-=-", (String)((CLOption)clOptions.get(0)).getArgument());
    }

    public void testSingleArg7() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"--file=-=-"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"-=-", (String)((CLOption)clOptions.get(0)).getArgument());
    }

    public void testSingleArg8() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"--file", "-=-"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"-=-", (String)((CLOption)clOptions.get(0)).getArgument());
    }

    public void testSingleArg9() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"--file", "-=-"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"-=-", (String)((CLOption)clOptions.get(0)).getArgument());
    }

    public void testCombinedArgs1() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{BLEE, TAINT};
        CLArgsParser parser = new CLArgsParser(new String[]{"-bT", "rest"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)3, (int)size);
        ClutilTestCase.assertEquals((int)98, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((int)84, (int)((CLOption)clOptions.get(1)).getDescriptor().getId());
        ClutilTestCase.assertEquals((int)0, (int)((CLOption)clOptions.get(2)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"rest", (String)((CLOption)clOptions.get(2)).getArgument());
    }

    public void testCombinedArgs2() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{BLEE, TAINT, FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-bT", "-fa"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)3, (int)size);
        ClutilTestCase.assertEquals((int)98, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((int)84, (int)((CLOption)clOptions.get(1)).getDescriptor().getId());
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(2)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"a", (String)((CLOption)clOptions.get(2)).getArgument());
    }

    public void testCombinedArgs3() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{BLEE, TAINT, FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-bT", "--", "-fa"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)3, (int)size);
        ClutilTestCase.assertEquals((int)98, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((int)84, (int)((CLOption)clOptions.get(1)).getDescriptor().getId());
        ClutilTestCase.assertEquals((int)0, (int)((CLOption)clOptions.get(2)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"-fa", (String)((CLOption)clOptions.get(2)).getArgument());
    }

    public void testCombinedArgs4() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{BLEE, TAINT, FILE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-bT", "rest", "-fa"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)4, (int)size);
        ClutilTestCase.assertEquals((int)98, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        ClutilTestCase.assertEquals((int)84, (int)((CLOption)clOptions.get(1)).getDescriptor().getId());
        ClutilTestCase.assertEquals((int)0, (int)((CLOption)clOptions.get(2)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"rest", (String)((CLOption)clOptions.get(2)).getArgument());
        ClutilTestCase.assertEquals((int)102, (int)((CLOption)clOptions.get(3)).getDescriptor().getId());
        ClutilTestCase.assertEquals((String)"a", (String)((CLOption)clOptions.get(3)).getArgument());
    }

    public void test2ArgsParse() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, ALL, CLEAR1, CASE_CHECK};
        CLArgsParser parser = new CLArgsParser(ARGLIST2, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)5);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(0)).getDescriptor().getId(), (int)68);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(1)).getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(2)).getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(3)).getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(4)).getDescriptor().getId(), (int)100);
        CLOption option = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((String)"stupid", (String)option.getArgument(0));
        ClutilTestCase.assertEquals((String)"idiot", (String)option.getArgument(1));
    }

    public void test2ArgsParse2() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE};
        CLArgsParser parser = new CLArgsParser(new String[]{"--define", "a-b,c=d-e,f"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)68, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        CLOption option = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((String)"a-b,c", (String)option.getArgument(0));
        ClutilTestCase.assertEquals((String)"d-e,f", (String)option.getArgument(1));
    }

    public void test2ArgsParse3() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-D", "A-b,c", "G-e,f"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)1, (int)size);
        ClutilTestCase.assertEquals((int)68, (int)((CLOption)clOptions.get(0)).getDescriptor().getId());
        CLOption option = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((String)"A-b,c", (String)option.getArgument(0));
        ClutilTestCase.assertEquals((String)"G-e,f", (String)option.getArgument(1));
    }

    public void test2ArgsParse4() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE_MANY};
        CLArgsParser parser = new CLArgsParser(new String[]{"-Dval1=-1", "-D", "val2=-2", "--define=val-3=-3", "--define", "val4-=-4"}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)4, (int)size);
        for (int i = 0; i < size; ++i) {
            ClutilTestCase.assertEquals((int)68, (int)((CLOption)clOptions.get(i)).getDescriptor().getId());
        }
        CLOption option = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((String)"val1", (String)option.getArgument(0));
        ClutilTestCase.assertEquals((String)"-1", (String)option.getArgument(1));
        option = (CLOption)clOptions.get(1);
        ClutilTestCase.assertEquals((String)"val2", (String)option.getArgument(0));
        ClutilTestCase.assertEquals((String)"-2", (String)option.getArgument(1));
        option = (CLOption)clOptions.get(2);
        ClutilTestCase.assertEquals((String)"val-3", (String)option.getArgument(0));
        ClutilTestCase.assertEquals((String)"-3", (String)option.getArgument(1));
        option = (CLOption)clOptions.get(3);
        ClutilTestCase.assertEquals((String)"val4-", (String)option.getArgument(0));
        ClutilTestCase.assertEquals((String)"-4", (String)option.getArgument(1));
    }

    public void testPartParse() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{YOU};
        AbstractParserControl control = new AbstractParserControl(){

            public boolean isFinished(int lastOptionCode) {
                return lastOptionCode == 121;
            }
        };
        CLArgsParser parser = new CLArgsParser(ARGLIST1, options, control);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)1);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(0)).getDescriptor().getId(), (int)121);
    }

    public void test2PartParse() {
        CLOptionDescriptor[] options1 = new CLOptionDescriptor[]{YOU};
        CLOptionDescriptor[] options2 = new CLOptionDescriptor[]{ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        AbstractParserControl control1 = new AbstractParserControl(){

            public boolean isFinished(int lastOptionCode) {
                return lastOptionCode == 121;
            }
        };
        CLArgsParser parser1 = new CLArgsParser(ARGLIST1, options1, control1);
        ClutilTestCase.assertNull((String)parser1.getErrorString(), (Object)parser1.getErrorString());
        Vector clOptions1 = parser1.getArguments();
        int size1 = clOptions1.size();
        ClutilTestCase.assertEquals((int)size1, (int)1);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions1.get(0)).getDescriptor().getId(), (int)121);
        CLArgsParser parser2 = new CLArgsParser(parser1.getUnparsedArgs(), options2);
        ClutilTestCase.assertNull((String)parser2.getErrorString(), (Object)parser2.getErrorString());
        Vector clOptions2 = parser2.getArguments();
        int size2 = clOptions2.size();
        ClutilTestCase.assertEquals((int)size2, (int)7);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(0)).getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(1)).getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(2)).getDescriptor().getId(), (int)99);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(3)).getDescriptor().getId(), (int)108);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(4)).getDescriptor().getId(), (int)101);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(5)).getDescriptor().getId(), (int)114);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(6)).getDescriptor().getId(), (int)0);
    }

    public void test2PartPartialParse() {
        CLOptionDescriptor[] options1 = new CLOptionDescriptor[]{YOU, ALL, CLEAR1};
        CLOptionDescriptor[] options2 = new CLOptionDescriptor[]{};
        AbstractParserControl control1 = new AbstractParserControl(){

            public boolean isFinished(int lastOptionCode) {
                return lastOptionCode == 99;
            }
        };
        CLArgsParser parser1 = new CLArgsParser(ARGLIST1, options1, control1);
        ClutilTestCase.assertNull((String)parser1.getErrorString(), (Object)parser1.getErrorString());
        Vector clOptions1 = parser1.getArguments();
        int size1 = clOptions1.size();
        ClutilTestCase.assertEquals((int)size1, (int)4);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions1.get(0)).getDescriptor().getId(), (int)121);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions1.get(1)).getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions1.get(2)).getDescriptor().getId(), (int)97);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions1.get(3)).getDescriptor().getId(), (int)99);
        ClutilTestCase.assertTrue((boolean)parser1.getUnparsedArgs()[0].equals("ler"));
        CLArgsParser parser2 = new CLArgsParser(parser1.getUnparsedArgs(), options2);
        ClutilTestCase.assertNull((String)parser2.getErrorString(), (Object)parser2.getErrorString());
        Vector clOptions2 = parser2.getArguments();
        int size2 = clOptions2.size();
        ClutilTestCase.assertEquals((int)size2, (int)2);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(0)).getDescriptor().getId(), (int)0);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions2.get(1)).getDescriptor().getId(), (int)0);
    }

    public void testDuplicatesFail() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{YOU, ALL, CLEAR1, CLEAR2, CLEAR3, CLEAR5};
        CLArgsParser parser = new CLArgsParser(ARGLIST1, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
    }

    public void testIncomplete2Args() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE};
        CLArgsParser parser = new CLArgsParser(new String[]{"-Dstupid="}, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)1);
        CLOption option = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((int)option.getDescriptor().getId(), (int)68);
        ClutilTestCase.assertEquals((String)option.getArgument(0), (String)"stupid");
        ClutilTestCase.assertEquals((String)option.getArgument(1), (String)"");
    }

    public void testIncomplete2ArgsMixed() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, CLEAR1};
        String[] args = new String[]{"-Dstupid=", "-c"};
        CLArgsParser parser = new CLArgsParser(args, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)2);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(1)).getDescriptor().getId(), (int)99);
        CLOption option = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((int)option.getDescriptor().getId(), (int)68);
        ClutilTestCase.assertEquals((String)option.getArgument(0), (String)"stupid");
        ClutilTestCase.assertEquals((String)option.getArgument(1), (String)"");
    }

    public void testIncomplete2ArgsMixedNoEq() {
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{DEFINE, CLEAR1};
        String[] args = new String[]{"-DStupid", "-c"};
        CLArgsParser parser = new CLArgsParser(args, options);
        ClutilTestCase.assertNull((String)parser.getErrorString(), (Object)parser.getErrorString());
        Vector clOptions = parser.getArguments();
        int size = clOptions.size();
        ClutilTestCase.assertEquals((int)size, (int)2);
        ClutilTestCase.assertEquals((int)((CLOption)clOptions.get(1)).getDescriptor().getId(), (int)99);
        CLOption option = (CLOption)clOptions.get(0);
        ClutilTestCase.assertEquals((int)option.getDescriptor().getId(), (int)68);
        ClutilTestCase.assertEquals((String)option.getArgument(0), (String)"Stupid");
        ClutilTestCase.assertEquals((String)option.getArgument(1), (String)"");
    }

    public void testArgumentLookup() {
        String[] args = new String[]{"-f", "testarg"};
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{FILE};
        CLArgsParser parser = new CLArgsParser(args, options);
        CLOption optionById = parser.getArgumentById(102);
        ClutilTestCase.assertNotNull((Object)optionById);
        ClutilTestCase.assertEquals((int)102, (int)optionById.getDescriptor().getId());
        CLOption optionByName = parser.getArgumentByName(FILE.getName());
        ClutilTestCase.assertNotNull((Object)optionByName);
        ClutilTestCase.assertEquals((int)102, (int)optionByName.getDescriptor().getId());
    }

    public void testNullLongForm() {
        CLOptionDescriptor test = new CLOptionDescriptor(null, 8, 110, "test null long form");
        String[] args = new String[]{"-n", "testarg"};
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{test};
        CLArgsParser parser = new CLArgsParser(args, options);
        CLOption optionByID = parser.getArgumentById(110);
        ClutilTestCase.assertNotNull((Object)optionByID);
        ClutilTestCase.assertEquals((int)110, (int)optionByID.getDescriptor().getId());
        CLOption optionByName = parser.getArgumentByName(FILE.getName());
        ClutilTestCase.assertNull((String)"Looking for non-existent option by name", (Object)optionByName);
    }

    public void testNullDescription() {
        CLOptionDescriptor test = new CLOptionDescriptor("nulltest", 8, 110, null);
        String[] args = new String[]{"-n", "testarg"};
        CLOptionDescriptor[] options = new CLOptionDescriptor[]{test};
        CLArgsParser parser = new CLArgsParser(args, options);
        CLOption optionByID = parser.getArgumentById(110);
        ClutilTestCase.assertNotNull((Object)optionByID);
        ClutilTestCase.assertEquals((int)110, (int)optionByID.getDescriptor().getId());
        StringBuffer sb = CLUtil.describeOptions(options);
        String lineSeparator = System.getProperty("line.separator");
        ClutilTestCase.assertEquals((String)"Testing display of null description", (String)("\t-n, --nulltest" + lineSeparator), (String)sb.toString());
    }
}

