/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast;

import cytoscape.Cytoscape;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ccbr.bader.yeast.GONamespace;
import org.ccbr.bader.yeast.GOSlimmerControlPanelToGraphInterface;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.model.GOSlimmerCoverageStatBean;
import org.ccbr.bader.yeast.view.gui.AdvancedViewSettingsPanel;
import org.ccbr.bader.yeast.view.gui.AutomaticGOSetGeneratorPanel;
import org.ccbr.bader.yeast.view.gui.FileExportPanel;
import org.ccbr.bader.yeast.view.gui.GOSlimmerGeneAssociationDialog;
import org.ccbr.bader.yeast.view.gui.SelectedGOTermsPanel;
import org.ccbr.bader.yeast.view.gui.UserGeneSetImportPanel;
import org.ccbr.bader.yeast.view.gui.misc.JCollapsablePanel;
import org.ccbr.bader.yeast.view.gui.misc.JLabelMod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOSlimPanel
extends JPanel {
    protected AdvancedViewSettingsPanel viewSettingsPanel;
    private FileExportPanel fileExportPanel;
    private GOSlimmerControlPanelToGraphInterface cptgi = null;
    private AutomaticGOSetGeneratorPanel generatorPanel;
    private GOSlimmerSession session;
    private UserGeneSetImportPanel userGeneSetImportPanel;
    private Map<GONamespace, GOSlimmerNamespaceSubpanel> namespaceToSubpanel = new HashMap<GONamespace, GOSlimmerNamespaceSubpanel>();
    private Map<GONamespace, GOSlimmerController> namespaceToController = new HashMap<GONamespace, GOSlimmerController>();

    public GOSlimPanel(Map<GONamespace, GOSlimmerController> namespaceToController, GOSlimmerSession session) {
        this.session = session;
        super.setName("GOSlimmer");
        this.setLayout(new BoxLayout(this, 1));
        this.add(new GOSlimmerGeneAssociationDialog(session.getNamespaceToController(), session.getOntologyName(), session));
        this.add(this.getUserGeneSetImportPanel());
        for (GONamespace namespace : namespaceToController.keySet()) {
            GOSlimmerController controller = namespaceToController.get((Object)namespace);
            GOSlimmerNamespaceSubpanel namespaceSubPanel = new GOSlimmerNamespaceSubpanel(namespace.getName(), controller);
            namespaceSubPanel.setCollapsed(false);
            this.namespaceToSubpanel.put(namespace, namespaceSubPanel);
            controller.setInferredCoverageStatisticViewLabel(namespaceSubPanel.inferredCoverageStatisticLabel);
            controller.setDirectCoverageStatisticViewLabel(namespaceSubPanel.directCoverageStatisticLabel);
            controller.setSelectedGOTermsPanel(namespaceSubPanel.selectedGOTermsPanel);
            this.add(namespaceSubPanel);
        }
        this.namespaceToController = namespaceToController;
        this.viewSettingsPanel = new AdvancedViewSettingsPanel(session.getNamespaceToController().values());
        this.add(this.viewSettingsPanel);
        this.add(this.getFileExportPanel());
        this.generatorPanel = new AutomaticGOSetGeneratorPanel(session);
        this.add(this.generatorPanel);
        session.setGOSlimPanel(this);
    }

    private FileExportPanel getFileExportPanel() {
        if (this.fileExportPanel == null) {
            this.fileExportPanel = new FileExportPanel(this.session.getNamespaceToController().values(), this.session);
        }
        return this.fileExportPanel;
    }

    public UserGeneSetImportPanel getUserGeneSetImportPanel() {
        if (this.userGeneSetImportPanel == null) {
            this.userGeneSetImportPanel = new UserGeneSetImportPanel(this.session);
        }
        return this.userGeneSetImportPanel;
    }

    public JLabel getBioProCoverage() {
        return this.getCoverage(GONamespace.BioPro);
    }

    public void setBioProCoverage(JLabel coverage) {
        this.setCoverageLabel(GONamespace.BioPro, coverage);
    }

    public JLabel getCelComCoverage() {
        return this.getCoverage(GONamespace.CelCom);
    }

    public void setCelComCoverage(JLabel coverage) {
        this.setCoverageLabel(GONamespace.CelCom, coverage);
    }

    public JLabel getMolFunCoverage() {
        return this.getCoverage(GONamespace.MolFun);
    }

    public void setMolFunCoverage(JLabel coverage) {
        this.setCoverageLabel(GONamespace.MolFun, coverage);
    }

    private JLabel getCoverage(GONamespace ns) {
        return this.namespaceToSubpanel.get((Object)ns).getInferredCoverageStatisticLabel();
    }

    private void setCoverageLabel(GONamespace ns, JLabel coverage) {
        this.namespaceToSubpanel.get((Object)ns).setInferredCoverageStatisticLabel(coverage);
    }

    public void setNamespaceSubpanelsVisible(boolean visible) {
        for (GOSlimmerNamespaceSubpanel nsp : this.namespaceToSubpanel.values()) {
            nsp.setVisible(visible);
        }
    }

    public void setViewSettingsPanelVisible(boolean visible) {
        this.viewSettingsPanel.setVisible(visible);
    }

    public void setUserGeneSetImportPanelVisible(boolean visible) {
        this.getUserGeneSetImportPanel().setVisible(visible);
    }

    public void setFileExportPanelVisible(boolean visible) {
        this.fileExportPanel.setVisible(visible);
    }

    public void setAutomaticGOSetGeneratorPanelVisible(boolean visible) {
        this.generatorPanel.setVisible(visible);
    }

    public void setAdvancedUserGeneOptions(boolean enableAdvancedUserGeneOptions) {
        this.viewSettingsPanel.setUserGeneOptions(enableAdvancedUserGeneOptions);
    }

    private class GOSlimmerNamespaceSubpanel
    extends JCollapsablePanel {
        GOSlimmerCoverageStatBean statBean;
        JLabel inferredCoverageStatisticLabel;
        JLabel directCoverageStatisticLabel;
        SelectedGOTermsPanel selectedGOTermsPanel;
        private final String lsep;
        String inferredCoverageStatisticLabelToolTip;
        String directCoverageStatisticLabelToolTip;
        String selectedGOTermsPanelToolTip;
        private NumberFormat numFormatter;

        public GOSlimmerNamespaceSubpanel(String name, final GOSlimmerController controller) {
            super(name);
            this.statBean = null;
            this.lsep = System.getProperty("line.separator");
            this.inferredCoverageStatisticLabelToolTip = "The percentage of gene annotation file genes covered directly " + this.lsep + "by the GO terms selected for inclusion in the slim set, as " + this.lsep + "well as those genes annotated by descendant terms within this " + this.lsep + "tree(whether expanded or collapsed)";
            this.directCoverageStatisticLabelToolTip = "The percentage of gene annotation file genes covered directly " + this.lsep + "by the GO terms explicitely selected for inclusion in the slim set";
            this.selectedGOTermsPanelToolTip = "The list of selected GO terms for this tree";
            this.numFormatter = new DecimalFormat("00.00%");
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.anchor = 23;
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            this.statBean = controller.getStatBean();
            this.inferredCoverageStatisticLabel = new JLabelMod("Inferred Coverage: " + this.numFormatter.format(this.statBean.fractionInferredCovered()));
            this.inferredCoverageStatisticLabel.setToolTipText(this.inferredCoverageStatisticLabelToolTip);
            this.add((Component)this.inferredCoverageStatisticLabel, c);
            c.gridx = 0;
            c.gridy = 1;
            c.fill = 2;
            this.directCoverageStatisticLabel = new JLabelMod("Direct Coverage: " + this.numFormatter.format(this.statBean.fractionDirectlyCovered()));
            this.directCoverageStatisticLabel.setToolTipText(this.directCoverageStatisticLabelToolTip);
            this.add((Component)this.directCoverageStatisticLabel, c);
            c.gridx = 0;
            c.gridy = 2;
            c.fill = 2;
            c.gridwidth = 0;
            this.selectedGOTermsPanel = new SelectedGOTermsPanel(controller);
            this.selectedGOTermsPanel.setToolTipText(this.selectedGOTermsPanelToolTip);
            this.selectedGOTermsPanel.setCollapsed(true);
            this.add((Component)this.selectedGOTermsPanel, c);
            MouseListener changeFocusMouseListener = new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                    Cytoscape.firePropertyChange((String)"NETWORK_VIEW_FOCUS", null, (Object)controller.getNetwork().getIdentifier());
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }
            };
            this.addMouseListener(changeFocusMouseListener);
            this.directCoverageStatisticLabel.addMouseListener(changeFocusMouseListener);
            this.inferredCoverageStatisticLabel.addMouseListener(changeFocusMouseListener);
        }

        public JLabel getInferredCoverageStatisticLabel() {
            return this.inferredCoverageStatisticLabel;
        }

        public void setInferredCoverageStatisticLabel(JLabel coverageStatisticLabel) {
            this.inferredCoverageStatisticLabel = coverageStatisticLabel;
        }

        protected JLabel getDirectCoverageStatisticLabel() {
            return this.directCoverageStatisticLabel;
        }

        protected void setDirectCoverageStatisticLabel(JLabel directCoverageStatisticLabel) {
            this.directCoverageStatisticLabel = directCoverageStatisticLabel;
        }
    }
}

