/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelState;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.ccbr.bader.yeast.GOSlimPanel;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.GOSlimmerUndo;
import org.ccbr.bader.yeast.GOSlimmerUtil;
import org.ccbr.bader.yeast.GOSlimmerVisualStyle;

public class GOSlimPanelAction
implements ActionListener {
    boolean alreadyOpened = false;
    GOSlimmerUndo undo = new GOSlimmerUndo();
    private int undoLimit = 15;
    private int prevUndoLimit;
    private static final String lsep = System.getProperty("line.separator");
    private JPanel goSlimmerSessionsTabbedPane;

    public void actionPerformed(ActionEvent event) {
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(7);
        if (event.getSource() instanceof JMenuItem) {
            JMenuItem src = (JMenuItem)event.getSource();
            if (src.getText().equals("Exit GOSlimmer")) {
                cytoPanel.remove((Component)this.goSlimmerSessionsTabbedPane);
                this.goSlimmerSessionsTabbedPane = null;
                GOSlimmerUtil.deleteGOSlimmerAttributes();
                this.alreadyOpened = false;
                this.undo.setLimit(this.prevUndoLimit);
            } else if (src.getText().equals("Start GOSlimmer")) {
                CyNetwork currentNetwork;
                if (this.alreadyOpened) {
                    JOptionPane.showMessageDialog((Component)desktop, "GOSlimmer cannot be used to edit more than one GO Tree at a time." + lsep + "To edit a new graph, select to close GOSlimmer from Pluggins->GOSlimmer and then start " + lsep + "on the new GO Tree you wish to edit.");
                    return;
                }
                this.prevUndoLimit = this.undo.getLimit();
                this.undo.setLimit(this.undoLimit);
                VisualMappingManager vmm = Cytoscape.getVisualMappingManager();
                if (!vmm.getCalculatorCatalog().getVisualStyleNames().contains("GOSLIMMERVS")) {
                    vmm.getCalculatorCatalog().addVisualStyle((VisualStyle)new GOSlimmerVisualStyle(vmm.getVisualStyle(), "GOSLIMMERVS"));
                }
                if ((currentNetwork = Cytoscape.getCurrentNetwork()) == null) {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Cannot start GOSlimmer without a GO Tree Network.  Please load a GO Ontology Tree, selected it as the current network, and then start GOSlimmer", "Error - cannot start GOSlimmer", 0);
                    return;
                }
                if (!GOSlimmerUtil.isOntology(currentNetwork.getTitle())) {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Cannot start GOSlimmer without a Gene Ontology Tree Network." + lsep + "Network name '" + currentNetwork.getTitle() + "' does not match the name of a loaded Gene Ontology." + lsep + "Please load a GO Tree through the \"File->Import->Ontology and Annotation\" dialog," + lsep + "selected it as the current network, and then start GOSlimmer", "Error - cannot start GOSlimmer", 0);
                    return;
                }
                GOSlimmerSession newSession = new GOSlimmerSession(currentNetwork);
                GOSlimPanel newSessionPanel = new GOSlimPanel(newSession.getNamespaceToController(), newSession);
                newSessionPanel.setNamespaceSubpanelsVisible(false);
                newSessionPanel.setViewSettingsPanelVisible(false);
                newSessionPanel.setFileExportPanelVisible(false);
                newSessionPanel.setUserGeneSetImportPanelVisible(false);
                newSessionPanel.setAutomaticGOSetGeneratorPanelVisible(false);
                if (!this.alreadyOpened) {
                    JPanel layoutPanel;
                    this.goSlimmerSessionsTabbedPane = newSessionPanel;
                    this.goSlimmerSessionsTabbedPane = layoutPanel = new JPanel();
                    this.goSlimmerSessionsTabbedPane.add(newSessionPanel);
                    this.goSlimmerSessionsTabbedPane.add(new JPanel());
                    cytoPanel.add("GOSlimmer", (Component)this.goSlimmerSessionsTabbedPane);
                    this.alreadyOpened = true;
                }
                int index = cytoPanel.indexOfComponent((Component)this.goSlimmerSessionsTabbedPane);
                cytoPanel.setSelectedIndex(index);
                cytoPanel.setState(CytoPanelState.DOCK);
            }
        }
    }
}

