/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.export;

import cytoscape.CyNetwork;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.ccbr.bader.yeast.GOSlimmerException;
import org.ccbr.bader.yeast.GOSlimmerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneAnnotationRemapWriter {
    private static final int GOID = 4;
    BufferedWriter w = null;
    Map<String, Set<String>> goTermRemap;
    private static final String lsep = System.getProperty("line.separator");

    public GeneAnnotationRemapWriter(BufferedWriter writer, CyNetwork GODAG) throws GOSlimmerException {
        this.w = writer;
        this.goTermRemap = GOSlimmerUtil.createGoTermMultipleRemap(GODAG);
    }

    public GeneAnnotationRemapWriter(BufferedWriter writer, Map<String, Set<String>> goTermRemap) {
        this.w = writer;
        this.goTermRemap = goTermRemap;
    }

    public void write(String s) throws IOException {
        this.w.write(s);
    }

    public void writeRemappedEntry(String[] annotationEntry) throws IOException {
        String originalGoTerm = annotationEntry[4];
        Set<String> remappedGoTerms = this.goTermRemap.get(originalGoTerm);
        if (remappedGoTerms == null) {
            throw new RuntimeException("GO Term '" + originalGoTerm + "' does not have a term remapping mapping");
        }
        for (String remappedGoTerm : remappedGoTerms) {
            for (int i = 0; i < annotationEntry.length; ++i) {
                if (i != 4) {
                    this.w.write(annotationEntry[i]);
                } else {
                    this.w.write(remappedGoTerm);
                }
                this.w.write("\t");
            }
            this.w.write(lsep);
        }
    }
}

