/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.view.gui;

import cytoscape.Cytoscape;
import cytoscape.bookmarks.Bookmarks;
import cytoscape.bookmarks.DataSource;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.util.TaskManager;
import cytoscape.util.BookmarksUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.bind.JAXBException;
import org.ccbr.bader.geneassociation.GeneAssociationReaderUtil;
import org.ccbr.bader.yeast.GONamespace;
import org.ccbr.bader.yeast.GOSlimPanel;
import org.ccbr.bader.yeast.GOSlimmerSession;
import org.ccbr.bader.yeast.GOSlimmerUtil;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.export.GOFormatException;
import org.ccbr.bader.yeast.view.gui.UserGeneSetImportPanel;
import org.ccbr.bader.yeast.view.gui.misc.JCollapsablePanel;
import org.ccbr.bader.yeast.view.gui.misc.JLabelMod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GOSlimmerGeneAssociationDialog
extends JPanel
implements ActionListener {
    Map<GONamespace, GOSlimmerController> namespaceToController;
    private String ontologyName;
    private GOSlimmerSession session;
    private JDialog annotationChooserDialog;
    private Map<String, String> annotationURLMap = new HashMap<String, String>();
    private JCollapsablePanel advancedOptionsSubPanel;
    private Map<String, String> speciesNameToGeneAssociationRecordName;
    private JPanel selectionPanel;
    JButton applyButton;
    private static final String applyButtonText = "Go";
    JComboBox annotationComboBox;
    JButton annotationBrowseButton;
    JLabel selectedAnnotationFileLabel;
    private static final String geneAssociationRecordNamePrefix = "Gene Association file for ";
    private File userSelectedFile;
    private boolean useUserSpecifiedFile;
    private static final String browseButtonText = "Browse for annotation file ...";

    public GOSlimmerGeneAssociationDialog(Map<GONamespace, GOSlimmerController> namespaceToController, String ontologyName, GOSlimmerSession session) throws HeadlessException {
        this.initComponents();
        this.useUserSpecifiedFile = false;
        this.namespaceToController = namespaceToController;
        this.ontologyName = ontologyName;
        this.session = session;
    }

    private JDialog getAnnotationChooserDialog() {
        if (this.annotationChooserDialog == null) {
            this.annotationChooserDialog = new JDialog((Frame)Cytoscape.getDesktop(), true);
            this.annotationChooserDialog.add(this.getAnnotationComboBox());
            this.annotationChooserDialog.add(this.getApplyButton());
            this.getAdvancedOptionsSubPanel().setCollapsed(true);
            this.annotationChooserDialog.add(this.getAdvancedOptionsSubPanel());
        }
        return this.annotationChooserDialog;
    }

    private JCollapsablePanel getAdvancedOptionsSubPanel() {
        if (this.advancedOptionsSubPanel == null) {
            this.advancedOptionsSubPanel = new JCollapsablePanel("Advanced Options");
            this.advancedOptionsSubPanel.add(this.getAnnotationBrowseButton());
        }
        return this.advancedOptionsSubPanel;
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder("Select Gene Annotation"));
        this.setLayout(new BorderLayout());
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.add((Component)this.getSelectedAnnotationFileLabel(), c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)this.getAnnotationComboBox(), c);
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)this.getApplyButton(), c);
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 2;
        c.gridwidth = 0;
        this.getAdvancedOptionsSubPanel().setCollapsed(true);
        this.add((Component)this.getAdvancedOptionsSubPanel(), c);
    }

    private JPanel getSelectionPanel() {
        if (this.selectionPanel == null) {
            this.selectionPanel = new JPanel();
            this.selectionPanel.setLayout(new FlowLayout());
            this.selectionPanel.add(this.getAnnotationComboBox());
            this.selectionPanel.add(this.getAnnotationBrowseButton());
        }
        return this.selectionPanel;
    }

    private JButton getApplyButton() {
        if (this.applyButton != null) {
            return this.applyButton;
        }
        this.applyButton = new JButton(applyButtonText);
        this.applyButton.addActionListener(this);
        int height = this.applyButton.getHeight();
        return this.applyButton;
    }

    private JButton getAnnotationBrowseButton() {
        if (this.annotationBrowseButton != null) {
            return this.annotationBrowseButton;
        }
        this.annotationBrowseButton = new JButton(browseButtonText);
        this.annotationBrowseButton.addActionListener(this);
        return this.annotationBrowseButton;
    }

    private JComboBox getAnnotationComboBox() {
        if (this.annotationComboBox != null) {
            return this.annotationComboBox;
        }
        this.annotationComboBox = new JComboBox();
        this.annotationComboBox.setMaximumSize(new Dimension(60, 15));
        Bookmarks bookmarks = null;
        try {
            bookmarks = Cytoscape.getBookmarks();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to retrieve cytoscape bookmarks to determine gene annotation options", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve cytoscape bookmarks to determine gene annotation options", e);
        }
        List annotations = BookmarksUtil.getDataSourceList((String)"annotation", (List)bookmarks.getCategory());
        for (DataSource annot : annotations) {
            String annotName = annot.getName();
            this.annotationURLMap.put(annotName, annot.getHref());
            if (annotName.startsWith(geneAssociationRecordNamePrefix)) {
                String speciesName = annotName.substring(geneAssociationRecordNamePrefix.length(), annotName.length());
                this.annotationComboBox.addItem(speciesName);
                continue;
            }
            this.annotationComboBox.addItem(annotName);
        }
        this.speciesNameToGeneAssociationRecordName = this.createSpeciesNameToGeneAssociationRecordNameMap(this.annotationURLMap.keySet());
        this.annotationComboBox.addActionListener(this);
        return this.annotationComboBox;
    }

    private Map<String, String> createSpeciesNameToGeneAssociationRecordNameMap(Collection<String> geneAssociationRecordNames) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (String geneAssociationRecordName : geneAssociationRecordNames) {
            if (geneAssociationRecordName.startsWith(geneAssociationRecordNamePrefix)) {
                String speciesName = geneAssociationRecordName.substring(geneAssociationRecordNamePrefix.length(), geneAssociationRecordName.length());
                m.put(speciesName, geneAssociationRecordName);
                continue;
            }
            m.put(geneAssociationRecordName, geneAssociationRecordName);
        }
        return m;
    }

    private JLabel getSelectedAnnotationFileLabel() {
        if (this.selectedAnnotationFileLabel != null) {
            return this.selectedAnnotationFileLabel;
        }
        this.selectedAnnotationFileLabel = new JLabelMod();
        int height = this.selectedAnnotationFileLabel.getHeight();
        this.selectedAnnotationFileLabel.setText("Gene Association File Applied: none");
        return this.selectedAnnotationFileLabel;
    }

    private void updateSelectedAnnotationFileLabelText() {
        String comboBoxSelection = null;
        comboBoxSelection = this.useUserSpecifiedFile ? this.userSelectedFile.getName() : (String)this.getAnnotationComboBox().getSelectedItem();
        this.selectedAnnotationFileLabel.setText("Gene Association File Applied: " + comboBoxSelection);
        if (this.session != null && this.session.getGaru() != null && this.session.getGaru().getHeaderComment() != null) {
            this.selectedAnnotationFileLabel.setToolTipText(this.session.getGaru().getHeaderComment().toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof JButton) {
            JButton bSource = (JButton)event.getSource();
            if (bSource.getText().equals(browseButtonText)) {
                JFileChooser annotFileChooser = new JFileChooser();
                int retVal = annotFileChooser.showOpenDialog(this);
                if (retVal != 0) return;
                this.userSelectedFile = annotFileChooser.getSelectedFile();
                this.useUserSpecifiedFile = true;
                return;
            } else {
                if (!bSource.getText().equals(applyButtonText)) throw new RuntimeException("Unrecognized button press event received: " + event.getSource());
                System.out.println("Apply button pressed");
                TaskManager.executeTask((Task)new Task(){

                    public String getTitle() {
                        return "Retrieving and applying Gene Annotation Data";
                    }

                    public void halt() {
                    }

                    public void run() {
                        try {
                            GOSlimmerGeneAssociationDialog.this.applySelectedAnnotationToGOGraphs();
                            GOSlimPanel panel = GOSlimmerGeneAssociationDialog.this.session.getGOSlimPanel();
                            panel.setViewSettingsPanelVisible(true);
                            panel.setNamespaceSubpanelsVisible(true);
                            panel.setFileExportPanelVisible(true);
                            panel.setUserGeneSetImportPanelVisible(true);
                            panel.setAutomaticGOSetGeneratorPanelVisible(true);
                            GOSlimmerGeneAssociationDialog.this.updateSelectedAnnotationFileLabelText();
                        }
                        catch (FileNotFoundException e) {
                            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to apply gene annotation data because File could not be found: " + e.getMessage(), "Error", 0);
                        }
                        catch (MalformedURLException e) {
                            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to apply gene annotation data because URL is not valid: " + e.getMessage(), "Error", 0);
                        }
                        catch (GOFormatException e) {
                            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Failed to apply gene annotation data because annotation file is not valid: " + e.getMessage(), "Error", 0);
                        }
                    }

                    public void setTaskMonitor(TaskMonitor arg0) throws IllegalThreadStateException {
                    }
                }, null);
            }
            return;
        } else {
            if (!(event.getSource() instanceof JComboBox)) throw new RuntimeException("Unrecognized event received: " + event.getSource());
            if (event.getSource() != this.annotationComboBox) return;
            this.useUserSpecifiedFile = false;
        }
    }

    private void applySelectedAnnotationToGOGraphs() throws FileNotFoundException, MalformedURLException, GOFormatException {
        GeneAssociationReaderUtil garu;
        URL annotURL = this.getSelectedAnnotationURL();
        try {
            garu = new GeneAssociationReaderUtil(this.ontologyName, annotURL, "GO:ID");
            garu.readTable();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to access gene association file", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to access gene association file", e);
        }
        catch (GOFormatException e) {
            throw new GOFormatException("Failed to parse Gene Annotation file because it is not a valid Gene Annotation File", e);
        }
        Map<String, List<String>> goIdToGeneIdMap = garu.getGOIDToGeneIDMap();
        Map<String, List<String>> goIdToGeneSynonymMap = garu.getGOIDToGeneSynonyms();
        for (GONamespace ns : this.namespaceToController.keySet()) {
            GOSlimmerController controller = this.namespaceToController.get((Object)ns);
            Set<String> nsGeneIds = garu.getNamespaceGeneIds(ns);
            controller.removeCoverageAttributes();
            controller.assignGeneIdCoverageAttributesToNetworks(goIdToGeneIdMap);
            controller.assignGeneSynonymCoverageAttributesToNetworks(goIdToGeneSynonymMap);
            controller.resetAndRecalculateStatisticsBean(nsGeneIds.size());
            controller.getNetworkView().applyVizmapper(Cytoscape.getVisualMappingManager().getVisualStyle());
        }
        if (this.session.isUserGeneSetImported()) {
            HashSet<String> matchedIds = new HashSet<String>();
            for (GOSlimmerController controller : this.namespaceToController.values()) {
                matchedIds.addAll(controller.applyUserGeneSet(this.session.getUserGeneSet()));
            }
            Collection<String> unmatchedIds = GOSlimmerUtil.difference(this.session.getUserGeneSet(), matchedIds);
            this.session.setUnmatchedUserGeneIds(unmatchedIds);
            UserGeneSetImportPanel usgip = this.session.getGOSlimPanel().getUserGeneSetImportPanel();
            usgip.updateUnmatchedIdsLabel(unmatchedIds);
            usgip.updateMatchedIdsLabel(matchedIds);
            usgip.updateTotalUserIdsLabel(this.session.getUserGeneSet());
            for (GOSlimmerController controller : this.namespaceToController.values()) {
                controller.setupUserGeneStatistics(matchedIds.size());
            }
        }
        this.session.setGaru(garu);
    }

    private URL getSelectedAnnotationURL() throws MalformedURLException {
        URL annotURL = null;
        if (this.useUserSpecifiedFile) {
            annotURL = this.userSelectedFile.toURL();
        } else {
            String selectedSpeciesName = (String)this.annotationComboBox.getSelectedItem();
            String selectedGeneAssociationRecord = this.speciesNameToGeneAssociationRecordName.get(selectedSpeciesName);
            String annotURLS = this.annotationURLMap.get(selectedGeneAssociationRecord);
            annotURL = new URL(annotURLS);
        }
        return annotURL;
    }
}

