/*
 * Decompiled with CFR 0.152.
 */
package org.ccbr.bader.yeast.view.gui;

import cytoscape.Cytoscape;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.task.util.TaskManager;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import org.ccbr.bader.yeast.controller.GOSlimmerController;
import org.ccbr.bader.yeast.view.gui.ExpandCollapseEdit;

public class NodeContextMenuActionListener
implements ActionListener {
    private Node node;
    private GOSlimmerController controller;
    private String collapseButtonText = "Collapse";
    private String expandButtonText = "Expand";
    private String pruneButtonText = "Prune";
    private String cancelButtonText = "Cancel";
    private String selectButtonText = "Select";
    private String deselectButtonText = "Deselect";

    public NodeContextMenuActionListener(Node node, GOSlimmerController controller) {
        this.node = node;
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JMenuItem) {
            JMenuItem jbSource = (JMenuItem)source;
            if (jbSource.getText().equals(this.collapseButtonText)) {
                ExpandCollapseEdit undoableEdit = new ExpandCollapseEdit(this.controller, "Node Collapse");
                this.controller.collapseNode(this.node);
                undoableEdit.post();
            } else if (jbSource.getText().equals(this.expandButtonText)) {
                boolean fullExpand = false;
                if (e.getModifiers() == 18) {
                    fullExpand = true;
                }
                System.out.println("expand button depressed");
                ExpandCollapseEdit undoableEdit = new ExpandCollapseEdit(this.controller, "Node Expand");
                this.controller.expandNode(this.node, fullExpand);
                undoableEdit.post();
            } else if (jbSource.getText().equals(this.pruneButtonText)) {
                System.out.println("Prune button depressed");
                this.controller.pruneNode(this.node);
            } else if (jbSource.getText().equals(this.cancelButtonText)) {
                System.out.println("Cancel button depressed");
            } else if (jbSource.getText().startsWith(this.selectButtonText)) {
                this.controller.addNodeToSlimSet(this.node);
            } else if (jbSource.getText().equals(this.deselectButtonText)) {
                JTaskConfig config = new JTaskConfig();
                config.displayStatus(true);
                TaskManager.executeTask((Task)new Task(){
                    private TaskMonitor taskMonitor = null;

                    public String getTitle() {
                        return "Recalculating Coverage Statistics";
                    }

                    public void halt() {
                    }

                    public void run() {
                        if (this.taskMonitor == null) {
                            throw new IllegalStateException("Task Monitor is not set.");
                        }
                        this.taskMonitor.setPercentCompleted(0);
                        NodeContextMenuActionListener.this.controller.removeNodeFromSlimSet(NodeContextMenuActionListener.this.node, this.taskMonitor);
                    }

                    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
                        this.taskMonitor = taskMonitor;
                    }
                }, (JTaskConfig)config);
            }
            Cytoscape.getCurrentNetworkView().redrawGraph(false, false);
        }
    }
}

