package org.baderlab.lola.resources;

/**
 Copyright 2007 Bader Lab

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU Lesser General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: May 30, 2007
 * Time: 12:26:26 AM
 * To change this template use File | Settings | File Templates.
 */
public final class LolaResources {


    //application
    public final static String APPLICATION_NAME = "LOLA";
    public final static String APPLICATION_SHORT_DESCRIPTION = "LOgos Look Amazing!";    
    public final static String APPLICATION_VERSION = "1.2 beta";
    public final static String APPLICATION_BUILD_DATE = "May 12, 2008";
    public final static String APPLICATION_WEB_URL = "www.baderlab.org";        
    public final static String APPLICATION_WELCOME_IMAGE = "/org/baderlab/lola/resources/lola_logo.png";

    //parameter defaults and thresholds
    public final static double FUZZ_FACTOR_DEFAULT = 0.0;

    public final static boolean UNIQUE_PEPTIDES_DEFAULT = true;

    public final static int LOGO_START_INDEX_DEFAULT = 1;

    public final static int LOGO_HEIGHT_DEFAULT = 180;
    public final static int LOGO_HEIGHT_MIN = 10;
    public final static int LOGO_HEIGHT_MAX = 2000;
    
    public final static double LOGO_TRIM_PERCENTAGE_DEFAULT = 0.100;
    public final static double LOGO_TRIM_PERCENTAGE_MIN = 0;
    public final static double LOGO_TRIM_PERCENTAGE_MAX = 1.000;

    //residue colouring style
    public final static String COLOR_STYLE_WEBLOGO = "WebLogo";
    public final static String COLOR_STYLE_PDZ = "PDZ";
    public final static String COLOR_STYLE_DEFAULT = COLOR_STYLE_WEBLOGO;
    public final static String[] COLOR_STYLES = {
            COLOR_STYLE_WEBLOGO,
            COLOR_STYLE_PDZ
    };

    //output format
    public final static String IMAGE_FORMAT_BMP = "Bitmap";
    public final static String IMAGE_FORMAT_JPG = "JPEG";
    public final static String IMAGE_FORMAT_PNG = "PNG";
    public final static String IMAGE_FORMAT_PDF = "PDF";
    public final static String LOGO_IMAGE_FORMAT_DEFAULT = IMAGE_FORMAT_PDF;
    public final static String[] IMAGE_FORMAT_STRINGS = {
            IMAGE_FORMAT_BMP,
            IMAGE_FORMAT_JPG,
            IMAGE_FORMAT_PNG,
            IMAGE_FORMAT_PDF
    };

    //output file extension
    public final static String FILE_EXTENSION_BMP = ".bmp";
    public final static String FILE_EXTENSION_JPEG = ".jpg";
    public final static String FILE_EXTENSION_PNG = ".png";
    public final static String FILE_EXTENSION_PDF = ".pdf";

    //logo tree
    public final static String TREE_TITLE = "Sequence Logo Tree";
    public final static String TREE_IMAGE_FORMAT_DEFAULT = IMAGE_FORMAT_PDF;
    public final static String TREE_FILE_SUFFIX = ".LogoTree";
    public final static String[] TREE_IMAGE_FORMAT_STRINGS = {
            IMAGE_FORMAT_PDF
    };


    /**
     * Returns the file extension correspoding to the given file format.
     * File format must be one of the IMAGE_FORMAT_* string defined in this class.
     *
     * @param format one of the IMAGE_FORMAT_* string defined in this class
     * @return File extension as a String
     */
    public final static String getFileExtension(String format) {
        if (format.equalsIgnoreCase(IMAGE_FORMAT_BMP)) {
            return FILE_EXTENSION_BMP;
        }
        if (format.equalsIgnoreCase(IMAGE_FORMAT_JPG)) {
            return FILE_EXTENSION_JPEG;
        }
        if (format.equalsIgnoreCase(IMAGE_FORMAT_PNG)) {
            return FILE_EXTENSION_PNG;
        }
        if (format.equalsIgnoreCase(IMAGE_FORMAT_PDF)) {
            return FILE_EXTENSION_PDF;
        }
        return null;

    }


}
