/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;
import org.baderlab.csapps.socialnetwork.model.academia.Incites_InstitutionLocationMap;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.view.model.CyNetworkViewManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddInstitutionAction
extends AbstractCyAction {
    private HashSet<String> locationSet = null;

    private void setLocationSet(HashSet<String> locationSet) {
        this.locationSet = locationSet;
    }

    private HashSet<String> getLocationSet() {
        return this.locationSet;
    }

    public AddInstitutionAction(Map<String, String> configProps, CyApplicationManager applicationManager, CyNetworkViewManager networkViewManager) {
        super(configProps, applicationManager, networkViewManager);
        String[] locations;
        this.putValue("Name", "Add Institution");
        HashSet<String> set = new HashSet<String>();
        for (String location : locations = new String[]{"univ toronto", "ontario", "canada", "united states", "international", "other"}) {
            set.add(location);
        }
        this.setLocationSet(set);
    }

    public void actionPerformed(ActionEvent arg0) {
        JTextField institutionTextField = new JTextField(5);
        JTextField locationTextField = new JTextField(5);
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new BoxLayout(myPanel, 1));
        myPanel.add(new JLabel("Institution"));
        myPanel.add(institutionTextField);
        myPanel.add(new JLabel("Location"));
        myPanel.add(locationTextField);
        int outcome = 0;
        String institution = "N/A";
        String location = "N/A";
        while (outcome == 0) {
            outcome = JOptionPane.showConfirmDialog(null, myPanel, "Login", 2);
            if (outcome != 0) continue;
            institution = institutionTextField.getText().trim();
            location = locationTextField.getText().trim();
            if (institution.trim().isEmpty() && location.trim().isEmpty()) {
                CytoscapeUtilities.notifyUser("Please specify both an institution and a location");
                continue;
            }
            if (institution.trim().isEmpty()) {
                CytoscapeUtilities.notifyUser("Please specify an institution");
                continue;
            }
            if (location.trim().isEmpty()) {
                CytoscapeUtilities.notifyUser("Please specify a location");
                continue;
            }
            if (!this.getLocationSet().contains(location.toLowerCase())) {
                CytoscapeUtilities.notifyUser("Location does not exist. Please enter a valid location.");
                continue;
            }
            institution = institution.toUpperCase();
            String[] words = location.split("\\s");
            location = "";
            for (String word : words) {
                location = location + word.replaceAll("^\\w", word.substring(0, 1).toUpperCase()) + " ";
            }
            location = location.trim();
            outcome = 2;
        }
        if (!institution.trim().isEmpty() && !location.trim().isEmpty()) {
            try {
                InputStream in = Incites_InstitutionLocationMap.class.getClassLoader().getResourceAsStream("map.sn");
                ObjectInputStream ois = new ObjectInputStream(in);
                HashMap map = (HashMap)ois.readObject();
                map.put(institution, location);
            }
            catch (IOException e) {
                e.printStackTrace();
                CytoscapeUtilities.notifyUser("Location map could not be accessed.");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                CytoscapeUtilities.notifyUser("Location map could not be accessed.");
            }
        }
    }
}

