/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.baderlab.csapps.socialnetwork.model.AbstractEdge;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.Collaboration;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Copublications;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interaction {
    private Map<Collaboration, ArrayList<AbstractEdge>> map = null;

    public Interaction(List<? extends AbstractEdge> edgeList, int type) {
        switch (type) {
            case -2113004178: {
                this.setAbstractMap(this.loadAcademiaMap(edgeList));
                break;
            }
            case 1249763952: {
                this.setAbstractMap(this.loadAcademiaMap(edgeList));
            }
        }
    }

    public Map<Collaboration, ArrayList<AbstractEdge>> getAbstractMap() {
        return this.map;
    }

    private void setAbstractMap(Map<Collaboration, ArrayList<AbstractEdge>> abstractMap) {
        this.map = abstractMap;
    }

    private Map<Collaboration, ArrayList<AbstractEdge>> loadAbstractMap(List<? extends AbstractEdge> abstractEdgeList) {
        HashMap<Collaboration, ArrayList<AbstractEdge>> abstractMap = new HashMap<Collaboration, ArrayList<AbstractEdge>>();
        for (AbstractEdge abstractEdge : abstractEdgeList) {
            int j = 0;
            Collaboration collaboration = null;
            ArrayList<AbstractEdge> edgeList = null;
            AbstractNode node1 = null;
            AbstractNode node2 = null;
            for (int i = 0; i < abstractEdge.getNodes().size(); ++i) {
                node1 = abstractEdge.getNodes().get(i);
                for (j = i + 1; j < abstractEdge.getNodes().size(); ++j) {
                    node2 = abstractEdge.getNodes().get(j);
                    collaboration = new Collaboration(node1, node2);
                    if (!abstractMap.containsKey(collaboration)) {
                        edgeList = new ArrayList<AbstractEdge>();
                        edgeList.add(abstractEdge);
                        abstractMap.put(collaboration, edgeList);
                        continue;
                    }
                    ((ArrayList)abstractMap.get(collaboration)).add(abstractEdge);
                }
            }
        }
        return abstractMap;
    }

    private Map<Collaboration, ArrayList<AbstractEdge>> loadAcademiaMap(List<? extends AbstractEdge> results) {
        HashMap<Collaboration, ArrayList<AbstractEdge>> academiaMap = new HashMap<Collaboration, ArrayList<AbstractEdge>>();
        HashMap<Author, Author> authorMap = new HashMap<Author, Author>();
        int i = 0;
        int j = 0;
        Collaboration collaboration = null;
        Author author1 = null;
        Author author2 = null;
        Copublications copublications = null;
        Publication publication = null;
        for (int h = 0; h <= results.size() - 1; ++h) {
            j = 0;
            collaboration = null;
            author1 = null;
            author2 = null;
            copublications = null;
            publication = (Publication)results.get(h);
            for (i = 0; i < publication.getNodes().size(); ++i) {
                author1 = (Author)publication.getNodes().get(i);
                if (authorMap.get(author1) == null) {
                    authorMap.put(author1, author1);
                }
                ((Author)authorMap.get(author1)).addPublication(publication);
                for (j = i + 1; j < publication.getNodes().size(); ++j) {
                    author2 = (Author)publication.getNodes().get(j);
                    if (authorMap.get(author2) == null) {
                        authorMap.put(author2, author2);
                    }
                    if (!academiaMap.containsKey(collaboration = new Collaboration((AbstractNode)authorMap.get(author1), (AbstractNode)authorMap.get(author2)))) {
                        copublications = new Copublications(collaboration, publication);
                        ArrayList<Copublications> edgeList = new ArrayList<Copublications>();
                        edgeList.add(copublications);
                        academiaMap.put(collaboration, edgeList);
                        continue;
                    }
                    ArrayList array = (ArrayList)academiaMap.get(collaboration);
                    copublications = (Copublications)array.get(0);
                    copublications.addPublication(publication);
                }
            }
        }
        return academiaMap;
    }
}

