/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.twitter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.baderlab.csapps.socialnetwork.CytoscapeUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Twitter {
    private Map<String, String> oauthMap = null;
    private final String BASE_URL = "https://api.twitter.com/1.1/";
    private final String USER_AGENT = "Mozilla/5.0";

    private String createOAuthNonce() {
        SecureRandom random = new SecureRandom();
        String oAuthNonce = new BigInteger(130, random).toString(32);
        return oAuthNonce;
    }

    private String createOAuthSignature() {
        String oAuthSignature = "";
        return oAuthSignature;
    }

    private String createOAuthTimeStamp() {
        long oauthTimeStamp = System.currentTimeMillis() / 1000L;
        return Long.toString(oauthTimeStamp);
    }

    private String getOAuthToken() {
        String oAuthToken = "";
        return oAuthToken;
    }

    private Map<String, String> getOAuthMap() {
        if (this.oauthMap == null) {
            this.constructOAuthMap(this.createOAuthNonce(), this.createOAuthSignature(), this.createOAuthTimeStamp(), this.getOAuthToken());
        }
        return this.oauthMap;
    }

    private void setOAuthMap(Map<String, String> oauthMap) {
        this.oauthMap = oauthMap;
    }

    private String BuildOAuthHeader() {
        String header = "OAuth ";
        for (Map.Entry<String, String> entry : this.getOAuthMap().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            try {
                header = header + URLEncoder.encode(key, "UTF-8") + "\\\"" + URLEncoder.encode(value, "UTF-8") + "\\\",";
            }
            catch (UnsupportedEncodingException e) {}
        }
        return header.substring(0, header.length() - 1);
    }

    private void constructOAuthMap(String oauthNonce, String oauthSignature, String oauthTimeStamp, String oauthToken) {
        this.oauthMap = new HashMap<String, String>();
        this.oauthMap.put("oauth_consumer_key", "YMrFw7eXnL2GiNusZ4Pj3Q");
        this.oauthMap.put("oauth_nonce", oauthNonce);
        this.oauthMap.put("oauth_signature", oauthSignature);
        this.oauthMap.put("oauth_signature_method", "HMAC-SHA1");
        this.oauthMap.put("oauth_timestamp", oauthTimeStamp);
        this.oauthMap.put("oauth_token", oauthToken);
        this.oauthMap.put("oauth_version", "1.0");
    }

    private HttpURLConnection createRequest(String resourceURL, String httpMethod) {
        try {
            URL obj = new URL(this.BASE_URL + resourceURL + ".json");
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod(httpMethod);
            con.setRequestProperty("User-Agent", "Mozilla/5.0");
            con.setRequestProperty("X-HostCommonName", "api.twitter.com");
            con.setRequestProperty("Authorization", this.BuildOAuthHeader());
            con.setRequestProperty("Host", "api.twitter.com");
            con.setRequestProperty("X-Target-URI", "https://api.twitter.com");
            con.setRequestProperty("Connection", "Keep Alive");
            return con;
        }
        catch (MalformedURLException e) {
            CytoscapeUtilities.notifyUser("Twitter! DERP!!");
        }
        catch (IOException e) {
            CytoscapeUtilities.notifyUser("Twitter! DERP!!");
        }
        return null;
    }

    private void sendRequest(String resourceURL, String httpMethod) throws Exception {
        String inputLine;
        HttpURLConnection con = this.createRequest(resourceURL, httpMethod);
        int responseCode = con.getResponseCode();
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        System.out.println(response.toString());
    }

    public static void main(String[] args) throws Exception {
        Twitter http = new Twitter();
        System.out.println("Testing 1 - Send a request");
        http.sendRequest("followers/ids", "GET");
    }
}

