/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.xmlbeans.impl.common.Levenshtein;
import org.baderlab.csapps.socialnetwork.model.AbstractNode;
import org.baderlab.csapps.socialnetwork.model.academia.Incites_InstitutionLocationMap;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.Scopus;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.incites.IncitesParser;
import org.cytoscape.model.CyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Author
extends AbstractNode {
    private String department = "N/A";
    private String firstInitial = "?";
    private String firstName = "N/A";
    private String institution = "N/A";
    private String lastName = "N/A";
    private String location = "N/A";
    private String middleInitial = "N/A";
    private int timesCited = 0;
    private int origin = -1;
    private boolean identified = false;
    private boolean alreadyBeenAdded = false;
    private List<String> pubList = null;
    private Incites_InstitutionLocationMap locationMap = null;

    private void setIdenfitication(boolean bool) {
        this.identified = bool;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public Author(String rawAuthorText, int origin) {
        this.setOrigin(origin);
        switch (origin) {
            case -960949447: {
                this.setNodeAttrMap(Scopus.constructScopusAttrMap(this));
                String[] scopusNames = rawAuthorText.split("\\s|,");
                if (scopusNames.length == 1) {
                    this.setLastName(scopusNames[0]);
                } else {
                    String lastName = scopusNames[0];
                    int i = 1;
                    for (i = 1; i < scopusNames.length - 1; ++i) {
                        lastName = lastName + " " + scopusNames[i];
                    }
                    this.setLastName(lastName);
                    String[] initials = scopusNames[i].split("\\.");
                    if (initials.length == 1) {
                        this.setFirstName(initials[0]);
                        this.setFirstInitial(initials[0]);
                    } else if (initials.length > 1) {
                        this.setFirstName(initials[0]);
                        this.setFirstInitial(initials[0]);
                        this.setMiddleInitial(initials[1]);
                    }
                }
                this.setLabel(this.getFirstInitial() + " " + this.getLastName());
                break;
            }
            case -2113004178: {
                this.setNodeAttrMap(Scopus.constructScopusAttrMap(this));
                String[] pubmedNames = rawAuthorText.split("\\s");
                if (pubmedNames.length == 1) {
                    this.lastName = pubmedNames[0];
                    break;
                }
                String lastName = pubmedNames[0];
                int i = 1;
                for (i = 1; i < pubmedNames.length - 1; ++i) {
                    lastName = lastName + " " + pubmedNames[i];
                }
                this.setLastName(lastName);
                if (pubmedNames[i].length() >= 2) {
                    this.setFirstInitial(pubmedNames[i].substring(0, 1));
                    this.setMiddleInitial(pubmedNames[i].substring(1));
                } else {
                    this.setFirstInitial(pubmedNames[i]);
                }
                this.setLabel(this.getFirstInitial() + " " + this.getLastName());
                break;
            }
            case -2: {
                String[] authorAttr = rawAuthorText.split(";");
                this.setLastName(authorAttr[0]);
                this.setFirstName(authorAttr[1]);
                this.setFirstInitial(this.getFirstName().substring(0, 1));
                this.setNodeAttrMap(null);
            }
        }
        this.format();
    }

    public Author(String rawAuthorText, int origin, Incites_InstitutionLocationMap locationMap) {
        this.setOrigin(origin);
        switch (origin) {
            case 1410511959: {
                this.locationMap = locationMap;
                this.setNodeAttrMap(Author.constructIncitesAttrMap());
                this.setFirstName(IncitesParser.parseFirstName(rawAuthorText));
                if (!this.getFirstName().equalsIgnoreCase("N/A")) {
                    this.setFirstInitial(this.getFirstName().substring(0, 1));
                }
                this.setMiddleInitial(IncitesParser.parseMiddleInitial(rawAuthorText));
                this.setLastName(IncitesParser.parseLastName(rawAuthorText));
                this.setLabel(this.getFirstName() + " " + this.getLastName());
                this.setInstitution(IncitesParser.parseInstitution(rawAuthorText));
                this.setLocation(locationMap.getLocationMap().get(this.getInstitution()));
            }
        }
        this.format();
    }

    private boolean isSameFirstName(String name) {
        boolean isEqualFirstName = false;
        String firstname1 = this.getFirstName().split(" ").length > 1 ? this.getFirstName().split(" ")[0] : this.getFirstName();
        String firstname2 = name.split(" ").length > 1 ? name.split(" ")[0] : name;
        double distance = Levenshtein.distance((String)firstname1.toLowerCase(), (String)firstname2.toLowerCase());
        double similarity = 1.0 - distance / (double)Math.max(firstname1.length(), firstname2.length());
        if (similarity >= 0.75) {
            isEqualFirstName = true;
        } else if (firstname1.length() == 1 || firstname2.length() == 1 || firstname1.length() == 2 && firstname1.contains(".") || firstname2.length() == 2 && firstname2.contains(".")) {
            isEqualFirstName = firstname1.substring(0, 1).equalsIgnoreCase(firstname2.substring(0, 1));
        }
        return isEqualFirstName;
    }

    public boolean equals(Object other) {
        Author otherAuthor = (Author)other;
        boolean isEqual = false;
        boolean isEqualFirstName = false;
        boolean isEqualLastName = false;
        boolean distance = false;
        double similarity = 0.0;
        if (this.getOrigin() == 1410511959 && otherAuthor.getOrigin() == 1410511959) {
            boolean isEqualInstitution = false;
            isEqualLastName = this.getLastName().equalsIgnoreCase(otherAuthor.getLastName());
            isEqualFirstName = this.isSameFirstName(otherAuthor.getFirstName());
            String myInstitution = this.getInstitution();
            String otherInstitution = otherAuthor.getInstitution();
            isEqualInstitution = myInstitution.equalsIgnoreCase(otherInstitution);
            if (isEqualLastName && isEqualFirstName && !isEqualInstitution) {
                this.prioritizeInstitution(this, otherAuthor);
                isEqualInstitution = true;
            }
            isEqual = isEqualLastName && isEqualFirstName && isEqualInstitution;
        } else if (this.getOrigin() == 1410511959 && otherAuthor.getOrigin() == -2 || this.getOrigin() == -2 && otherAuthor.getOrigin() == 1410511959) {
            isEqualLastName = this.getLastName().equalsIgnoreCase(otherAuthor.getLastName());
            isEqualFirstName = this.isSameFirstName(otherAuthor.getFirstName());
            boolean bl = isEqual = isEqualLastName && isEqualFirstName;
            if (isEqual) {
                otherAuthor.setIdenfitication(true);
            }
        } else if (this.getOrigin() == -2113004178 && otherAuthor.getOrigin() == -2113004178 || this.getOrigin() == -960949447 && otherAuthor.getOrigin() == -960949447) {
            isEqualLastName = this.getLastName().equalsIgnoreCase(otherAuthor.getLastName());
            isEqualFirstName = this.getFirstInitial().equalsIgnoreCase(otherAuthor.getFirstInitial());
            isEqual = isEqualFirstName && isEqualLastName;
        }
        return isEqual;
    }

    public void prioritizeInstitution(Author author, Author otherAuthor) {
        String location = author.getLocation();
        String otherLocation = otherAuthor.getLocation();
        Map<String, Integer> rankMap = this.locationMap.getLocationRankingMap();
        int rank = 0;
        int otherRank = 0;
        if (rankMap.containsKey(location)) {
            rank = rankMap.get(location);
        }
        if (rankMap.containsKey(otherLocation)) {
            otherRank = rankMap.get(otherLocation);
        }
        if (rank > otherRank) {
            otherAuthor.setInstitution(author.getInstitution());
            otherAuthor.setLocation(author.getLocation());
        } else if (rank == otherRank) {
            Author[] randomAuthorArray = new Author[]{author, otherAuthor};
            Random rand = new Random();
            int i = rand.nextInt(2) + 0;
            String randomInstitution = randomAuthorArray[i].getInstitution();
            String randomLocation = randomAuthorArray[i].getLocation();
            otherAuthor.setInstitution(randomInstitution);
            otherAuthor.setLocation(randomLocation);
        }
    }

    public void format() {
        String firstName = this.getFirstName().substring(0, 1).toUpperCase() + this.getFirstName().substring(1).toLowerCase();
        this.setFirstName(firstName);
        String lastName = this.getLastName().substring(0, 1).toUpperCase() + this.getLastName().substring(1).toLowerCase();
        this.setLastName(lastName);
        this.setFirstInitial(this.getFirstInitial().toUpperCase());
        this.setMiddleInitial(this.getMiddleInitial().toUpperCase());
    }

    public String getDepartment() {
        return this.department;
    }

    public String getFirstInitial() {
        return this.firstInitial;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getInstitution() {
        return this.institution;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public Map<String, Object> getNodeAttrMap() {
        if (this.nodeAttrMap == null) {
            this.nodeAttrMap = new HashMap();
        }
        return this.nodeAttrMap;
    }

    public int getTimesCited() {
        return this.timesCited;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result += 31 * result + (this.firstInitial == null ? 0 : this.firstInitial.hashCode());
        result += 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        return result;
    }

    public void setFaculty(String department) {
        this.department = department;
        this.getNodeAttrMap().put("Department", department);
    }

    public void setFirstInitial(String firstInitial) {
        this.firstInitial = firstInitial;
    }

    public void setLocation(String location) {
        this.location = location == null ? (this.getInstitution().equalsIgnoreCase("N/A") ? "N/A" : "Other") : location;
        this.getNodeAttrMap().put("Location", this.location);
    }

    @Override
    public void setNodeAttrMap(Map<String, Object> attrMap) {
        this.nodeAttrMap = attrMap;
    }

    public void setTimesCited(int timesCited) {
        this.timesCited = timesCited;
        this.getNodeAttrMap().put("Times Cited", timesCited);
    }

    public String toString() {
        return this.lastName + ", " + this.firstName;
    }

    public int getOrigin() {
        return this.origin;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    @Override
    public CyNode getCyNode() {
        return this.cyNode;
    }

    @Override
    public void setCyNode(CyNode cyNode) {
        this.cyNode = cyNode;
    }

    public void addPublication(Publication publication) {
        int timesCited = this.getTimesCited();
        ArrayList pubList = (ArrayList)this.getPubList();
        if (publication.isSingleAuthored()) {
            if (!this.hasAlreadyBeenAdded()) {
                this.setTimesCited(timesCited + publication.getTimesCited());
                pubList.add(publication.getTitle());
                this.setPubList(pubList);
                this.setAlreadyBeenAdded(true);
            } else {
                this.setAlreadyBeenAdded(false);
            }
        } else {
            this.setTimesCited(timesCited + publication.getTimesCited());
            pubList.add(publication.getTitle());
            this.setPubList(pubList);
        }
    }

    public void setInstitution(String institution) {
        this.institution = institution;
        this.getNodeAttrMap().put("Institution", institution);
    }

    private void setFirstName(String firstName) {
        this.firstName = firstName;
        this.getNodeAttrMap().put("First Name", firstName);
    }

    private void setLastName(String lastName) {
        this.lastName = lastName;
        this.getNodeAttrMap().put("Last Name", lastName);
    }

    private void setMiddleInitial(String middleInitial) {
        this.middleInitial = middleInitial;
    }

    private String getMiddleInitial() {
        return this.middleInitial;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
        this.getNodeAttrMap().put("Label", label);
    }

    public boolean hasAlreadyBeenAdded() {
        return this.alreadyBeenAdded;
    }

    public void setAlreadyBeenAdded(boolean alreadyBeenAdded) {
        this.alreadyBeenAdded = alreadyBeenAdded;
    }

    public List<String> getPubList() {
        if (this.pubList == null) {
            this.pubList = new ArrayList<String>();
        }
        return this.pubList;
    }

    public void setPubList(List<String> pubList) {
        this.pubList = pubList;
        this.getNodeAttrMap().put("Publications", pubList);
        this.getNodeAttrMap().put("# of Publications", pubList.size());
    }

    public static HashMap<String, Object> constructIncitesAttrMap() {
        HashMap<String, Object> nodeAttrMap = new HashMap<String, Object>();
        String[] columns = new String[]{"Label", "Last Name", "First Name", "Institution", "Location", "Department", "Times Cited", "# of Publications", "Publications"};
        int i = 0;
        for (i = 0; i < 6; ++i) {
            nodeAttrMap.put(columns[i], "");
        }
        nodeAttrMap.put(columns[i], 0);
        nodeAttrMap.put(columns[i + 1], 0);
        nodeAttrMap.put(columns[i + 2], new ArrayList());
        return nodeAttrMap;
    }
}

