/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csapps.socialnetwork.model.academia.parsers.incites;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.baderlab.csapps.socialnetwork.model.academia.Author;
import org.baderlab.csapps.socialnetwork.model.academia.Incites_InstitutionLocationMap;
import org.baderlab.csapps.socialnetwork.model.academia.Publication;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.incites.FacultySheetHandler;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.incites.PubSheetHandler;
import org.baderlab.csapps.socialnetwork.model.academia.parsers.incites.UnableToParseAuthorException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncitesParser {
    private int defectiveRows = 0;
    private String departmentName = null;
    private HashSet<Author> facultySet = null;
    private ArrayList<Author> identifiedFacultyList = null;
    private int ignoredRows = -1;
    private ArrayList<Author> loneAuthorList = null;
    private ArrayList<Publication> pubList = null;
    private ArrayList<Author> unidentifiedFacultyList = null;
    private String unidentifiedFacultyString = null;
    private Incites_InstitutionLocationMap locationMap = new Incites_InstitutionLocationMap();

    public IncitesParser(File xlsx) {
        this.parseFaculty(xlsx);
        this.parsePublications(xlsx);
        this.calculateSummary();
    }

    public boolean authorInList(ArrayList<Author> authorList, Author author) {
        for (Author unknown : authorList) {
            if (!author.getLastName().equalsIgnoreCase(unknown.getLastName()) || !author.getFirstName().equalsIgnoreCase(unknown.getFirstName())) continue;
            author.prioritizeInstitution(author, unknown);
            return true;
        }
        return false;
    }

    private void calculateSummary() {
        ArrayList<Author> identifiedAuthorsList = new ArrayList<Author>();
        ArrayList<Author> unidentifiedAuthorsList = new ArrayList<Author>();
        String unidentifiedAuthorsString = "<ol>";
        Author author = null;
        for (Object object : this.getFacultySet().toArray()) {
            author = (Author)object;
            if (author.isIdentified()) {
                identifiedAuthorsList.add(author);
                continue;
            }
            unidentifiedAuthorsList.add(author);
            unidentifiedAuthorsString = unidentifiedAuthorsString + "<li>" + author.toString() + "</li>";
        }
        this.setIdentifiedFacultyList(identifiedAuthorsList);
        this.setUnidentifiedFacultyList(unidentifiedAuthorsList);
        this.setUnidentifiedFacultyString(unidentifiedAuthorsString + "</ol>");
    }

    public boolean checkIfAuthorValid(Author author) {
        return !author.getFirstName().equalsIgnoreCase("N/A") || !author.getLastName().equalsIgnoreCase("N/A");
    }

    private XMLReader fetchSheetParser(SharedStringsTable sst, int sheet) throws SAXException {
        XMLReader parser = XMLReaderFactory.createXMLReader();
        switch (sheet) {
            case 3: {
                parser.setContentHandler(new PubSheetHandler(sst, this));
                break;
            }
            case 4: {
                parser.setContentHandler(new FacultySheetHandler(sst, this));
            }
        }
        return parser;
    }

    public int getDefectiveRows() {
        return this.defectiveRows;
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public HashSet<Author> getFacultySet() {
        if (this.facultySet == null) {
            this.setFacultySet(new HashSet<Author>());
        }
        return this.facultySet;
    }

    public ArrayList<Author> getIdentifiedFacultyList() {
        return this.identifiedFacultyList;
    }

    public int getIgnoredRows() {
        return this.ignoredRows;
    }

    public ArrayList<Author> getLoneAuthorList() {
        if (this.loneAuthorList == null) {
            this.setLoneAuthorList(new ArrayList<Author>());
        }
        return this.loneAuthorList;
    }

    public ArrayList<Publication> getPubList() {
        if (this.pubList == null) {
            this.setPubList(new ArrayList<Publication>());
        }
        return this.pubList;
    }

    public ArrayList<Author> getUnidentifiedFacultyList() {
        return this.unidentifiedFacultyList;
    }

    public String getUnidentifiedFacultyString() {
        return this.unidentifiedFacultyString;
    }

    public ArrayList<Author> parseAuthors(String rawAuthorText) throws UnableToParseAuthorException {
        String[] authors = rawAuthorText.split(";");
        if (authors.length == 0) {
            throw new UnableToParseAuthorException();
        }
        ArrayList<Author> pubAuthorList = new ArrayList<Author>();
        Author author = null;
        HashSet<Author> facultySet = this.getFacultySet();
        String facultyName = this.getDepartmentName();
        for (String authorText : authors) {
            author = new Author(authorText.trim(), 1410511959, this.locationMap);
            if (this.checkIfAuthorValid(author)) {
                if (this.authorInList(pubAuthorList, author)) continue;
                if (facultySet.contains(author)) {
                    author.setFaculty(facultyName);
                }
                pubAuthorList.add(author);
                continue;
            }
            System.out.println(author);
        }
        return pubAuthorList;
    }

    private void parseFaculty(File xlsxFile) {
        try {
            OPCPackage pkg = OPCPackage.open((String)xlsxFile.getAbsolutePath());
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst, 4);
            InputStream sheet = r.getSheet("rId4");
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setDepartmentName("N/A");
            this.setFacultySet(new HashSet<Author>());
        }
        catch (OpenXML4JException e) {
            e.printStackTrace();
            this.setDepartmentName("N/A");
            this.setFacultySet(new HashSet<Author>());
        }
        catch (SAXException e) {
            e.printStackTrace();
            this.setDepartmentName("N/A");
            this.setFacultySet(new HashSet<Author>());
        }
    }

    public String parseFacultyName(String facultyText) {
        Pattern firstNamePattern = Pattern.compile("(.+?)(\\(|$)");
        Matcher firstNameMatcher = firstNamePattern.matcher(facultyText.trim());
        if (firstNameMatcher.find()) {
            return firstNameMatcher.group(1).trim();
        }
        return "N/A";
    }

    public static String parseFirstName(String incitesText) {
        Pattern firstNamePattern = Pattern.compile(",(.+?)(\\s|\\.|$|\\()");
        Matcher firstNameMatcher = firstNamePattern.matcher(incitesText.trim());
        if (firstNameMatcher.find()) {
            return firstNameMatcher.group(1).trim();
        }
        System.out.println("CHECK: " + incitesText);
        return "N/A";
    }

    public static String parseInstitution(String incitesText) {
        Pattern institution = Pattern.compile("\\((.+?)\\)");
        Matcher matchInstitution = institution.matcher(incitesText);
        if (matchInstitution.find()) {
            return matchInstitution.group(1).trim();
        }
        return "N/A";
    }

    public static String parseLastName(String incitesText) {
        Pattern lastNamePattern = Pattern.compile("\"?\\s?(.+?),");
        Matcher lastNameMatcher = lastNamePattern.matcher(incitesText);
        if (lastNameMatcher.find()) {
            return lastNameMatcher.group(1).trim();
        }
        return "N/A";
    }

    public static String parseMiddleInitial(String incitesText) {
        Pattern middleInitialPattern = Pattern.compile("\\s(\\w)\\.");
        Matcher middleInitialMatcher = middleInitialPattern.matcher(incitesText);
        if (middleInitialMatcher.find()) {
            return middleInitialMatcher.group(1).trim();
        }
        return "N/A";
    }

    private void parsePublications(File xlsxFile) {
        try {
            OPCPackage pkg = OPCPackage.open((String)xlsxFile.getAbsolutePath());
            XSSFReader r = new XSSFReader(pkg);
            SharedStringsTable sst = r.getSharedStringsTable();
            XMLReader parser = this.fetchSheetParser(sst, 3);
            InputStream sheet = r.getSheet("rId3");
            InputSource sheetSource = new InputSource(sheet);
            parser.parse(sheetSource);
            sheet.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.setPubList(null);
        }
        catch (SAXException e) {
            e.printStackTrace();
            this.setPubList(null);
        }
        catch (InvalidFormatException e) {
            e.printStackTrace();
            this.setPubList(null);
        }
        catch (OpenXML4JException e) {
            e.printStackTrace();
            this.setPubList(null);
        }
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    private void setFacultySet(HashSet<Author> facultySet) {
        this.facultySet = facultySet;
    }

    public void setIdentifiedFacultyList(ArrayList<Author> identifiedFacultyList) {
        this.identifiedFacultyList = identifiedFacultyList;
    }

    public void setLoneAuthorList(ArrayList<Author> loneAuthorList) {
        this.loneAuthorList = loneAuthorList;
    }

    private void setPubList(ArrayList<Publication> pubList) {
        this.pubList = pubList;
    }

    public void setUnidentifiedFacultyList(ArrayList<Author> unidentifiedFacultyList) {
        this.unidentifiedFacultyList = unidentifiedFacultyList;
    }

    public void setUnidentifiedFacultyString(String unidentifiedFacultyString) {
        this.unidentifiedFacultyString = unidentifiedFacultyString;
    }

    public void updateDefectiveRows() {
        ++this.defectiveRows;
    }

    public void updateIgnoredRows() {
        ++this.ignoredRows;
    }
}

