/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeMap;
import org.genemania.dw.db.DBUtil;
import org.genemania.dw.entity.EnsemblGene;
import org.genemania.dw.entity.EntrezGene;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.entity.Uniprot;
import org.genemania.dw.util.DefParams;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniprotMirrorTables {
    private static final String IDMAP_TABLE = "IDMap";
    private static final String IDMAPGEN_TABLE = "IDMapGen";
    private static final String ACCN_COL = "UniProtAccn";
    private static final String NAME_COL = "UniProtID";
    private static final String ENTREZ_GENE_COL = "EntrezGene";
    private static final String REFSEQ_COL = "RefSeq";
    private static final String GI_COL = "GI";
    private static final String GO_COL = "GO";
    private static final String TAX_ID_COL = "TaxID";
    private static final String OMIM_COL = "MIM";
    private static final String ENSEMBL_COL = "Ensembl";
    private static final String XREF_IDTYPE_COL = "XrefIDType";
    private static final String XREF_ID_COL = "XrefID";
    private static final String XREFIDTYPE_GI = "GI";
    private static final String XREFIDTYPE_ENTREZ = "GeneID";
    private static final String XREFIDTYPE_REFSEQ = "RefSeq";
    private static String DBName;
    private static PrintWriter log;

    private UniprotMirrorTables() {
    }

    public static TreeMap<String, ExtResource> loadAll(int taxID) throws SQLException {
        System.out.println("loading Uniprot for " + taxID);
        TreeMap<String, ExtResource> uniMap = new TreeMap<String, ExtResource>();
        String loadQuery = "select UniProtAccn, UniProtID, EntrezGene, RefSeq, GI, GO, TaxID, MIM, Ensembl from " + DBName + "." + IDMAP_TABLE + " where " + TAX_ID_COL + " = ?";
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(loadQuery);
            ps.setInt(1, taxID);
            rs = ps.executeQuery();
            int cnt = 0;
            Uniprot uniEntry = null;
            while (rs.next()) {
                if (uniMap.containsKey((uniEntry = UniprotMirrorTables.getResults(rs, uniEntry)).getID())) {
                    System.err.println("Error: Uniprot Accn already exists: " + uniEntry.getID());
                }
                uniMap.put(uniEntry.getID(), uniEntry);
                ++cnt;
            }
            System.out.println("Loaded: " + cnt + " Uniprot entries, for " + "species: " + taxID);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        return uniMap;
    }

    public static TreeMap<String, ExtResource> maptoXref(String xrefType, String xrefID) throws SQLException {
        TreeMap<String, ExtResource> uniMap = new TreeMap<String, ExtResource>();
        String loadQuery = "select XrefIDType, UniProtAccn from " + DBName + "." + IDMAPGEN_TABLE + " where ";
        if (xrefType != null) {
            loadQuery = loadQuery + "XrefIDType = ? and ";
        }
        loadQuery = !xrefID.contains(".") && "RefSeqPro".equals(xrefType) ? loadQuery + "(XrefID like (?) or XrefID = ? )" : loadQuery + "XrefID = ?";
        log.println("LOAD: " + loadQuery);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(loadQuery);
            int index = 1;
            if (xrefType != null) {
                ps.setString(index++, UniprotMirrorTables.getUniXrefType(xrefType));
            }
            if (!xrefID.contains(".") && "RefSeqPro".equals(xrefType)) {
                ps.setString(index++, xrefID + ".%");
            }
            ps.setString(index++, xrefID);
            rs = ps.executeQuery();
            int cnt = 0;
            Uniprot uniEntry = null;
            while (rs.next()) {
                uniEntry = new Uniprot();
                uniEntry.setID(rs.getString(ACCN_COL));
                if (xrefType != null) {
                    if (xrefType.equals("GI") || xrefType.equals("RefSeqPro")) {
                        UniprotMirrorTables.addList(uniEntry, "Entrez", xrefID);
                    } else if (xrefType.equals(ENSEMBL_COL) || xrefType.equals("ExtID")) {
                        UniprotMirrorTables.addXrefList(uniEntry, ENSEMBL_COL, xrefID);
                    }
                }
                uniMap.put(uniEntry.getID(), uniEntry);
                ++cnt;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
        return uniMap;
    }

    private static Uniprot getResults(ResultSet rs, Uniprot uniEntry) throws SQLException {
        uniEntry = new Uniprot();
        uniEntry.setID(rs.getString(ACCN_COL));
        uniEntry.setName(rs.getString(NAME_COL));
        uniEntry.setSpeciesID(rs.getInt(TAX_ID_COL));
        UniprotMirrorTables.addXrefList(uniEntry, "Entrez", rs.getString(ENTREZ_GENE_COL));
        UniprotMirrorTables.addXrefList(uniEntry, ENSEMBL_COL, rs.getString(ENSEMBL_COL));
        UniprotMirrorTables.addList(uniEntry, "RefSeqPro", rs.getString("RefSeq"));
        UniprotMirrorTables.addList(uniEntry, "GI", rs.getString("GI"));
        return uniEntry;
    }

    private static void addXrefList(Uniprot uniEntry, String xrefType, String colVal) {
        if (colVal == null || colVal.length() == 0 || colVal.trim().equals("-")) {
            return;
        }
        String[] colArr = colVal.split(";");
        for (int i = 0; i < colArr.length; ++i) {
            if (colArr[i].trim().length() == 0) continue;
            ExtResourceGene extRes = null;
            if ("Entrez".equals(xrefType)) {
                extRes = new EntrezGene();
            } else if (ENSEMBL_COL.equals(xrefType)) {
                extRes = new EnsemblGene();
            }
            extRes.setID(colArr[i].trim());
            uniEntry.addXRef(xrefType, extRes);
        }
    }

    private static void addList(Uniprot uniEntry, String listType, String colVal) {
        if (colVal == null || colVal.length() == 0 || colVal.trim().equals("-")) {
            return;
        }
        String[] colArr = colVal.split(";");
        for (int i = 0; i < colArr.length; ++i) {
            if (colArr[i].trim().length() == 0) continue;
            if ("RefSeqPro".equals(listType)) {
                uniEntry.addRefSeqProID(colArr[i].trim());
                continue;
            }
            if (!"GI".equals(listType)) continue;
            uniEntry.addGI(colArr[i].trim());
        }
    }

    private static String getUniXrefType(String xrefType) {
        if ("GI".equals(xrefType)) {
            return "GI";
        }
        if ("RefSeqPro".equals(xrefType)) {
            return "RefSeq";
        }
        if ("ExtID".equals(xrefType)) {
            return XREFIDTYPE_ENTREZ;
        }
        return null;
    }

    static {
        log = GenUtil.getDefaultLog();
        DBName = DefParams.getDefaultProp("UniprotMirror");
    }
}

