/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.entity;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.genemania.dw.db.EnsemblMirrorTables;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnsemblGene
extends ExtResourceGene {
    private ArrayList<String> transcriptList = new ArrayList();
    private ArrayList<String> proteinList = new ArrayList();

    public EnsemblGene() {
        this.setSource("Ensembl");
    }

    public static TreeMap<String, ExtResource> loadAllExt(String speciesName) throws SQLException {
        TreeMap<String, ExtResource> ensMap = EnsemblMirrorTables.loadAll(speciesName, true);
        return ensMap;
    }

    public void addTranscriptID(String transID) {
        GenUtil.validateString(transID);
        if (!this.transcriptList.contains(transID)) {
            this.transcriptList.add(transID);
        }
    }

    public void removeTranscriptID(String transID) {
        GenUtil.validateString(transID);
        if (this.transcriptList.contains(transID)) {
            this.transcriptList.remove(transID);
        } else {
            System.out.println("removeTranscriptID: No such ID: " + transID);
        }
    }

    public void addProteinID(String proteinID) {
        GenUtil.validateString(proteinID);
        if (!this.proteinList.contains(proteinID)) {
            this.proteinList.add(proteinID);
        }
    }

    public void removeProteinID(String proteinID) {
        GenUtil.validateString(proteinID);
        if (this.proteinList.contains(proteinID)) {
            this.proteinList.remove(proteinID);
        } else {
            System.out.println("removeProteinID: No such ID: " + proteinID);
        }
    }

    public void addTranscripts(ArrayList<String> transcriptList) {
        if (transcriptList == null || transcriptList.size() == 0) {
            throw new IllegalArgumentException("Invalid transcript list: " + transcriptList);
        }
        this.transcriptList = transcriptList;
    }

    public void addProteins(ArrayList<String> proteinList) {
        if (proteinList == null || proteinList.size() == 0) {
            throw new IllegalArgumentException("Invalid protein list: " + proteinList);
        }
        this.proteinList = proteinList;
    }

    public ArrayList<String> getTranscripts() {
        return this.transcriptList;
    }

    public ArrayList<String> getProteins() {
        return this.proteinList;
    }

    @Override
    public String toString() {
        TreeMap<String, ExtResource> xRefEntrezMap;
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = "protein_coding".equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getTranscripts());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getProteins());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getUniprotList());
        tempStr = tempStr + "\t";
        if ("Mm".equals(this.speciesName)) {
            tempStr = GenUtil.addList(tempStr, this.getMGDList());
            tempStr = tempStr + "\t";
        }
        if ((xRefEntrezMap = this.getXRef("Entrez")) == null || xRefEntrezMap.size() == 0) {
            tempStr = tempStr + "N/A";
        } else {
            Iterator<String> iterator = xRefEntrezMap.keySet().iterator();
            boolean firstTime = true;
            while (iterator.hasNext()) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    tempStr = tempStr + ";";
                }
                String entGeneID = iterator.next();
                tempStr = tempStr + entGeneID;
            }
        }
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("RefSeqRNA"));
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("RefSeqPro"));
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedSynList());
        tempStr = tempStr + "\t";
        tempStr = this.getDefinition() != null ? tempStr + this.getDefinition() : tempStr + "N/A";
        return tempStr;
    }

    @Override
    public String toStringLeftOver(String xRefType) {
        if (!"Entrez".equals(xRefType)) {
            throw new IllegalArgumentException("No support for leftovers for: " + xRefType);
        }
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = "protein_coding".equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getUniprotList());
        tempStr = tempStr + "\t";
        if ("Mm".equals(this.speciesName)) {
            tempStr = GenUtil.addList(tempStr, this.getMGDList());
            tempStr = tempStr + "\t";
        }
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("RefSeqRNA"));
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedXrefList("RefSeqPro"));
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedSynList());
        tempStr = tempStr + "\t";
        tempStr = this.getDefinition() != null ? tempStr + this.getDefinition() : tempStr + "N/A";
        return tempStr;
    }
}

