/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.entity;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.genemania.dw.db.EntrezMirrorTables;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntrezGene
extends ExtResourceGene {
    private ArrayList<String> refSeqRNAList = new ArrayList();
    private ArrayList<String> refSeqProList = new ArrayList();

    public EntrezGene() {
        this.setSource("Entrez");
    }

    public static TreeMap<String, ExtResource> loadAllExt(String speciesName) throws SQLException {
        TreeMap<String, ExtResource> entMap = EntrezMirrorTables.loadAll(speciesName);
        return entMap;
    }

    public static ArrayList<ExtResourceGene> replaceGene(ExtResourceGene oldEntGene) throws RuntimeException {
        try {
            return EntrezMirrorTables.replaceGene(oldEntGene);
        }
        catch (SQLException sqlEx) {
            throw new RuntimeException(sqlEx);
        }
    }

    public static ArrayList<String> replaceGeneID(ExtResourceGene oldEntGene) throws RuntimeException {
        try {
            return EntrezMirrorTables.replaceGeneID(oldEntGene);
        }
        catch (SQLException sqlEx) {
            throw new RuntimeException(sqlEx);
        }
    }

    public void addRefSeqRNAID(String refSeqRNAID) {
        GenUtil.validateString(refSeqRNAID);
        if (!this.refSeqRNAList.contains(refSeqRNAID)) {
            this.refSeqRNAList.add(refSeqRNAID);
        }
    }

    public void removeRefSeqRNAID(String refSeqRNAID) {
        GenUtil.validateString(refSeqRNAID);
        if (this.refSeqRNAList.contains(refSeqRNAID)) {
            this.refSeqRNAList.remove(refSeqRNAID);
        } else {
            System.out.println("removeRefSeqRNAID: No such ID: " + refSeqRNAID);
        }
    }

    public void addRefSeqProID(String refSeqProID) {
        GenUtil.validateString(refSeqProID);
        if (!this.refSeqProList.contains(refSeqProID)) {
            this.refSeqProList.add(refSeqProID);
        }
    }

    public void removeRefSeqProID(String refSeqProID) {
        GenUtil.validateString(refSeqProID);
        if (this.refSeqProList.contains(refSeqProID)) {
            this.refSeqProList.remove(refSeqProID);
        } else {
            System.out.println("removeRefSeqProID: No such ID: " + refSeqProID);
        }
    }

    public ArrayList<String> getRefSeqRNAList() {
        return this.refSeqRNAList;
    }

    public ArrayList<String> getRefSeqProList() {
        return this.refSeqProList;
    }

    @Override
    public String toString() {
        TreeMap<String, ExtResource> xRefEnsemblMap;
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = "protein-coding".equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getUniprotList());
        tempStr = tempStr + "\t";
        if ("Mm".equals(this.speciesName)) {
            tempStr = GenUtil.addList(tempStr, this.getMGDList());
            tempStr = tempStr + "\t";
        }
        if ((xRefEnsemblMap = this.getXRef("Ensembl")) == null || xRefEnsemblMap.size() == 0) {
            tempStr = tempStr + "N/A";
        } else {
            Iterator<String> iterator = xRefEnsemblMap.keySet().iterator();
            boolean firstTime = true;
            while (iterator.hasNext()) {
                String ensGeneID = iterator.next();
                tempStr = tempStr + ensGeneID;
                if (firstTime) {
                    firstTime = false;
                    continue;
                }
                tempStr = tempStr + ";";
            }
        }
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefSeqRNAList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefSeqProList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedSynList());
        tempStr = tempStr + "\t";
        tempStr = this.getDefinition() != null ? tempStr + this.getDefinition() : tempStr + "N/A";
        return tempStr;
    }

    public String toStringTAIR() {
        return this.toStringBuild(true);
    }

    public String toStringEcoli() {
        return this.toStringBuild(false);
    }

    private String toStringBuild(boolean xRefTair) {
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = "protein-coding".equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getUniprotList());
        tempStr = tempStr + "\t";
        if (xRefTair) {
            TreeMap<String, ExtResource> xRefTAIRMap = this.getXRef("TAIR");
            if (xRefTAIRMap == null || xRefTAIRMap.size() == 0) {
                tempStr = tempStr + "N/A";
            } else {
                Iterator<String> iterator = xRefTAIRMap.keySet().iterator();
                boolean firstTime = true;
                while (iterator.hasNext()) {
                    String tGeneID = iterator.next();
                    tempStr = tempStr + tGeneID;
                    if (firstTime) {
                        firstTime = false;
                        continue;
                    }
                    tempStr = tempStr + ";";
                }
            }
            tempStr = tempStr + "\t";
        }
        tempStr = GenUtil.addList(tempStr, this.getRefSeqRNAList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefSeqProList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedSynList());
        tempStr = tempStr + "\t";
        tempStr = this.getDefinition() != null ? tempStr + this.getDefinition() : tempStr + "N/A";
        return tempStr;
    }

    @Override
    public String toStringLeftOver(String xRefType) {
        if ("Ensembl".equals(xRefType)) {
            return this.toStringLeftOverEns();
        }
        if ("TAIR".equals(xRefType)) {
            return this.toStringLeftOverTAIR();
        }
        throw new IllegalArgumentException("No support for leftovers for: " + xRefType);
    }

    private String toStringLeftOverEns() {
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = "protein-coding".equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getUniprotList());
        tempStr = tempStr + "\t";
        if ("Mm".equals(this.speciesName)) {
            tempStr = GenUtil.addList(tempStr, this.getMGDList());
            tempStr = tempStr + "\t";
        }
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefSeqRNAList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefSeqProList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getSynList());
        tempStr = tempStr + "\t";
        tempStr = this.getDefinition() != null ? tempStr + this.getDefinition() : tempStr + "N/A";
        return tempStr;
    }

    private String toStringLeftOverTAIR() {
        String tempStr = this.getDBID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = "protein-coding".equals(this.getType()) ? tempStr + "True" : tempStr + "False";
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getUniprotList());
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefSeqRNAList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefSeqProList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefinedSynList());
        tempStr = tempStr + "\t";
        tempStr = this.getDefinition() != null ? tempStr + this.getDefinition() : tempStr + "N/A";
        return tempStr;
    }
}

