/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.entity;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.genemania.dw.db.UniprotMirrorTables;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uniprot
extends ExtResource {
    private int speciesID;
    private ArrayList<String> refSeqProList = new ArrayList();
    private ArrayList<String> GIList = new ArrayList();

    public Uniprot() {
        this.setSource("Uniprot");
    }

    public static TreeMap<String, ExtResource> loadAllExt(int speciesID) throws SQLException {
        TreeMap<String, ExtResource> uniMap = UniprotMirrorTables.loadAll(speciesID);
        return uniMap;
    }

    public static TreeMap<String, ExtResource> mapToXref(String xrefType, String xrefID) throws SQLException {
        TreeMap<String, ExtResource> uniMap = UniprotMirrorTables.maptoXref(xrefType, xrefID);
        return uniMap;
    }

    public void setSpeciesID(int speciesID) {
        GenUtil.validateNonNegativeInt(speciesID);
        this.speciesID = speciesID;
    }

    public void addGI(String GI) {
        GenUtil.validateString(GI);
        if (!this.GIList.contains(GI)) {
            this.GIList.add(GI);
        }
    }

    public void removeGI(String GI) {
        GenUtil.validateString(GI);
        if (this.GIList.contains(GI)) {
            this.GIList.remove(GI);
        } else {
            System.out.println("GI ID: No such ID: " + GI);
        }
    }

    public void addRefSeqProID(String refSeqProID) {
        GenUtil.validateString(refSeqProID);
        if (!this.refSeqProList.contains(refSeqProID)) {
            this.refSeqProList.add(refSeqProID);
        }
    }

    public void removeRefSeqProID(String refSeqProID) {
        GenUtil.validateString(refSeqProID);
        if (this.refSeqProList.contains(refSeqProID)) {
            this.refSeqProList.remove(refSeqProID);
        } else {
            System.out.println("removeRefSeqProID: No such ID: " + refSeqProID);
        }
    }

    public int getSpeciesID() {
        return this.speciesID;
    }

    public ArrayList<String> getRefSeqProList() {
        return this.refSeqProList;
    }

    public ArrayList<String> getGIList() {
        return this.GIList;
    }

    @Override
    public String toString() {
        String tempStr = this.getSpeciesID() + "";
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getDBID();
        tempStr = tempStr + "\t";
        tempStr = tempStr + this.getID();
        tempStr = tempStr + "\t";
        tempStr = this.getName() != null ? tempStr + this.getName() : tempStr + "N/A";
        tempStr = tempStr + "\t";
        TreeMap<String, ExtResource> xRefEnsemblMap = this.getXRef("Ensembl");
        if (xRefEnsemblMap == null || xRefEnsemblMap.size() == 0) {
            tempStr = tempStr + "N/A";
        } else {
            Iterator<String> iterator = xRefEnsemblMap.keySet().iterator();
            boolean firstTime = true;
            while (iterator.hasNext()) {
                String ensGeneID = iterator.next();
                tempStr = tempStr + ensGeneID;
                if (firstTime) {
                    firstTime = false;
                    continue;
                }
                tempStr = tempStr + ";";
            }
        }
        tempStr = tempStr + "\t";
        TreeMap<String, ExtResource> xRefEntrezMap = this.getXRef("Entrez");
        if (xRefEntrezMap == null || xRefEntrezMap.size() == 0) {
            tempStr = tempStr + "N/A";
        } else {
            Iterator<String> iterator = xRefEntrezMap.keySet().iterator();
            boolean firstTime = true;
            while (iterator.hasNext()) {
                String ensGeneID = iterator.next();
                tempStr = tempStr + ensGeneID;
                if (firstTime) {
                    firstTime = false;
                    continue;
                }
                tempStr = tempStr + ";";
            }
        }
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getRefSeqProList());
        tempStr = tempStr + "\t";
        tempStr = GenUtil.addList(tempStr, this.getGIList());
        tempStr = tempStr + "\t";
        return tempStr;
    }
}

