/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public class DefParams {
    public static final String DB_SERVER_PROP = "DefDBServer";
    public static final String DB_USER_PROP = "DefDBUser";
    public static final String DB_PASSWD_PROP = "DefDBPasswd";
    public static final String ENSEMBL_HUMAN_SCHEMA_NAME = "Hs";
    public static final String ENSEMBL_MOUSE_SCHEMA_NAME = "Mm";
    public static final String ENSEMBL_RAT_SCHEMA_NAME = "Rn";
    public static final String ENSEMBL_YEAST_SCHEMA_NAME = "Sc";
    public static final String ENSEMBL_WORM_SCHEMA_NAME = "Ce";
    public static final String ENSEMBL_FLY_SCHEMA_NAME = "Dm";
    public static final String ENTREZ_MIRROR = "EntrezMirror";
    public static final String TAIR_MIRROR = "TAIRMirror";
    public static final String UNIPROT_MIRROR = "UniprotMirror";
    public static final String TOOLS_PATH_PROP = "DefToolsPath";
    public static final String IV_FIX_PROP = "DefIVFix";
    public static final String IV_SUM_FILE_PROP = "DefIVReportSummary";
    public static final String IV_DET_FILE_PROP = "DefIVReportDetail";
    public static final String LOG_FILE_PROP = "DefLogFile";
    public static final String PROP_FILE_NAME_PROP = "DW_PC_Props";
    public static final String FROM_SCHEMA_PATH_PROP = "DefFromSchemaPath";
    public static final String TO_SCHEMA_PATH_PROP = "DefToSchemaPath";
    public static final String XMLSTATS_FILE_PROP = "DefXMLStatsFile";
    public static final String SUPP_FILE1_NAME_PROP = "SuppFile1";
    public static final String OBO_FILE_PROP = "DefOBOFile";
    public static final String BIND_PSIMI_CV_FILE_PROP = "DefBINDPSIMICVFile";
    public static final String BIND_TRANS_COM_PROP = "DefBINDTransComplexes";
    public static final String BIND_MAP_ID_PROP = "DefBINDMapIDs";
    public static final String BIND_TRANS_PRO_PROP = "DefBINDTransProOnly";
    public static final String BIND_CLEAN_DATA_PROP = "DefBINDCleanData";
    private static ArrayList<String> defParamsList;
    private static final String PROP_FILE_PATH_DW = "./DW_PC.properties";
    private static Properties props;

    private DefParams() {
    }

    public static String[] getCommandLineArgs(String className) {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("Invalid argument: " + className);
        }
        String[] tempArr = className.split("\\.");
        String argNumStr = props.getProperty(className = tempArr[tempArr.length - 1]);
        if (argNumStr == null) {
            throw new RuntimeException("No args found for class: " + className);
        }
        int argNum = Integer.parseInt(argNumStr);
        String[] args = new String[argNum];
        for (int i = 0; i < argNum; ++i) {
            args[i] = props.getProperty(className + "_" + i).trim();
            System.out.println("args[" + i + "]: " + args[i]);
        }
        return args;
    }

    public static String getDefaultProp(String propName) {
        if (!defParamsList.contains(propName)) {
            throw new IllegalArgumentException("Invalid property name: " + propName);
        }
        String propVal = props.getProperty(propName);
        return propVal == null ? null : propVal.trim();
    }

    static {
        try {
            props = new Properties();
            String propsFileName = System.getProperty(PROP_FILE_NAME_PROP);
            if (propsFileName == null) {
                propsFileName = PROP_FILE_PATH_DW;
            }
            props.load(new FileInputStream(propsFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        defParamsList = new ArrayList();
        defParamsList.add(LOG_FILE_PROP);
        defParamsList.add(DB_SERVER_PROP);
        defParamsList.add(DB_USER_PROP);
        defParamsList.add(DB_PASSWD_PROP);
        defParamsList.add(ENSEMBL_HUMAN_SCHEMA_NAME);
        defParamsList.add(ENSEMBL_MOUSE_SCHEMA_NAME);
        defParamsList.add(ENSEMBL_RAT_SCHEMA_NAME);
        defParamsList.add(ENSEMBL_YEAST_SCHEMA_NAME);
        defParamsList.add(ENSEMBL_WORM_SCHEMA_NAME);
        defParamsList.add(ENSEMBL_FLY_SCHEMA_NAME);
        defParamsList.add(ENTREZ_MIRROR);
        defParamsList.add(TAIR_MIRROR);
        defParamsList.add(UNIPROT_MIRROR);
        defParamsList.add(TOOLS_PATH_PROP);
        defParamsList.add(IV_FIX_PROP);
        defParamsList.add(IV_SUM_FILE_PROP);
        defParamsList.add(IV_DET_FILE_PROP);
        defParamsList.add(XMLSTATS_FILE_PROP);
        defParamsList.add(FROM_SCHEMA_PATH_PROP);
        defParamsList.add(TO_SCHEMA_PATH_PROP);
        defParamsList.add(SUPP_FILE1_NAME_PROP);
        defParamsList.add(BIND_PSIMI_CV_FILE_PROP);
        defParamsList.add(OBO_FILE_PROP);
        defParamsList.add(BIND_TRANS_COM_PROP);
        defParamsList.add(BIND_MAP_ID_PROP);
        defParamsList.add(BIND_TRANS_PRO_PROP);
        defParamsList.add(BIND_CLEAN_DATA_PROP);
    }
}

