/*
 * Decompiled with CFR 0.152.
 */
package org.genemania.dw.db;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeMap;
import org.genemania.dw.db.DBUtil;
import org.genemania.dw.entity.ExtResource;
import org.genemania.dw.entity.ExtResourceGene;
import org.genemania.dw.util.GenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtResourceGeneTable {
    private static final String GMDW = "DW";
    private static final String EXT_RES_TABLE = "ExtResourceGene";
    private static final String GMID_COL = "ID";
    private static final String SOURCE_COL = "Source";
    private static final String SPECIES_COL = "Species";
    private static final String GENEID_COL = "GeneID";
    private static final String STATUS_COL = "Status";
    private static final String TIME_STAMP_COL = "TimeStamp";
    private static PrintWriter log = GenUtil.getDefaultLog();

    private ExtResourceGeneTable() {
    }

    public static void saveAll(TreeMap<String, ExtResource> extResMap) throws SQLException {
        String updateQuery = "update DW.ExtResourceGene set Status = ? where Source = ? and Species = ?";
        String insertQuery = "insert into DW.ExtResourceGene (Source, Species, GeneID, Status, TimeStamp) values (?, ?, ?, ?, CURRENT_TIMESTAMP())";
        String selectQuery = "select ID from DW.ExtResourceGene where Source = ?  and Species = ?  and GeneID = ?  and Status = ?";
        log.println(updateQuery + GenUtil.NEWLINE + insertQuery + GenUtil.NEWLINE + selectQuery);
        Connection con = null;
        PreparedStatement psUpdate = null;
        Statement psInsert = null;
        Statement psSelect = null;
        try {
            con = DBUtil.getConnection();
            psUpdate = con.prepareStatement(updateQuery);
            psUpdate.setString(1, "O");
            psUpdate.setString(2, extResMap.get(extResMap.firstKey()).getSource());
            psUpdate.setString(3, extResMap.get(extResMap.firstKey()).getSpeciesName());
            int cnt = psUpdate.executeUpdate();
            psInsert = con.prepareStatement(insertQuery);
            psSelect = con.prepareStatement(selectQuery);
            for (String extResGeneID : extResMap.keySet()) {
                ExtResourceGene extResGene = (ExtResourceGene)extResMap.get(extResGeneID);
                psInsert.setString(1, extResGene.getSource());
                psInsert.setString(2, extResGene.getSpeciesName());
                psInsert.setString(3, extResGene.getID());
                psInsert.setString(4, "C");
                cnt = psInsert.executeUpdate();
                psSelect = con.prepareStatement(selectQuery);
                psSelect.setString(1, extResGene.getSource());
                psSelect.setString(2, extResGene.getSpeciesName());
                psSelect.setString(3, extResGene.getID());
                psSelect.setString(4, "C");
                ResultSet rs = psSelect.executeQuery();
                cnt = 0;
                while (rs.next()) {
                    int GMID = rs.getInt(GMID_COL);
                    extResGene.setDBID(GMID);
                    extResGene.setStatus("C");
                    ++cnt;
                }
                if (cnt != 1) {
                    System.err.println("Error: Multiple entries for gene: " + extResGene.getSource() + " " + extResGene.getID());
                }
                extResMap.put(extResGeneID, extResGene);
            }
        }
        catch (SQLException e) {
            con.rollback();
            throw e;
        }
        finally {
            con.commit();
            if (psUpdate != null) {
                psUpdate.close();
            }
            if (psInsert != null) {
                psInsert.close();
            }
            if (psSelect != null) {
                psSelect.close();
            }
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
    }

    public static void reset() throws SQLException {
        String truncExtResQuery = "truncate table DW.ExtResourceGene";
        log.println(truncExtResQuery);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(truncExtResQuery);
            int cnt = ps.executeUpdate();
            System.out.println("Cleared: " + cnt + " ExtResource entries.");
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
    }

    public static void resetSafe() throws SQLException {
        String resetExtResQuery = "update DW.ExtResourceGene set Status = ?";
        log.println(resetExtResQuery);
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = DBUtil.getConnection();
            ps = con.prepareStatement(resetExtResQuery);
            ps.setString(1, "O");
            int cnt = ps.executeUpdate();
            System.out.println("Reset: " + cnt + " ExtResource entries.");
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (con != null && !con.isClosed()) {
                con.close();
            }
        }
    }
}

