/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml;

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Map;
import psidev.psi.mi.xml.PsimiXmlReaderRuntimeException;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.PsimiXmlExtractor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionIterator
implements Iterator<Interaction> {
    private PsimiXmlFileIndex index;
    private File file;
    private Map<Integer, InputStreamRange> interactionId2position;
    private Iterator<Map.Entry<Integer, InputStreamRange>> iterator;
    private PsimiXmlExtractor psimiXmlExtractor;

    public InteractionIterator(PsimiXmlFileIndex index, File file) throws Exception {
        this.index = index;
        this.file = file;
        this.interactionId2position = index.getInteractionId2position();
        this.iterator = this.interactionId2position.entrySet().iterator();
        this.psimiXmlExtractor = new PsimiXmlExtractor(index);
    }

    private Interaction getInteractionById(int id) {
        Interaction interaction;
        try {
            FileInputStream fis = new FileInputStream(this.file);
            interaction = this.psimiXmlExtractor.getInteractionById(fis, id);
            this.psimiXmlExtractor.resolveReferences(fis, interaction);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderRuntimeException("An error occured while parsing interaction", e);
        }
        return interaction;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Interaction next() {
        Map.Entry<Integer, InputStreamRange> entry = this.iterator.next();
        Interaction interaction = this.getInteractionById(entry.getKey());
        this.psimiXmlExtractor.clearExperimentCache();
        return interaction;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Interaction iterator is read only, you cannot remove elements.");
    }
}

