/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml;

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.Map;
import psidev.psi.mi.xml.PsimiXmlReaderRuntimeException;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.xmlindex.InputStreamRange;
import psidev.psi.mi.xml.xmlindex.PsimiXmlExtractor;
import psidev.psi.mi.xml.xmlindex.PsimiXmlFileIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractorIterator
implements Iterator<Interactor> {
    private PsimiXmlFileIndex index;
    private File file;
    private Map<Integer, InputStreamRange> interactorId2position;
    private Iterator<Map.Entry<Integer, InputStreamRange>> iterator;
    private PsimiXmlExtractor psimiXmlExtractor;

    public InteractorIterator(PsimiXmlFileIndex index, File file) throws Exception {
        this.index = index;
        this.file = file;
        this.interactorId2position = index.getInteractorId2position();
        this.iterator = this.interactorId2position.entrySet().iterator();
        this.psimiXmlExtractor = new PsimiXmlExtractor(index);
    }

    private Interactor getInteractorById(int id) {
        try {
            FileInputStream fis = new FileInputStream(this.file);
            return this.psimiXmlExtractor.getInteractorById(fis, id);
        }
        catch (Exception e) {
            throw new PsimiXmlReaderRuntimeException("An error occured while retreiving interactor id:" + id, e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Interactor next() {
        Map.Entry<Integer, InputStreamRange> entry = this.iterator.next();
        return this.getInteractorById(entry.getKey());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Interaction iterator is read only, you cannot remove elements.");
    }
}

