/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.xml.converter;

import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.converter.CvTypeConverter;
import psidev.psi.mi.xml.dao.DAOFactory;
import psidev.psi.mi.xml.jaxb.ExperimentRefListType;
import psidev.psi.mi.xml.jaxb.ParticipantType;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.ExperimentRef;
import psidev.psi.mi.xml.model.ExperimentalPreparation;

public class ExperimentalPreparationConverter {
    private CvTypeConverter cvTypeConverter = new CvTypeConverter();
    private DAOFactory factory;

    public void setDAOFactory(DAOFactory factory) {
        this.factory = factory;
    }

    private void checkDependencies() throws ConverterException {
        if (this.factory == null) {
            throw new ConverterException("Please set a DAO factory in order to resolve experiment's id.");
        }
    }

    public ExperimentalPreparation fromJaxb(ParticipantType.ExperimentalPreparationList.ExperimentalPreparation jExperimentalPreparation) throws ConverterException {
        if (jExperimentalPreparation == null) {
            throw new IllegalArgumentException("You must give a non null JAXB Experimental preparation.");
        }
        ExperimentalPreparation mExperimentalPreparation = this.cvTypeConverter.fromJaxb(jExperimentalPreparation, ExperimentalPreparation.class);
        if (jExperimentalPreparation.getExperimentRefList() != null) {
            for (Integer jExperimentId : jExperimentalPreparation.getExperimentRefList().getExperimentRef()) {
                ExperimentDescription mExperiment = this.factory.getExperimentDAO().retreive(jExperimentId);
                if (mExperiment == null) {
                    mExperimentalPreparation.getExperimentRefs().add(new ExperimentRef(jExperimentId));
                    continue;
                }
                mExperimentalPreparation.getExperiments().add(mExperiment);
            }
        }
        return mExperimentalPreparation;
    }

    public ParticipantType.ExperimentalPreparationList.ExperimentalPreparation toJaxb(ExperimentalPreparation mExperimentalPreparation) throws ConverterException {
        ParticipantType.ExperimentalPreparationList.ExperimentalPreparation jExperimentalPreparation;
        block6: {
            block5: {
                if (mExperimentalPreparation == null) {
                    throw new IllegalArgumentException("You must give a non null model Experimental preparation.");
                }
                jExperimentalPreparation = this.cvTypeConverter.toJaxb(mExperimentalPreparation, ParticipantType.ExperimentalPreparationList.ExperimentalPreparation.class);
                if (!mExperimentalPreparation.hasExperiments()) break block5;
                if (jExperimentalPreparation.getExperimentRefList() == null) {
                    jExperimentalPreparation.setExperimentRefList(new ExperimentRefListType());
                }
                for (ExperimentDescription mExperiment : mExperimentalPreparation.getExperiments()) {
                    jExperimentalPreparation.getExperimentRefList().getExperimentRef().add(mExperiment.getId());
                }
                break block6;
            }
            if (!mExperimentalPreparation.hasExperimentRefs()) break block6;
            if (jExperimentalPreparation.getExperimentRefList() == null) {
                jExperimentalPreparation.setExperimentRefList(new ExperimentRefListType());
            }
            for (ExperimentRef mExperiment : mExperimentalPreparation.getExperimentRefs()) {
                jExperimentalPreparation.getExperimentRefList().getExperimentRef().add(mExperiment.getRef());
            }
        }
        return jExperimentalPreparation;
    }
}

